/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.services;

import com.sun.jaspic.services.AuthConfigRegistrationWrapper;
import com.sun.jaspic.services.ConfigData;
import com.sun.jaspic.services.RegistrationWrapperRemover;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.AuthConfig;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ClientAuthContext;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;

public abstract class JaspicServices {
    protected static final AuthConfigFactory factory = AuthConfigFactory.getFactory();
    private ReadWriteLock readWriteLock;
    private Lock readLock;
    private Lock writeLock;
    protected String layer;
    protected String appCtxt;
    protected Map<String, ?> map;
    protected CallbackHandler callbackHandler;
    protected AuthConfigRegistrationWrapper listenerWrapper;

    protected void init(String layer, String appContext, Map<String, ?> map, CallbackHandler callbackHandler, RegistrationWrapperRemover removerDelegate) {
        this.layer = layer;
        this.appCtxt = appContext;
        this.map = map;
        this.callbackHandler = callbackHandler;
        if (this.callbackHandler == null) {
            this.callbackHandler = this.getCallbackHandler();
        }
        this.readWriteLock = new ReentrantReadWriteLock(true);
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.listenerWrapper = new AuthConfigRegistrationWrapper(this.layer, this.appCtxt, removerDelegate);
    }

    public void setRegistrationId(String registrationId) {
        this.listenerWrapper.setRegistrationId(registrationId);
    }

    public AuthConfigRegistrationWrapper getRegistrationWrapper() {
        return this.listenerWrapper;
    }

    public void setRegistrationWrapper(AuthConfigRegistrationWrapper wrapper) {
        this.listenerWrapper = wrapper;
    }

    public AuthConfigRegistrationWrapper.AuthConfigRegistrationListener getRegistrationListener() {
        return this.listenerWrapper.getListener();
    }

    public void disable() {
        this.listenerWrapper.disable();
    }

    public Object getProperty(String key) {
        return this.map == null ? null : this.map.get(key);
    }

    public String getAppContextID() {
        return this.appCtxt;
    }

    public ClientAuthConfig getClientAuthConfig() throws AuthException {
        return (ClientAuthConfig)this.getAuthConfig(false);
    }

    public ServerAuthConfig getServerAuthConfig() throws AuthException {
        return (ServerAuthConfig)this.getAuthConfig(true);
    }

    public ClientAuthContext getClientAuthContext(MessageInfo info, Subject clientSubject) throws AuthException {
        ClientAuthConfig clientConfig = (ClientAuthConfig)this.getAuthConfig(false);
        if (clientConfig != null) {
            return clientConfig.getAuthContext(clientConfig.getAuthContextID(info), clientSubject, this.map);
        }
        return null;
    }

    public ServerAuthContext getServerAuthContext(MessageInfo info, Subject serviceSubject) throws AuthException {
        ServerAuthConfig serverAuthConfig = (ServerAuthConfig)this.getAuthConfig(true);
        if (serverAuthConfig != null) {
            return serverAuthConfig.getAuthContext(serverAuthConfig.getAuthContextID(info), serviceSubject, this.map);
        }
        return null;
    }

    protected AuthConfig getAuthConfig(AuthConfigProvider authConfigProvider, boolean isServer) throws AuthException {
        AuthConfig authConfig = null;
        if (authConfigProvider != null) {
            authConfig = isServer ? authConfigProvider.getServerAuthConfig(this.layer, this.appCtxt, this.callbackHandler) : authConfigProvider.getClientAuthConfig(this.layer, this.appCtxt, this.callbackHandler);
        }
        return authConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthConfig getAuthConfig(boolean isServer) throws AuthException {
        ConfigData configData = null;
        AuthConfig authConfig = null;
        boolean disabled = false;
        AuthConfigProvider lastConfigProvider = null;
        try {
            this.readLock.lock();
            boolean bl = disabled = !this.listenerWrapper.isEnabled();
            if (!disabled && (configData = this.listenerWrapper.getConfigData()) != null) {
                authConfig = isServer ? configData.getServerConfig() : configData.getClientConfig();
                lastConfigProvider = configData.getProvider();
            }
        }
        finally {
            this.readLock.unlock();
            if (disabled || authConfig != null || configData != null && lastConfigProvider == null) {
                return authConfig;
            }
        }
        if (configData == null) {
            try {
                this.writeLock.lock();
                if (this.listenerWrapper.getConfigData() == null) {
                    AuthConfigProvider nextConfigProvider = factory.getConfigProvider(this.layer, this.appCtxt, this.getRegistrationListener());
                    if (nextConfigProvider != null) {
                        this.listenerWrapper.setConfigData(new ConfigData(nextConfigProvider, this.getAuthConfig(nextConfigProvider, isServer)));
                    } else {
                        this.listenerWrapper.setConfigData(new ConfigData());
                    }
                }
                configData = this.listenerWrapper.getConfigData();
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return isServer ? configData.getServerConfig() : configData.getClientConfig();
    }

    protected boolean hasExactMatchAuthProvider() {
        boolean exactMatch = false;
        AuthConfigProvider configProvider = factory.getConfigProvider(this.layer, this.appCtxt, null);
        if (configProvider != null) {
            for (String registrationId : factory.getRegistrationIDs(configProvider)) {
                AuthConfigFactory.RegistrationContext registrationContext = factory.getRegistrationContext(registrationId);
                if (!this.layer.equals(registrationContext.getMessageLayer()) || !this.appCtxt.equals(registrationContext.getAppContext())) continue;
                exactMatch = true;
                break;
            }
        }
        return exactMatch;
    }

    protected CallbackHandler getCallbackHandler() {
        return null;
    }
}

