/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.monitor.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-monitoring-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="set.monitoring.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-monitoring-configuration", description="This command can be used to configure all the monitoring related configuration")})
public class SetMonitoringConfiguration
implements AdminCommand {
    private static final Logger logger = Logger.getLogger(SetMonitoringConfiguration.class.getName());
    @Inject
    private Target targetUtil;
    @Param(optional=true, alias="enabled")
    private Boolean monitoringServiceEnabled;
    @Param(optional=true, alias="mbeanEnabled")
    private Boolean mbeansEnabled;
    @Param(optional=true)
    private Boolean dTraceEnabled;
    @Param(optional=true)
    private Boolean amxEnabled;
    @Param(optional=true)
    private Boolean jmxLogEnabled;
    @Param(optional=true)
    private String jmxLogFrequency;
    @Param(optional=true, acceptableValues="NANOSECONDS,MILLISECONDS,SECONDS,MINUTES,HOURS,DAYS")
    private String jmxLogFrequencyUnit;
    @Param(name="addattribute", optional=true, multiple=true, alias="addproperty")
    private List<String> attributesToAdd;
    @Param(name="delattribute", optional=true, multiple=true, alias="delproperty")
    private List<String> attributesToRemove;
    @Param(optional=true)
    private Boolean restMonitoringEnabled;
    @Param(optional=true)
    private String restMonitoringApplicationName;
    @Param(optional=true)
    private String restMonitoringContextRoot;
    @Param(optional=true)
    private Boolean restMonitoringSecurityEnabled;
    @Param(optional=true, defaultValue="false")
    private Boolean dynamic;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    private CommandRunner commandRunner;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Config config = this.targetUtil.getConfig(this.target);
        MonitoringService monitorServiceConfig = (MonitoringService)config.getExtensionByType(MonitoringService.class);
        if (monitorServiceConfig != null) {
            try {
                ConfigSupport.apply(monitorServiceConfigProxy -> {
                    if (this.monitoringServiceEnabled != null) {
                        monitorServiceConfigProxy.setMonitoringEnabled(String.valueOf(this.monitoringServiceEnabled));
                    }
                    if (this.mbeansEnabled != null) {
                        monitorServiceConfigProxy.setMbeanEnabled(String.valueOf(this.mbeansEnabled));
                    }
                    if (this.dTraceEnabled != null) {
                        monitorServiceConfigProxy.setMbeanEnabled(String.valueOf(this.dTraceEnabled));
                    }
                    actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    return monitorServiceConfigProxy;
                }, (ConfigBeanProxy)monitorServiceConfig);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.WARNING, "Exception during command ", ex);
                actionReport.setMessage(ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        CommandRunner.CommandInvocation commandInvocation = this.commandRunner.getCommandInvocation("set-jmx-monitoring-configuration", actionReport, context.getSubject());
        ParameterMap commandParameters = new ParameterMap();
        if (this.jmxLogEnabled != null) {
            commandParameters.add("enabled", this.jmxLogEnabled.toString());
        }
        if (this.jmxLogFrequency != null) {
            commandParameters.add("logfrequency", this.jmxLogFrequency);
        }
        if (this.jmxLogFrequencyUnit != null) {
            commandParameters.add("logfrequencyunit", this.jmxLogFrequencyUnit);
        }
        if (this.attributesToAdd != null) {
            for (String attributeToAdd : this.attributesToAdd) {
                commandParameters.add("addattribute", attributeToAdd);
            }
        }
        if (this.attributesToRemove != null) {
            for (String attributeToRemove : this.attributesToRemove) {
                commandParameters.add("delattribute", attributeToRemove);
            }
        }
        if (this.dynamic.booleanValue()) {
            commandParameters.add("dynamic", this.dynamic.toString());
        }
        commandParameters.add("target", this.target);
        commandInvocation.parameters(commandParameters);
        commandInvocation.execute();
        if (actionReport.getActionExitCode() != ActionReport.ExitCode.SUCCESS && actionReport.getActionExitCode() != ActionReport.ExitCode.WARNING) {
            this.failureMessage(actionReport);
            return;
        }
        if (this.amxEnabled != null) {
            commandInvocation = this.commandRunner.getCommandInvocation("set-amx-enabled", actionReport, context.getSubject());
            commandParameters = new ParameterMap();
            commandParameters.add("enabled", this.amxEnabled.toString());
            commandParameters.add("dynamic", this.dynamic.toString());
            commandParameters.add("target", this.target);
            commandInvocation.parameters(commandParameters);
            commandInvocation.execute();
            if (actionReport.getActionExitCode() != ActionReport.ExitCode.SUCCESS && actionReport.getActionExitCode() != ActionReport.ExitCode.WARNING) {
                this.failureMessage(actionReport);
                return;
            }
        }
        commandInvocation = this.commandRunner.getCommandInvocation("set-rest-monitoring-configuration", actionReport, context.getSubject());
        commandParameters = new ParameterMap();
        if (this.restMonitoringEnabled != null) {
            commandParameters.add("enabled", this.restMonitoringEnabled.toString());
        }
        if (this.restMonitoringContextRoot != null) {
            commandParameters.add("contextroot", this.restMonitoringContextRoot);
        }
        if (this.restMonitoringApplicationName != null) {
            commandParameters.add("applicationname", this.restMonitoringApplicationName);
        }
        if (this.restMonitoringSecurityEnabled != null) {
            commandParameters.add("securityenabled", this.restMonitoringSecurityEnabled.toString());
        }
        commandParameters.add("target", this.target);
        commandInvocation.parameters(commandParameters);
        commandInvocation.execute();
        if (actionReport.getActionExitCode() != ActionReport.ExitCode.SUCCESS && actionReport.getActionExitCode() != ActionReport.ExitCode.WARNING) {
            this.failureMessage(actionReport);
            return;
        }
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void failureMessage(ActionReport actionReport) {
        String message = "Failed to execute the command";
        logger.warning(message);
        actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        actionReport.setMessage(message);
    }
}

