/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.cli.CLIContainer;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Service;

@Service(name="generate-bash-autocomplete")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@AccessRequired(resource={"domain"}, action={"read"})
public class GenerateBashAutoCompletionCommand
implements AdminCommand {
    private static final String VARNAME = "__asadmin_commands=\"";
    private static final String BASH_FUNCTION = "_asadmin()\n{\n\n    local cur prev opts\n    COMREPLY=()\n    cur=\"${COMP_WORDS[COMP_CWORD]}\"\n    #prev=\"${COMP_WORDS[COMP_CWORD-1]}\"\n\n    COMPREPLY=( $(compgen -W \"${__asadmin_commands}\" -- ${cur}))\n\n}\n";
    private static final String COMPLETE_CALL = "complete -F _asadmin asadmin";
    private static final String ADD_PATH = "PATH=$PATH:";
    private static final String DEFAULT_FILE = File.separator + "bin" + File.separator + "bash_autocomplete";
    private static final LocalStringsImpl strings = new LocalStringsImpl(GenerateBashAutoCompletionCommand.class);
    private final Logger LOGGER = Logger.getLogger(GenerateBashAutoCompletionCommand.class.getName());
    @Param(optional=true, primary=true, name="file")
    String filePath;
    @Param(optional=true, defaultValue="false")
    Boolean force;
    @Param(optional=true, defaultValue="false")
    Boolean localCommands;
    @Inject
    ServiceLocator habitat;
    @Inject
    ServerContext serverContext;
    private CLIContainer cliContainer;
    private File file;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.validate()) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Unable to write to file at " + this.filePath + ", see server.log for details");
            return;
        }
        ArrayList<String> commandNames = new ArrayList<String>();
        List allCommandHandles = this.habitat.getAllServiceHandles(AdminCommand.class, new Annotation[0]);
        for (ServiceHandle commandHandler : allCommandHandles) {
            AdminCommand trueCommand = (AdminCommand)commandHandler.getService();
            CommandModelImpl model = new CommandModelImpl(trueCommand.getClass());
            if (model.getCommandName() == null || model.getCommandName().startsWith("_")) continue;
            commandNames.add(model.getCommandName());
        }
        if (this.localCommands.booleanValue()) {
            ClassLoader classLoader = GenerateBashAutoCompletionCommand.class.getClassLoader();
            this.cliContainer = new CLIContainer(classLoader, this.getExtensions(), this.LOGGER);
            Arrays.stream(CLIUtil.getLocalCommands((CLIContainer)this.cliContainer)).forEach(commandName -> {
                if (commandName == null || commandName.startsWith("_")) {
                    return;
                }
                commandNames.add((String)commandName);
            });
        }
        if (this.writeCommands(commandNames)) {
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage("Written bash autocomplete file to " + this.filePath);
        } else {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Unable to write to file at " + this.filePath + ", see server.log for details");
        }
    }

    private Set<File> getExtensions() {
        HashSet<File> result = new HashSet<File>();
        File inst = new File(System.getProperty("com.sun.aas.installRoot"));
        File ext = new File(new File(inst, "lib"), "asadmin");
        if (ext.exists() && ext.isDirectory()) {
            result.add(ext);
        } else if (this.LOGGER.isLoggable(Level.FINER)) {
            this.LOGGER.finer(strings.get("ExtDirMissing", new Object[]{ext}));
        }
        result.add(new File(new File(inst, "modules"), "admin-cli.jar"));
        return result;
    }

    private boolean validate() {
        try {
            if (this.filePath == null) {
                this.filePath = this.serverContext.getInstallRoot().getCanonicalPath() + DEFAULT_FILE;
            }
            this.file = new File(this.filePath);
            if (this.file.exists() && this.file.isFile() && this.force.booleanValue() || this.file.createNewFile()) {
                return true;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(GenerateBashAutoCompletionCommand.class.getName()).log(Level.WARNING, "Unable to create file at {0}:{1}", new Object[]{this.filePath, ex.getMessage()});
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeCommands(List<String> commands) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));){
            writer.write(VARNAME);
            for (String command : commands) {
                writer.write(command);
                writer.newLine();
            }
            writer.write("\"");
            writer.newLine();
            writer.write(BASH_FUNCTION);
            writer.newLine();
            writer.write(COMPLETE_CALL);
            writer.newLine();
            writer.write(ADD_PATH);
            writer.write(this.serverContext.getInstallRoot().getPath() + File.separator + "bin");
            writer.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            Logger.getLogger(GenerateBashAutoCompletionCommand.class.getName()).log(Level.WARNING, "Unable to write to file at " + this.filePath, ex);
            return false;
        }
    }
}

