/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.bootstrap;

import com.sun.enterprise.module.bootstrap.StartupContext;
import fish.payara.boot.runtime.BootCommands;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=9)
public class BootCommandService
implements PostConstruct {
    private static final Logger LOGGER = Logger.getLogger(BootCommandService.class.getName());
    @Inject
    StartupContext startupContext;
    @Inject
    CommandRunner commandRunner;

    public void doBootCommands(String file) {
        if (file == null) {
            return;
        }
        try {
            BootCommands bootCommands = new BootCommands();
            System.out.println("Reading in commands from " + file);
            bootCommands.parseCommandScript(new File(file));
            bootCommands.executeCommands(this.commandRunner);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Error reading from file");
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public void postConstruct() {
        this.doBootCommands(this.startupContext.getArguments().getProperty("-postbootcommandfile"));
    }
}

