/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor.stats;

import com.sun.enterprise.v3.services.impl.monitor.stats.ThreadPoolStatsProvider;
import java.util.Set;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="thread-pool-mon", group="monitoring")
@ManagedObject
@Description(value="Thread Pool Statistics")
public class ThreadPoolStatsProviderGlobal
extends ThreadPoolStatsProvider {
    public ThreadPoolStatsProviderGlobal(String name) {
        super(name);
    }

    @Override
    @ManagedAttribute(id="currentthreadcount")
    @Description(value="Provides the number of request processing threads currently in the listener thread pool")
    public CountStatistic getCurrentThreadCount() {
        this.countThreadsInThreadPools();
        return this.currentThreadCount;
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:setMaxThreadsEvent")
    public void setMaxThreadsEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="maxNumberOfThreads") int maxNumberOfThreads) {
        this.maxThreadsCount.setCount((long)maxNumberOfThreads);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:setCoreThreadsEvent")
    public void setCoreThreadsEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="coreNumberOfThreads") int coreNumberOfThreads) {
        this.coreThreadsCount.setCount((long)coreNumberOfThreads);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:threadDispatchedFromPoolEvent")
    public void threadDispatchedFromPoolEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadId") long threadId) {
        this.currentThreadsBusy.increment();
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:threadReturnedToPoolEvent")
    public void threadReturnedToPoolEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadId") long threadId) {
        this.totalExecutedTasksCount.increment();
        if (this.currentThreadsBusy.getCount() > 0L) {
            this.currentThreadsBusy.decrement();
        }
    }

    private void countThreadsInThreadPools() {
        this.currentThreadCount.setCount(0L);
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        block0: for (Thread thread : threads) {
            String threadName = thread.getName();
            for (String threadPoolName : threadPoolNames) {
                if (!thread.isAlive() || !threadName.contains(threadPoolName + "(")) continue;
                this.currentThreadCount.increment();
                continue block0;
            }
        }
    }

    public void subtractBusyThreads(long busyThreads) {
        long busyThreadsCount = this.currentThreadsBusy.getCount() - busyThreads;
        if (busyThreadsCount > 0L) {
            this.currentThreadsBusy.setCount(this.currentThreadsBusy.getCount() - busyThreads);
        } else {
            this.currentThreadsBusy.setCount(0L);
        }
    }

    @Override
    @Reset
    public void reset() {
    }
}

