/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.payload;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.Payload;

public abstract class PayloadFilesManager {
    private static final String XFER_DIR_PREFIX = "xfer-";
    public static final LocalStringManagerImpl strings = new LocalStringManagerImpl(PayloadFilesManager.class);
    private final File targetDir;
    protected final Logger logger;
    private final ActionReport report;
    private final ActionReportHandler reportHandler;
    protected final Map<File, Long> dirTimestamps = new HashMap<File, Long>();

    private PayloadFilesManager(File targetDir, ActionReport report, Logger logger, ActionReportHandler reportHandler) {
        this.targetDir = targetDir;
        this.report = report;
        this.logger = logger;
        this.reportHandler = reportHandler;
    }

    private PayloadFilesManager(File targetDir, ActionReport report, Logger logger) {
        this(targetDir, report, logger, (ActionReportHandler)null);
    }

    protected File getTargetDir() {
        return this.targetDir;
    }

    protected URI getParentURI(Payload.Part part) {
        File parentFile = this.getTargetDir();
        URI parentFileURI = parentFile.toURI();
        Properties partProps = part.getProperties();
        String parentPathFromPart = partProps.getProperty("file-xfer-root");
        if (parentPathFromPart != null) {
            File xferRootFile;
            if (!parentPathFromPart.endsWith(File.separator)) {
                parentPathFromPart = parentPathFromPart + File.separator;
            }
            parentFile = (xferRootFile = new File(parentPathFromPart)).isAbsolute() ? xferRootFile : new File(parentFile, parentPathFromPart);
            parentFileURI = URI.create(parentFile.toURI().toASCIIString() + (parentFile.exists() ? "" : "/"));
        }
        return parentFileURI;
    }

    protected abstract void postExtract(File var1);

    protected URI getOutputFileURI(Payload.Part part, String name) throws IOException {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return this.getParentURI(part).resolve(name);
    }

    private File removeFile(Payload.Part part) throws IOException {
        File result = this.removeFileWithoutConsumingPartBody(part);
        this.consumePartBody(part);
        return result;
    }

    private File removeFileWithoutConsumingPartBody(Payload.Part part) throws IOException {
        boolean isFine = this.logger.isLoggable(Level.FINE);
        File targetFile = new File(this.getOutputFileURI(part, part.getName()));
        if (targetFile.exists()) {
            boolean isRemovalRecursive;
            boolean bl = isRemovalRecursive = targetFile.isDirectory() && part.isRecursive();
            if (isRemovalRecursive ? FileUtils.whack(targetFile) : targetFile.delete()) {
                if (isFine) {
                    this.logger.log(Level.FINER, "Deleted {0}{1} as requested", new Object[]{targetFile.getAbsolutePath(), isRemovalRecursive ? " recursively" : ""});
                }
                this.reportDeletionSuccess();
            } else {
                if (isFine) {
                    this.logger.log(Level.FINER, "File {0} ({1}) requested for deletion exists but was not able to be deleted", new Object[]{part.getName(), targetFile.getAbsolutePath()});
                }
                this.reportDeletionFailure(part.getName(), strings.getLocalString("payload.deleteFailedOnFile", "Requested deletion of {0} failed; the file was found but the deletion attempt failed - no reason is available"));
            }
        } else {
            if (isFine) {
                this.logger.log(Level.FINER, "File {0} ({1}) requested for deletion does not exist.", new Object[]{part.getName(), targetFile.getAbsolutePath()});
            }
            this.reportDeletionFailure(part.getName(), new FileNotFoundException(targetFile.getAbsolutePath()));
        }
        return targetFile;
    }

    private File replaceFile(Payload.Part part) throws IOException {
        this.removeFileWithoutConsumingPartBody(part);
        return this.extractFile(part, part.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumePartBody(Payload.Part part) throws FileNotFoundException, IOException {
        try (InputStream is = null;){
            is = part.getInputStream();
            byte[] buffer = new byte[65536];
            while (is.read(buffer) != -1) {
            }
        }
    }

    private void processReport(Payload.Part part) throws Exception {
        if (this.reportHandler != null) {
            this.reportHandler.handleReport(part.getInputStream());
        } else {
            this.consumePartBody(part);
        }
    }

    private File extractFile(Payload.Part part, String outputName) throws IOException {
        boolean isFine = this.logger.isLoggable(Level.FINE);
        OutputStream os = null;
        InputStream is = null;
        try {
            long lastModified;
            int bytesRead;
            boolean isDir;
            File extractedFile = new File(this.getOutputFileURI(part, outputName));
            File immediateParent = extractedFile.getParentFile();
            if (!immediateParent.exists() && !immediateParent.mkdirs()) {
                this.logger.log(Level.WARNING, strings.getLocalString("payload.mkdirsFailed", "Attempt to create directories for {0} failed; no further information is available. Continuing.", immediateParent.getAbsolutePath()));
            }
            if (extractedFile.exists()) {
                if (!extractedFile.delete() && !extractedFile.isDirectory()) {
                    this.logger.warning(strings.getLocalString("payload.overwrite", "Overwriting previously-uploaded file because the attempt to delete it failed: {0}", extractedFile.getAbsolutePath()));
                } else if (isFine) {
                    this.logger.log(Level.FINER, "Deleted pre-existing file {0} before extracting transferred file", extractedFile.getAbsolutePath());
                }
            }
            if (outputName.endsWith("/") && !extractedFile.exists() && !extractedFile.mkdir()) {
                this.logger.log(Level.WARNING, strings.getLocalString("payload.mkdirsFailed", "Attempt to create directories for {0} failed; no further information is available. Continuing.", extractedFile.getAbsolutePath()));
            }
            os = (isDir = extractedFile.isDirectory()) ? null : new BufferedOutputStream(new FileOutputStream(extractedFile));
            is = part.getInputStream();
            byte[] buffer = new byte[65536];
            while ((bytesRead = is.read(buffer)) != -1) {
                if (os == null) continue;
                os.write(buffer, 0, bytesRead);
            }
            if (os != null) {
                os.close();
            }
            part.setExtracted(extractedFile);
            String lastModifiedString = part.getProperties().getProperty("last-modified");
            long l = lastModified = lastModifiedString != null ? Long.parseLong(lastModifiedString) : System.currentTimeMillis();
            if (!extractedFile.setLastModified(lastModified)) {
                this.logger.log(Level.WARNING, strings.getLocalString("payload.setLatModifiedFailed", "Attempt to set lastModified for {0} failed; no further information is available.  Continuing.", extractedFile.getAbsolutePath()));
            }
            if (extractedFile.isDirectory()) {
                this.dirTimestamps.put(extractedFile, lastModified);
            }
            this.postExtract(extractedFile);
            this.logger.log(Level.FINER, "Extracted transferred entry {0} to {1}", new Object[]{part.getName(), extractedFile.getAbsolutePath()});
            this.reportExtractionSuccess();
            File file = extractedFile;
            return file;
        }
        catch (IOException e) {
            this.reportExtractionFailure(part.getName(), e);
            throw new IOException(e.getMessage(), e);
        }
        finally {
            if (os != null) {
                os.close();
                os = null;
            }
        }
    }

    public Map<File, Properties> processPartsExtended(Payload.Inbound inboundPayload) throws Exception {
        if (inboundPayload == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<File, Properties> result = new LinkedHashMap<File, Properties>();
        boolean isReportProcessed = false;
        Payload.Part possibleUnrecognizedReportPart = null;
        StringBuilder uploadedEntryNames = new StringBuilder();
        Iterator partIt = inboundPayload.parts();
        while (partIt.hasNext()) {
            Payload.Part part = (Payload.Part)partIt.next();
            DataRequestType drt = DataRequestType.getType(part);
            if (drt != null) {
                result.put(drt.processPart(this, part, part.getName()), part.getProperties());
                isReportProcessed |= drt == DataRequestType.REPORT;
                uploadedEntryNames.append(part.getName()).append(" ");
                continue;
            }
            if (isReportProcessed || possibleUnrecognizedReportPart != null) continue;
            possibleUnrecognizedReportPart = part;
        }
        if (!isReportProcessed && possibleUnrecognizedReportPart != null) {
            DataRequestType.REPORT.processPart(this, possibleUnrecognizedReportPart, possibleUnrecognizedReportPart.getName());
            isReportProcessed = true;
        }
        this.postProcessParts();
        return result;
    }

    public List<File> processParts(Payload.Inbound inboundPayload) throws Exception {
        return new ArrayList<File>(this.processPartsExtended(inboundPayload).keySet());
    }

    protected abstract void postProcessParts();

    private void reportExtractionSuccess() {
        this.reportSuccess();
    }

    private void reportSuccess() {
        if (this.report != null) {
            this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    private void reportDeletionSuccess() {
        this.reportSuccess();
    }

    private void reportDeletionFailure(String partName, String msg) {
        this.reportFailure(partName, msg, null);
    }

    private void reportDeletionFailure(String partName, Exception e) {
        this.reportFailure(partName, strings.getLocalString("payload.errDeleting", "Error deleting file {0}", partName), e);
    }

    private void reportFailure(String partName, String formattedMessage, Exception e) {
        if (this.report != null) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(formattedMessage);
            this.report.setFailureCause((Throwable)e);
        }
    }

    private void reportExtractionFailure(String partName, Exception e) {
        this.reportFailure(partName, strings.getLocalString("payload.errExtracting", "Error extracting transferred file {0}", partName), e);
    }

    private static File createTempFolder(File parent, String prefix, Logger logger) throws IOException {
        File result = File.createTempFile(prefix, "", parent);
        try {
            if (!result.delete()) {
                throw new IOException(strings.getLocalString("payload.command.errorDeletingTempFile", "Unknown error deleting temporary file {0}", result.getAbsolutePath()));
            }
            if (!result.mkdir()) {
                throw new IOException(strings.getLocalString("payload.command.errorCreatingDir", "Unknown error creating directory {0}", result.getAbsolutePath()));
            }
            logger.log(Level.FINER, "Created temporary upload folder {0}", result.getAbsolutePath());
            return result;
        }
        catch (Exception e) {
            throw new IOException(strings.getLocalString("payload.command.errorCreatingXferFolder", "Error creating temporary file transfer folder"), e);
        }
    }

    private static File createTempFolder(File parent, Logger logger) throws IOException {
        return PayloadFilesManager.createTempFolder(parent, XFER_DIR_PREFIX, logger);
    }

    private static enum DataRequestType {
        FILE_TRANSFER("file-xfer"){

            @Override
            protected File processPart(PayloadFilesManager pfm, Payload.Part part, String partName) throws Exception {
                return pfm.extractFile(part, partName);
            }
        }
        ,
        FILE_REMOVAL("file-remove"){

            @Override
            protected File processPart(PayloadFilesManager pfm, Payload.Part part, String partName) throws Exception {
                return pfm.removeFile(part);
            }
        }
        ,
        FILE_REPLACEMENT("file-replace"){

            @Override
            protected File processPart(PayloadFilesManager pfm, Payload.Part part, String partName) throws Exception {
                return pfm.replaceFile(part);
            }
        }
        ,
        REPORT("report"){

            @Override
            protected File processPart(PayloadFilesManager pfm, Payload.Part part, String partName) throws Exception {
                pfm.processReport(part);
                return null;
            }
        };

        private final String dataRequestType;

        private DataRequestType(String type) {
            this.dataRequestType = type;
        }

        protected abstract File processPart(PayloadFilesManager var1, Payload.Part var2, String var3) throws Exception;

        private static DataRequestType getType(Payload.Part part) {
            String targetDataRequestType = part.getProperties().getProperty("data-request-type");
            for (DataRequestType candidateType : DataRequestType.values()) {
                if (!candidateType.dataRequestType.equals(targetDataRequestType)) continue;
                return candidateType;
            }
            return null;
        }
    }

    public static interface ActionReportHandler {
        public void handleReport(InputStream var1) throws Exception;
    }

    public static class Temp
    extends PayloadFilesManager {
        private boolean isCleanedUp = false;

        public Temp(File parentDir, ActionReport report, Logger logger) throws IOException {
            super(PayloadFilesManager.createTempFolder(parentDir, logger), report, logger);
        }

        public Temp(ActionReport report, Logger logger) throws IOException {
            this(new File(System.getProperty("java.io.tmpdir")), report, logger);
        }

        public Temp(Logger logger) throws IOException {
            this(null, logger);
        }

        public void cleanup() {
            if (!this.isCleanedUp) {
                FileUtils.whack(((PayloadFilesManager)this).targetDir);
                this.isCleanedUp = true;
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.cleanup();
        }

        @Override
        protected void postExtract(File extractedFile) {
            FileUtils.deleteOnExit(extractedFile);
        }

        @Override
        protected void postProcessParts() {
        }
    }

    public static class Perm
    extends PayloadFilesManager {
        public Perm(File targetDir, ActionReport report, Logger logger) {
            this(targetDir, report, logger, (ActionReportHandler)null);
        }

        public Perm(File targetDir, ActionReport report, Logger logger, ActionReportHandler reportHandler) {
            super(targetDir != null ? targetDir : new File(System.getProperty("user.dir")), report, logger, reportHandler);
        }

        public Perm(ActionReport report, Logger logger) {
            this(report, logger, null);
        }

        public Perm(ActionReport report, Logger logger, ActionReportHandler reportHandler) {
            super(new File(System.getProperty("user.dir")), report, logger, reportHandler);
        }

        public Perm(Logger logger) {
            this(null, logger);
        }

        public Perm() {
            this((ActionReportHandler)null);
        }

        public Perm(ActionReportHandler reportHandler) {
            this(null, Logger.getLogger(Perm.class.getName()), reportHandler);
        }

        @Override
        protected void postExtract(File extractedFile) {
        }

        @Override
        protected void postProcessParts() {
            boolean isFine = this.logger.isLoggable(Level.FINE);
            for (Map.Entry entry : this.dirTimestamps.entrySet()) {
                if (isFine) {
                    Date when = new Date((Long)entry.getValue());
                    this.logger.log(Level.FINER, "Setting lastModified for {0} explicitly to {1}", new Object[]{((File)entry.getKey()).getAbsolutePath(), when});
                }
                if (((File)entry.getKey()).setLastModified((Long)entry.getValue())) continue;
                this.logger.log(Level.WARNING, strings.getLocalString("payload.setLatModifiedFailed", "Attempt to set lastModified for {0} failed; no further information is available.  Continuing.", ((File)entry.getKey()).getAbsoluteFile()));
            }
        }
    }
}

