/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.impl;

import com.sun.jdo.api.persistence.support.ConnectionFactory;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.api.persistence.support.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.RuntimeVersion;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.ConnectionFactoryImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.SQLPersistenceManagerFactory;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.glassfish.persistence.common.I18NHelper;

public class PersistenceManagerFactoryImpl
implements PersistenceManagerFactory {
    private String URL = null;
    private String userName = null;
    private char[] password = null;
    private String driverName = null;
    private ConnectionFactory connectionFactory = null;
    private Object dataSource = null;
    private String connectionFactoryName = null;
    private String identifier = null;
    private int connectionMaxPool = 0;
    private int connectionMinPool = 0;
    private int connectionMsInterval = 0;
    private int connectionLoginTimeout = 0;
    private int connectionMsWait = 0;
    private int txIsolation = -1;
    private transient PrintWriter connectionLogWriter;
    private boolean optimistic = true;
    private boolean retainValues = true;
    private boolean nontransactionalRead = true;
    private boolean ignoreCache = false;
    private int queryTimeout = 0;
    private int updateTimeout = 0;
    private int maxPool = 0;
    private int minPool = 0;
    private boolean supersedeDeletedInstance = true;
    private boolean requireCopyObjectId = true;
    private boolean requireTrackedSCO = true;
    private static final int NOT_SET = 0;
    private static final int SET_AS_CONNECTIONFACTORY = 1;
    private static final int SET_AS_DATASOURCE = 2;
    private int providedConnectionFactory = 0;
    private transient SQLPersistenceManagerFactory pmFactory = null;
    private static final ResourceBundle messages = I18NHelper.loadBundle(PersistenceManagerFactoryImpl.class);

    public PersistenceManagerFactoryImpl() {
        EJBHelper.setPersistenceManagerFactoryDefaults(this);
    }

    public PersistenceManagerFactoryImpl(String URL2, String userName, char[] password, String driverName) {
        EJBHelper.setPersistenceManagerFactoryDefaults(this);
        this.URL = URL2;
        this.userName = userName;
        this.password = password;
        this.driverName = driverName;
    }

    @Override
    public void setConnectionUserName(String userName) {
        this.assertNotConfigured();
        this.userName = userName;
    }

    @Override
    public String getConnectionUserName() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getUserName();
        }
        return this.userName;
    }

    @Override
    public void setConnectionPassword(char[] password) {
        this.assertNotConfigured();
        this.password = password;
    }

    @Override
    public void setConnectionURL(String URL2) {
        this.assertNotConfigured();
        this.URL = URL2;
    }

    @Override
    public String getConnectionURL() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getURL();
        }
        return this.URL;
    }

    @Override
    public void setConnectionDriverName(String driverName) {
        this.assertNotConfigured();
        this.driverName = driverName;
    }

    @Override
    public String getConnectionDriverName() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getDriverName();
        }
        return this.driverName;
    }

    @Override
    public void setConnectionFactory(Object connectionFactory) {
        this.assertNotConfigured();
        if (connectionFactory == null) {
            this.connectionFactory = null;
            this.dataSource = null;
            this.providedConnectionFactory = 0;
        } else if (EJBHelper.isManaged() || connectionFactory instanceof DataSource) {
            this.dataSource = connectionFactory;
            this.providedConnectionFactory = 2;
        } else if (connectionFactory instanceof ConnectionFactory) {
            this.connectionFactory = (ConnectionFactory)connectionFactory;
            this.providedConnectionFactory = 1;
        } else {
            throw new JDOUserException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.wrongtype"));
        }
    }

    @Override
    public Object getConnectionFactory() {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        return this.connectionFactory;
    }

    @Override
    public void setConnectionFactoryName(String connectionFactoryName) {
        this.assertNotConfigured();
        this.connectionFactoryName = connectionFactoryName;
    }

    @Override
    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.assertNotConfigured();
        this.identifier = identifier;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setConnectionMaxPool(int MaxPool) {
        this.assertNotConfigured();
        this.connectionMaxPool = MaxPool;
    }

    @Override
    public int getConnectionMaxPool() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getMaxPool();
        }
        return this.connectionMaxPool;
    }

    @Override
    public void setConnectionMinPool(int MinPool) {
        this.assertNotConfigured();
        this.connectionMinPool = MinPool;
    }

    @Override
    public int getConnectionMinPool() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getMinPool();
        }
        return this.connectionMinPool;
    }

    @Override
    public void setConnectionMsWait(int MsWait) {
        this.assertNotConfigured();
        this.connectionMsWait = MsWait;
    }

    @Override
    public int getConnectionMsWait() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getMsWait();
        }
        return this.connectionMsWait;
    }

    @Override
    public int getMaxPool() {
        return this.maxPool;
    }

    @Override
    public void setMaxPool(int MaxPool) {
        this.assertNotConfigured();
        this.maxPool = MaxPool;
    }

    @Override
    public int getMinPool() {
        return this.minPool;
    }

    @Override
    public void setMinPool(int MinPool) {
        this.assertNotConfigured();
        this.minPool = MinPool;
    }

    @Override
    public void setConnectionMsInterval(int MsInterval) {
        this.assertNotConfigured();
        this.connectionMsInterval = MsInterval;
    }

    @Override
    public int getConnectionMsInterval() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getMsInterval();
        }
        return this.connectionMsInterval;
    }

    @Override
    public void setConnectionLoginTimeout(int LoginTimeout) {
        this.assertNotConfigured();
        this.connectionLoginTimeout = LoginTimeout;
    }

    @Override
    public int getConnectionLoginTimeout() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getLoginTimeout();
        }
        return this.connectionLoginTimeout;
    }

    @Override
    public void setConnectionLogWriter(PrintWriter pw) {
        this.assertNotConfigured();
        this.connectionLogWriter = pw;
    }

    @Override
    public PrintWriter getConnectionLogWriter() {
        return this.connectionLogWriter;
    }

    public void setQueryTimeout(String timeout) {
        this.setQueryTimeout(Integer.parseInt(timeout));
    }

    @Override
    public void setQueryTimeout(int timeout) {
        this.assertNotConfigured();
        this.queryTimeout = timeout;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setUpdateTimeout(String timeout) {
        this.setUpdateTimeout(Integer.parseInt(timeout));
    }

    @Override
    public void setUpdateTimeout(int timeout) {
        this.assertNotConfigured();
        this.updateTimeout = timeout;
    }

    @Override
    public int getUpdateTimeout() {
        return this.updateTimeout;
    }

    @Override
    public void setConnectionTransactionIsolation(int level) {
        this.assertNotConfigured();
        this.txIsolation = level;
    }

    @Override
    public int getConnectionTransactionIsolation() {
        if (this.connectionFactory != null) {
            return this.connectionFactory.getTransactionIsolation();
        }
        return this.txIsolation;
    }

    public void setOptimistic(String flag) {
        this.setOptimistic(Boolean.parseBoolean(flag));
    }

    @Override
    public void setOptimistic(boolean flag) {
        this.assertNotConfigured();
        this.optimistic = flag;
        if (flag) {
            this.nontransactionalRead = flag;
        }
    }

    @Override
    public boolean getOptimistic() {
        return this.optimistic;
    }

    public void setRetainValues(String flag) {
        this.setRetainValues(Boolean.parseBoolean(flag));
    }

    @Override
    public void setRetainValues(boolean flag) {
        this.assertNotConfigured();
        this.retainValues = flag;
        if (flag) {
            this.nontransactionalRead = flag;
        }
    }

    @Override
    public boolean getRetainValues() {
        return this.retainValues;
    }

    public void setNontransactionalRead(String flag) {
        this.setNontransactionalRead(Boolean.parseBoolean(flag));
    }

    @Override
    public void setNontransactionalRead(boolean flag) {
        this.assertNotConfigured();
        this.nontransactionalRead = flag;
        if (!flag) {
            this.retainValues = flag;
            this.optimistic = flag;
        }
    }

    @Override
    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    public void setIgnoreCache(String flag) {
        this.setIgnoreCache(Boolean.parseBoolean(flag));
    }

    @Override
    public void setIgnoreCache(boolean flag) {
        this.assertNotConfigured();
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.notsupported"));
    }

    @Override
    public boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    @Override
    public Properties getProperties() {
        if (this.pmFactory != null) {
            return this.pmFactory.getProperties();
        }
        return RuntimeVersion.getVendorProperties("/com/sun/jdo/spi/persistence/support/sqlstore/sys.properties");
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(null, null);
    }

    @Override
    public boolean getSupersedeDeletedInstance() {
        return this.supersedeDeletedInstance;
    }

    @Override
    public void setSupersedeDeletedInstance(boolean flag) {
        this.assertNotConfigured();
        this.supersedeDeletedInstance = flag;
    }

    @Override
    public boolean getRequireCopyObjectId() {
        return this.requireCopyObjectId;
    }

    @Override
    public void setRequireCopyObjectId(boolean flag) {
        this.assertNotConfigured();
        this.requireCopyObjectId = flag;
    }

    @Override
    public boolean getRequireTrackedSCO() {
        return this.requireTrackedSCO;
    }

    @Override
    public void setRequireTrackedSCO(boolean flag) {
        this.assertNotConfigured();
        this.requireTrackedSCO = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistenceManager getPersistenceManager(String username, char[] passwd) {
        PersistenceManagerFactoryImpl persistenceManagerFactoryImpl = this;
        synchronized (persistenceManagerFactoryImpl) {
            if (this.pmFactory == null) {
                block16: {
                    if (this.providedConnectionFactory == 0) {
                        if (this.connectionFactoryName == null) {
                            this.assertConnectionWait();
                            this.connectionFactory = new ConnectionFactoryImpl();
                            this.connectionFactory.setURL(this.URL);
                            this.connectionFactory.setUserName(this.userName);
                            this.connectionFactory.setPassword(this.password);
                            this.connectionFactory.setDriverName(this.driverName);
                            this.connectionFactory.setMinPool(this.connectionMinPool);
                            this.connectionFactory.setMaxPool(this.connectionMaxPool);
                            this.connectionFactory.setMsWait(this.connectionMsWait);
                            this.connectionFactory.setMsInterval(this.connectionMsInterval);
                            this.connectionFactory.setLogWriter(this.connectionLogWriter);
                            this.connectionFactory.setLoginTimeout(this.connectionLoginTimeout);
                            if (this.txIsolation > 0) {
                                this.connectionFactory.setTransactionIsolation(this.txIsolation);
                            }
                        } else {
                            try {
                                InitialContext ctx = (InitialContext)Class.forName("javax.naming.InitialContext").newInstance();
                                Object o = ctx.lookup(this.connectionFactoryName);
                                if (EJBHelper.isManaged() || o instanceof DataSource) {
                                    this.dataSource = o;
                                    break block16;
                                }
                                if (o instanceof ConnectionFactory) {
                                    this.connectionFactory = (ConnectionFactory)o;
                                    break block16;
                                }
                                throw new JDOUserException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.wrongtype"));
                            }
                            catch (JDOException e) {
                                throw e;
                            }
                            catch (ClassNotFoundException e) {
                                throw new JDOUserException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.initialcontext"));
                            }
                            catch (Exception e) {
                                throw new JDOUserException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.lookup"), e);
                            }
                        }
                    }
                }
                if (this.getIdentifier() == null) {
                    this.setIdentifier(this.getConnectionFactoryName());
                }
                this.pmFactory = new SQLPersistenceManagerFactory(this);
                this.pmFactory = (SQLPersistenceManagerFactory)EJBHelper.replaceInternalPersistenceManagerFactory(this.pmFactory);
            }
        }
        if (username != null && this.connectionFactory != null) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.notsupported"));
        }
        return this.pmFactory.getPersistenceManager(username, passwd);
    }

    public void setBooleanProperty(String name, boolean value) {
        if (name.equals("optimistic")) {
            this.setOptimistic(value);
        } else if (name.equals("retainValues")) {
            this.setRetainValues(value);
        } else if (name.equals("nontransactionalRead")) {
            this.setNontransactionalRead(value);
        } else if (name.equals("ignoreCache")) {
            this.setIgnoreCache(value);
        } else if (name.equals("supersedeDeletedInstance")) {
            this.setSupersedeDeletedInstance(value);
        } else if (name.equals("requireCopyObjectId")) {
            this.setRequireCopyObjectId(value);
        } else if (name.equals("requireTrackedSCO")) {
            this.setRequireTrackedSCO(value);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PersistenceManagerFactoryImpl)) {
            return false;
        }
        PersistenceManagerFactoryImpl pmf = (PersistenceManagerFactoryImpl)obj;
        if (pmf.providedConnectionFactory == this.providedConnectionFactory) {
            if (pmf.providedConnectionFactory == 1) {
                return pmf.connectionFactory.equals(this.connectionFactory) && this.equalBooleanProperties(pmf);
            }
            if (pmf.providedConnectionFactory == 2) {
                return pmf.dataSource.equals(this.dataSource) && this.equalBooleanProperties(pmf);
            }
            if (pmf.connectionFactoryName != null) {
                return pmf.connectionFactoryName.equals(this.connectionFactoryName) && this.equalBooleanProperties(pmf);
            }
            return pmf.URL.equals(this.URL) && pmf.userName.equals(this.userName) && Arrays.equals(pmf.password, this.password) && pmf.driverName.equals(this.driverName) && this.equalBooleanProperties(pmf);
        }
        return false;
    }

    public int hashCode() {
        if (this.providedConnectionFactory == 1) {
            return this.connectionFactory.hashCode();
        }
        if (this.providedConnectionFactory == 2) {
            return this.dataSource.hashCode();
        }
        if (this.connectionFactoryName != null) {
            return this.connectionFactoryName.hashCode();
        }
        return this.URL.hashCode() + this.userName.hashCode() + Arrays.hashCode(this.password) + this.driverName.hashCode();
    }

    private void assertNotConfigured() {
        if (this.pmFactory != null) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "persistencemanagerfactoryimpl.configured"));
        }
    }

    private void assertConnectionWait() {
        if (this.connectionMsWait < 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "connection.connectionmanager.mswaitvalue"));
        }
        if (this.connectionMsInterval < 0 || this.connectionMsInterval > this.connectionMsWait || this.connectionMsWait > 0 && this.connectionMsInterval == 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "connection.connectionmanager.msintervalvalue"));
        }
    }

    private boolean equalBooleanProperties(PersistenceManagerFactory pmf) {
        return pmf.getOptimistic() == this.optimistic && pmf.getRetainValues() == this.retainValues && pmf.getNontransactionalRead() == this.nontransactionalRead && pmf.getIgnoreCache() == this.ignoreCache && pmf.getSupersedeDeletedInstance() == this.supersedeDeletedInstance && pmf.getRequireCopyObjectId() == this.requireCopyObjectId && pmf.getRequireTrackedSCO() == this.requireTrackedSCO;
    }
}

