/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.blc;

import com.sun.messaging.jmq.jmsclient.runtime.BrokerInstance;
import com.sun.messaging.jmq.jmsclient.runtime.ClientRuntime;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.jmsservice.BrokerEventListener;
import com.sun.messaging.jmq.jmsservice.JMSService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmbeddedBrokerRunner
implements BrokerEventListener {
    private Properties brokerProps = null;
    private BrokerInstance directBroker;
    private JMSService jmsservice = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.EmbeddedBrokerRunner";
    protected static final transient String _lgrNameLifecycle = "javax.resourceadapter.mqjmsra.lifecycle";
    protected static final transient Logger _loggerL = Logger.getLogger("javax.resourceadapter.mqjmsra.lifecycle");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_EB";
    protected static final transient String _lgrMID_EET = "MQJMSRA_EB1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_EB1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_EB2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_EB3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_EB4001: ";
    private static Set<String> parameterNames = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("-loglevel", "-save", "-shared", "-debug", "-dbuser", "-dbpassword", "-dbpwd", "-diag", "-name", "-port", "-nobind", "-metrics", "-password", "-pwd", "-ldappassword", "-ldappwd", "-read-stdin", "-passfile", "-backup", "-restore", "-cluster", "-force", "-silent", "-s", "-ttyerrors", "-te", "-tty", "-D", "-varhome", "-jmqvarhome", "-imqhome", "-libhome", "-javahome", "-jrehome", "-bgnd", "-init", "-version", "-v", "-ntservice", "-adminkeyfile", "-help", "-h", "-remove", "-reset", "-upgrade-store-nobackup", "-useRmiRegistry", "-startRmiRegistry", "-rmiRegistryPort", "-activateServices")));

    public EmbeddedBrokerRunner(String brokerTypeArgIgnored, String brokerInstanceName, String brokerBindAddress, int brokerPort, String brokerHomeDir, String brokerLibDir, String brokerVarDir, String brokerJavaDir, String brokerExtraArgs, boolean useJNDIRMIServiceURL, int rmiRegistryPort, boolean startRMIRegistry, boolean useSSLJMXConnector, boolean doBind, Properties sysProps) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (_loggerL.isLoggable(Level.FINER)) {
            Object[] params = new Object[]{brokerInstanceName, brokerBindAddress, Integer.toString(brokerPort), brokerHomeDir, brokerLibDir, brokerVarDir, brokerJavaDir, brokerExtraArgs, useJNDIRMIServiceURL, rmiRegistryPort, startRMIRegistry, useSSLJMXConnector, doBind, sysProps};
            _loggerL.entering(_className, "constructor()", params);
        }
        String[] brokerArgs = this.assembleBrokerArgs(brokerInstanceName, brokerPort, brokerHomeDir, brokerLibDir, brokerVarDir, brokerExtraArgs, useJNDIRMIServiceURL, rmiRegistryPort, startRMIRegistry, doBind);
        this.createTheInVMBrokerInstance();
        this.brokerProps = this.parseArgs(brokerArgs);
        if (brokerBindAddress != null && !"localhost".equals(brokerBindAddress)) {
            this.brokerProps.setProperty("imq.hostname", brokerBindAddress);
        }
        Enumeration<Object> e = sysProps.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key == null) continue;
            String val = sysProps.getProperty(key);
            this.brokerProps.setProperty(key, val);
        }
        this.logSysPropsInbrokerLog(sysProps);
    }

    private void logSysPropsInbrokerLog(Properties props) {
        if (props.isEmpty()) {
            return;
        }
        boolean first = true;
        String stringToLog = "";
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String thisPropertyName = (String)e.nextElement();
            String thisPropertyValue = "";
            thisPropertyValue = thisPropertyName.endsWith("password") ? "*****" : props.getProperty(thisPropertyName);
            if (first) {
                first = false;
            } else {
                stringToLog = stringToLog + ", ";
            }
            stringToLog = stringToLog + thisPropertyName + "=" + thisPropertyValue;
        }
        this.directBroker.addEmbeddedBrokerStartupMessage("JMSRA BrokerProps: " + stringToLog);
    }

    private String[] assembleBrokerArgs(String brokerInstanceName, int brokerPort, String brokerHomeDir, String brokerLibDir, String brokerVarDir, String brokerExtraArgs, boolean useJNDIRMIServiceURL, int rmiRegistryPort, boolean startRMIRegistry, boolean doBind) {
        Vector<String> v = new Vector<String>();
        if (brokerExtraArgs != null && !"".equals(brokerExtraArgs)) {
            StringTokenizer st = new StringTokenizer(brokerExtraArgs, " ");
            if (st.countTokens() > 2) {
                EmbeddedBrokerRunner.processBrokerExtraArgs(st, v);
            } else {
                while (st.hasMoreTokens()) {
                    String t = st.nextToken();
                    v.add(t);
                }
            }
        }
        v.add("-port");
        v.add(Integer.toString(brokerPort));
        if (brokerInstanceName != null) {
            v.add("-name");
            v.add(brokerInstanceName);
        }
        if (!doBind) {
            v.add("-nobind");
        }
        if (brokerHomeDir != null) {
            v.add("-imqhome");
            v.add(brokerHomeDir);
        }
        if (brokerVarDir != null) {
            v.add("-varhome");
            v.add(brokerVarDir);
        }
        if (brokerLibDir != null && !"".equals(brokerLibDir)) {
            v.add("-libhome");
            v.add(brokerLibDir);
        }
        if (useJNDIRMIServiceURL) {
            if (startRMIRegistry) {
                v.add("-startRmiRegistry");
            } else {
                v.add("-useRmiRegistry");
            }
            v.add("-rmiRegistryPort");
            v.add(Integer.toString(rmiRegistryPort));
        }
        v.add("-save");
        v.add("-silent");
        String[] brokerArgs = v.toArray(new String[0]);
        return brokerArgs;
    }

    private static void processBrokerExtraArgs(StringTokenizer st, Vector<String> v) {
        StringBuilder builderValue = new StringBuilder();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (parameterNames.contains(s)) {
                if (builderValue.length() > 0) {
                    v.add(builderValue.toString());
                    builderValue.delete(0, builderValue.length());
                }
                v.add(s);
                continue;
            }
            builderValue.append(s + " ");
        }
        if (builderValue.length() > 0) {
            v.add(builderValue.toString());
        }
    }

    private void createTheInVMBrokerInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ClientRuntime runtime = ClientRuntime.getRuntime();
        this.directBroker = runtime.createBrokerInstance();
    }

    private Properties parseArgs(String[] brokerArgs) {
        return this.directBroker.parseArgs(brokerArgs);
    }

    public synchronized void init() {
        _loggerL.entering(_className, "init()");
        this.directBroker.init(this.brokerProps, this);
    }

    public synchronized void start() {
        _loggerL.entering(_className, "start()");
        _loggerL.config("MQJMSRA_EB1101: EB-start:brokerProps=" + this.brokerProps.toString());
        this.directBroker.start();
    }

    protected synchronized void stop() {
        _loggerL.entering(_className, "stop()");
        try {
            BrokerInstance brokerInstance = this.directBroker;
            brokerInstance.stop();
            brokerInstance.shutdown();
            this.directBroker = null;
        }
        catch (Exception bse) {
            _loggerL.severe("MQJMSRA_EB4001: stop:Exception on in-VM broker shutdown:msg=" + bse.getMessage());
            bse.printStackTrace();
        }
    }

    public JMSService getJMSService() {
        if (this.jmsservice == null) {
            this.jmsservice = this.directBroker.getJMSService();
        }
        return this.jmsservice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void brokerEvent(BrokerEvent bErrEvt) {
        _loggerL.fine("MQJMSRA_EB1101: stateChanged:" + bErrEvt);
        if (bErrEvt.getType() == BrokerEvent.Type.SHUTDOWN) {
            EmbeddedBrokerRunner embeddedBrokerRunner = this;
            synchronized (embeddedBrokerRunner) {
                this.directBroker = null;
            }
        }
    }

    @Override
    public boolean exitRequested(BrokerEvent bEvt, Throwable thr) {
        return true;
    }
}

