/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.admin;

import com.sun.enterprise.config.serverbeans.Resources;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.glassfish.concurrent.admin.ManagedExecutorServiceBaseManager;
import org.glassfish.concurrent.config.ManagedExecutorService;
import org.glassfish.concurrent.config.ManagedExecutorServiceBase;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfiguredBy;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="managed-executor-service")
@I18n(value="managed.executor.service.manager")
@ConfiguredBy(value=Resources.class)
public class ManagedExecutorServiceManager
extends ManagedExecutorServiceBaseManager {
    private String maximumPoolSize = "2147483647";
    private String taskQueueCapacity = "2147483647";
    private String useForkJoinPool = Boolean.FALSE.toString();

    @Override
    protected void setAttributes(HashMap attributes, String target) {
        super.setAttributes(attributes, target);
        this.maximumPoolSize = (String)attributes.get("maximum-pool-size");
        this.taskQueueCapacity = (String)attributes.get("task-queue-capacity");
        this.useForkJoinPool = (String)attributes.get("use-fork-join-pool");
    }

    @Override
    protected ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        ResourceStatus superStatus = super.isValid(resources, validateResourceRef, target);
        if ("false".equals(this.useForkJoinPool)) {
            try {
                Integer.parseInt(this.maximumPoolSize);
            }
            catch (NumberFormatException nfe) {
                return new ResourceStatus(1, localStrings.getLocalString("maxsize.must.be.number", "Option maximumpoolsize must be a number."));
            }
            if (Integer.parseInt(this.corePoolSize) == 0 && Integer.parseInt(this.maximumPoolSize) == 0) {
                String msg = localStrings.getLocalString("coresize.maxsize.both.zero", "Options corepoolsize and maximumpoolsize cannot both have value 0.");
                return new ResourceStatus(1, msg);
            }
            if (Integer.parseInt(this.corePoolSize) > Integer.parseInt(this.maximumPoolSize)) {
                String msg = localStrings.getLocalString("coresize.biggerthan.maxsize", "Option corepoolsize cannot have a bigger value than option maximumpoolsize.");
                return new ResourceStatus(1, msg);
            }
        }
        return superStatus;
    }

    @Override
    protected ManagedExecutorServiceBase createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ManagedExecutorService managedExecutorService = (ManagedExecutorService)param.createChild(ManagedExecutorService.class);
        this.setAttributesOnConfigBean(managedExecutorService, properties);
        managedExecutorService.setMaximumPoolSize(this.maximumPoolSize);
        managedExecutorService.setTaskQueueCapacity(this.taskQueueCapacity);
        managedExecutorService.setUseForkJoinPool(this.useForkJoinPool);
        return managedExecutorService;
    }

    @Override
    public String getResourceType() {
        return "managed-executor-service";
    }
}

