/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.FlashlightLoggerInfo;
import org.glassfish.flashlight.impl.client.AgentAttacher;
import org.glassfish.flashlight.impl.client.Log;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.Method;

public class ProbeProviderClassFileTransformer
implements ClassFileTransformer {
    private final WeakReference<Class<?>> providerClassRef;
    private final String providerClassName;
    private final Map<String, FlashlightProbe> probes = new ConcurrentHashMap<String, FlashlightProbe>();
    private AtomicBoolean flaggedForUpdate = new AtomicBoolean(false);
    private boolean transformerAdded = false;
    private int count = 0;
    private static Map<String, ProbeProviderClassFileTransformer> instances = new ConcurrentHashMap<String, ProbeProviderClassFileTransformer>();
    private static final Instrumentation instrumentation;
    private static boolean _debug;
    private static final String AGENT_CLASSNAME = "org.glassfish.flashlight.agent.ProbeAgentMain";
    private static final Logger logger;
    private static final AtomicReference<Thread> updater;

    private ProbeProviderClassFileTransformer(Class<?> providerClass) {
        this.providerClassRef = new WeakReference(providerClass);
        this.providerClassName = providerClass.getName();
    }

    static ProbeProviderClassFileTransformer getInstance(Class<?> aProbeProvider) {
        return instances.computeIfAbsent(aProbeProvider.getName(), key -> new ProbeProviderClassFileTransformer(aProbeProvider));
    }

    static void update(Class<?> aProviderClazz) {
        ProbeProviderClassFileTransformer.getInstance(aProviderClazz).update();
    }

    void addProbe(FlashlightProbe probe) throws NoSuchMethodException {
        this.probes.put(probe.getProviderJavaMethodName() + "::" + Type.getMethodDescriptor((java.lang.reflect.Method)this.getMethod(probe)), probe);
        this.update();
    }

    private static Thread newUpdater() {
        Thread t = new Thread(() -> {
            try {
                block2: while (true) {
                    Thread.sleep(200L);
                    Iterator<ProbeProviderClassFileTransformer> iter = instances.values().iterator();
                    while (true) {
                        if (!iter.hasNext()) continue block2;
                        ProbeProviderClassFileTransformer transformer = iter.next();
                        if (transformer.providerClassRef.get() == null) {
                            iter.remove();
                            continue;
                        }
                        if (!transformer.flaggedForUpdate.get()) continue;
                        transformer.runUpdate();
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        });
        t.setName("ProbeProviderClassFileTransformer");
        t.setDaemon(true);
        t.start();
        return t;
    }

    private void update() {
        this.flaggedForUpdate.set(true);
        updater.updateAndGet(thread -> thread != null && thread.isAlive() ? thread : ProbeProviderClassFileTransformer.newUpdater());
    }

    private final void runUpdate() {
        this.flaggedForUpdate.set(false);
        Class providerClass = (Class)this.providerClassRef.get();
        if (providerClass == null) {
            if (Log.getLogger().isLoggable(Level.FINER)) {
                Log.finer("provider class was reclaimed, not.transformed", this.providerClassName);
            }
            return;
        }
        if (Log.getLogger().isLoggable(Level.FINER)) {
            Log.finer("some probes need to be.transformed", providerClass);
        }
        if (instrumentation == null) {
            return;
        }
        try {
            this.addTransformer();
            instrumentation.retransformClasses(providerClass);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "NCLS-MON-00507", e);
        }
    }

    private boolean hasEnabledInvokers() {
        for (FlashlightProbe probe : this.probes.values()) {
            if (!probe.isEnabled() || probe.getInvokerCount() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        Class providerClass = (Class)this.providerClassRef.get();
        if (providerClass == null) {
            if (Log.getLogger().isLoggable(Level.FINER)) {
                Log.finer("provider class was reclaimed, not.transformed", this.providerClassName);
            }
            return null;
        }
        try {
            if (!AgentAttacher.canAttach()) {
                return null;
            }
            if (classBeingRedefined != providerClass) {
                return null;
            }
            if (this.hasEnabledInvokers()) {
                ClassWriter cw = new ClassWriter(3);
                ClassReader cr = new ClassReader(classfileBuffer);
                cr.accept((ClassVisitor)new ProbeProviderClassVisitor((ClassVisitor)cw), null, 0);
                byte[] instrumentedClassBytes = cw.toByteArray();
                Log.fine("transformed", this.providerClassName);
                if (_debug) {
                    ProbeProviderClassFileTransformer.writeFile(className.substring(className.lastIndexOf(47) + 1) + "supplied_" + this.count, classfileBuffer);
                    ProbeProviderClassFileTransformer.writeFile(className.substring(className.lastIndexOf(47) + 1) + "transformed_" + this.count, instrumentedClassBytes);
                    ++this.count;
                }
                return instrumentedClassBytes;
            }
            if (_debug) {
                ProbeProviderClassFileTransformer.writeFile(className.substring(className.lastIndexOf(47) + 1) + "supplied_" + this.count, classfileBuffer);
                ++this.count;
            }
            Log.fine("untransformed", providerClass.getName());
            return null;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "NCLS-MON-00508", ex);
            return null;
        }
    }

    private void addTransformer() {
        if (!this.transformerAdded) {
            instrumentation.addTransformer(this, true);
            this.transformerAdded = true;
        }
    }

    private static String makeKey(String name, String desc) {
        return name + "::" + desc;
    }

    private static final void writeFile(String name, byte[] data) {
        File installRoot = new File(System.getProperty("com.sun.aas.installRoot"));
        File dir = new File(installRoot, "flashlight-generated");
        if (!dir.isDirectory() && !dir.mkdirs()) {
            logger.log(Level.WARNING, "NCLS-MON-00509", new RuntimeException("Can't create directory: " + dir));
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(new File(dir, name + ".class"));){
            fos.write(data);
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "NCLS-MON-00509", th);
        }
    }

    private java.lang.reflect.Method getMethod(FlashlightProbe probe) throws NoSuchMethodException {
        java.lang.reflect.Method m = probe.getProbeMethod();
        if (m == null) {
            m = probe.getProviderClazz().getDeclaredMethod(probe.getProviderJavaMethodName(), probe.getParamTypes());
            probe.setProbeMethod(m);
        }
        return m;
    }

    static {
        _debug = Boolean.parseBoolean(Utility.getEnvOrProp((String)"AS_DEBUG"));
        logger = FlashlightLoggerInfo.getLogger();
        updater = new AtomicReference();
        Instrumentation nonFinalInstrumentation = null;
        Throwable throwable = null;
        Class<?> agentMainClass = null;
        boolean canAttach = false;
        if (AgentAttacher.canAttach()) {
            canAttach = true;
            try {
                ProbeProviderClassFileTransformer.class.getClassLoader();
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                try {
                    agentMainClass = classLoader.loadClass(AGENT_CLASSNAME);
                }
                catch (Throwable t) {
                    AgentAttacher.attachAgent();
                    agentMainClass = classLoader.loadClass(AGENT_CLASSNAME);
                }
                java.lang.reflect.Method mthd = agentMainClass.getMethod("getInstrumentation", null);
                nonFinalInstrumentation = (Instrumentation)mthd.invoke(null, null);
            }
            catch (Throwable t) {
                nonFinalInstrumentation = null;
                throwable = t;
            }
        }
        instrumentation = nonFinalInstrumentation;
        if (!canAttach) {
            logger.log(Level.WARNING, "NCLS-MON-00510");
        } else if (instrumentation != null) {
            Log.info("yes.attach.api", instrumentation);
        } else {
            logger.log(Level.WARNING, "NCLS-MON-00511", throwable);
        }
    }

    private static class ProbeProviderMethodVisitor
    extends AdviceAdapter {
        private FlashlightProbe probe;
        private int stateLocal;
        private Label startFinally;

        ProbeProviderMethodVisitor(MethodVisitor mv, int access, String name, String desc, FlashlightProbe probe) {
            super(589824, mv, access, name, desc);
            this.probe = probe;
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            if (this.probe.getStateful()) {
                Label endFinally = new Label();
                this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
                this.mv.visitLabel(endFinally);
                this.onFinally(191);
                this.mv.visitInsn(191);
            }
            this.mv.visitMaxs(maxStack, maxLocals);
        }

        protected void onMethodEnter() {
            if (!this.probe.getStateful()) {
                this.insertCode();
                return;
            }
            this.stateLocal = this.newLocal(Type.getType(Object.class));
            this.visitInsn(1);
            this.storeLocal(this.stateLocal);
            this.startFinally = new Label();
            this.visitLabel(this.startFinally);
            this.push(this.probe.getId());
            this.loadArgArray();
            this.invokeStatic(Type.getType(ProbeRegistry.class), Method.getMethod((String)"Object invokeProbeBefore(int, Object[])"));
            this.storeLocal(this.stateLocal);
        }

        protected void onMethodExit(int opcode) {
            if (opcode != 191) {
                this.onFinally(opcode);
            }
        }

        private void onFinally(int opcode) {
            if (!this.probe.getStateful()) {
                return;
            }
            if (opcode == 191) {
                if (this.probe.getStatefulException()) {
                    this.dup();
                } else {
                    this.visitInsn(1);
                }
                this.push(this.probe.getId());
                this.loadLocal(this.stateLocal);
                this.invokeStatic(Type.getType(ProbeRegistry.class), Method.getMethod((String)"void invokeProbeOnException(Object, int, Object)"));
            } else {
                if (this.probe.getStatefulReturn()) {
                    if (opcode == 177) {
                        this.visitInsn(1);
                    } else if (opcode == 176) {
                        this.dup();
                    } else {
                        if (opcode == 173 || opcode == 175) {
                            this.dup2();
                        } else {
                            this.dup();
                        }
                        this.box(Type.getReturnType((String)this.methodDesc));
                    }
                } else {
                    this.visitInsn(1);
                }
                this.push(this.probe.getId());
                this.loadLocal(this.stateLocal);
                this.invokeStatic(Type.getType(ProbeRegistry.class), Method.getMethod((String)"void invokeProbeAfter(Object, int, Object)"));
            }
        }

        private void insertCode() {
            this.push(this.probe.getId());
            this.loadArgArray();
            this.invokeStatic(Type.getType(ProbeRegistry.class), Method.getMethod((String)"void invokeProbe(int, Object[])"));
        }
    }

    private class ProbeProviderClassVisitor
    extends ClassVisitor {
        ProbeProviderClassVisitor(ClassVisitor cv) {
            super(589824, cv);
            if (Log.getLogger().isLoggable(Level.FINER)) {
                for (String methodDesc : ProbeProviderClassFileTransformer.this.probes.keySet()) {
                    Log.finer("visit" + methodDesc, new Object[0]);
                }
            }
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Object mv = super.visitMethod(access, name, desc, signature, exceptions);
            FlashlightProbe probe = (FlashlightProbe)ProbeProviderClassFileTransformer.this.probes.get(ProbeProviderClassFileTransformer.makeKey(name, desc));
            if (probe != null && probe.isEnabled() && probe.getInvokerCount() > 0) {
                mv = new ProbeProviderMethodVisitor((MethodVisitor)mv, access, name, desc, probe);
            }
            return mv;
        }
    }
}

