/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.sniffer;

import com.sun.enterprise.deployment.deploy.shared.Util;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.web.sniffer.WarType;
import org.glassfish.web.sniffer.WebSniffer;
import org.jvnet.hk2.annotations.Service;

@Service(name="war")
@Singleton
public class WarDetector
implements ArchiveDetector {
    public static final String WAR_DETECTOR_RANK_PROP = "glassfish.war.detector.rank";
    public static final int DEFAULT_WAR_DETECTOR_RANK = 200;
    public static final String ARCHIVE_TYPE = "war";
    @Inject
    WebSniffer sniffer;
    @Inject
    ServiceLocator services;
    @Inject
    WarType archiveType;
    private ArchiveHandler archiveHandler;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private static final String WEB_INF = "WEB-INF";
    private static final String JSP_SUFFIX = ".jsp";
    private static final String WAR_EXTENSION = ".war";
    private static final String AVATAR = "avatar";

    public int rank() {
        return Integer.getInteger(WAR_DETECTOR_RANK_PROP, 200);
    }

    public boolean handles(ReadableArchive archive) {
        try {
            if (Util.getURIName((URI)archive.getURI()).endsWith(WAR_EXTENSION)) {
                return true;
            }
            if (archive.exists(WEB_INF)) {
                return true;
            }
            if (archive.exists(AVATAR)) {
                return true;
            }
            Enumeration entries = archive.entries();
            while (entries.hasMoreElements()) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(JSP_SUFFIX)) continue;
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveHandler getArchiveHandler() {
        WarDetector warDetector = this;
        synchronized (warDetector) {
            if (this.archiveHandler == null) {
                try {
                    this.sniffer.setup(null, this.logger);
                    this.archiveHandler = (ArchiveHandler)this.services.getService(ArchiveHandler.class, ARCHIVE_TYPE, new Annotation[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.archiveHandler;
        }
    }

    public ArchiveType getArchiveType() {
        return this.archiveType;
    }
}

