/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.activation;

import fish.payara.microprofile.connector.MicroProfileSniffer;
import fish.payara.microprofile.openapi.activation.OpenApiContainer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import org.eclipse.microprofile.openapi.annotations.OpenAPIDefinition;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class OpenApiSniffer
extends MicroProfileSniffer {
    private static final Logger LOGGER = Logger.getLogger(OpenApiSniffer.class.getName());
    public static final String[] OPENAPI_YAML_FILE_PATHS = new String[]{"META-INF/openapi.json", "WEB-INF/classes/META-INF/openapi.json", "META-INF/openapi.yaml", "WEB-INF/classes/META-INF/openapi.yaml", "META-INF/openapi.yml", "WEB-INF/classes/META-INF/openapi.yml"};

    public Class<? extends Annotation>[] getAnnotationTypes() {
        return new Class[]{Path.class, ApplicationPath.class, OpenAPIDefinition.class};
    }

    @Override
    public boolean handles(ReadableArchive archive) {
        try {
            for (String openApiFile : OPENAPI_YAML_FILE_PATHS) {
                if (!archive.exists(openApiFile)) continue;
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error reading archive", e);
            return false;
        }
        return super.handles(archive);
    }

    @Override
    protected Class<?> getContainersClass() {
        return OpenApiContainer.class;
    }

    public String getModuleType() {
        return "openapi";
    }
}

