/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl;

import com.sun.enterprise.v3.server.ApplicationLifecycle;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import fish.payara.microprofile.openapi.impl.OpenApiService;
import fish.payara.microprofile.openapi.impl.config.OpenApiConfiguration;
import fish.payara.microprofile.openapi.impl.model.OpenAPIImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import fish.payara.microprofile.openapi.impl.processor.ApplicationProcessor;
import fish.payara.microprofile.openapi.impl.processor.BaseProcessor;
import fish.payara.microprofile.openapi.impl.processor.ConfigPropertyProcessor;
import fish.payara.microprofile.openapi.impl.processor.FileProcessor;
import fish.payara.microprofile.openapi.impl.processor.FilterProcessor;
import fish.payara.microprofile.openapi.impl.processor.ModelReaderProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.analysis.StructuredDeploymentTracing;

public class OpenAPISupplier
implements Supplier<OpenAPI> {
    private final OpenApiConfiguration config;
    private final String applicationId;
    private final String contextRoot;
    private final ReadableArchive archive;
    private final ClassLoader classLoader;
    private volatile OpenAPI document;
    private boolean enabled;

    public OpenAPISupplier(String applicationId, String contextRoot, ReadableArchive archive, ClassLoader classLoader) {
        this.config = new OpenApiConfiguration(classLoader);
        this.applicationId = applicationId;
        this.contextRoot = contextRoot;
        this.archive = archive;
        this.classLoader = classLoader;
        this.enabled = true;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OpenAPI get() {
        if (this.document != null) {
            return this.document;
        }
        if (!this.enabled) {
            return null;
        }
        try {
            Parser parser = ((ApplicationLifecycle)Globals.get(ApplicationLifecycle.class)).getDeployableParser(this.archive, true, true, StructuredDeploymentTracing.create((String)this.applicationId), Logger.getLogger(OpenApiService.class.getName()));
            Types types = parser.getContext().getTypes();
            OpenAPIImpl doc = new OpenAPIImpl();
            try {
                List<URL> baseURLs = this.getServerURL(this.contextRoot);
                doc = new ConfigPropertyProcessor().process(doc, this.config);
                doc = new ModelReaderProcessor().process(doc, this.config);
                doc = new FileProcessor(this.classLoader).process(doc, this.config);
                doc = new ApplicationProcessor(types, this.filterTypes(this.archive, this.config, types), this.classLoader).process(doc, this.config);
                if (doc.getPaths() != null && !doc.getPaths().getPathItems().isEmpty()) {
                    doc.setEndpoints(ModelUtils.buildEndpoints(null, this.contextRoot, doc.getPaths().getPathItems().keySet()));
                }
                doc = new BaseProcessor(baseURLs).process(doc, this.config);
                doc = new FilterProcessor().process(doc, this.config);
            }
            finally {
                this.document = doc;
            }
            return this.document;
        }
        catch (Exception ex) {
            throw new RuntimeException("An error occurred while creating the OpenAPI document.", ex);
        }
    }

    private Set<Type> filterTypes(ReadableArchive archive, OpenApiConfiguration config, Types hk2Types) {
        HashSet<Type> types = new HashSet<Type>(this.filterLibTypes(config, hk2Types, archive));
        types.addAll(Collections.list(archive.entries()).stream().filter(clazz -> clazz.endsWith(".class")).map(clazz -> clazz.replaceAll("WEB-INF/classes/", "").replace("/", ".").replace(".class", "")).map(clazz -> hk2Types.getBy(clazz)).filter(Objects::nonNull).collect(Collectors.toSet()));
        return config == null ? types : config.getValidClasses(types);
    }

    private Set<Type> filterLibTypes(OpenApiConfiguration config, Types hk2Types, ReadableArchive archive) {
        HashSet<Type> types = new HashSet<Type>();
        if (config != null && config.getScanLib()) {
            Enumeration subArchiveItr = archive.entries();
            while (subArchiveItr.hasMoreElements()) {
                String subArchiveName = (String)subArchiveItr.nextElement();
                if (!subArchiveName.startsWith("WEB-INF/lib/") || !subArchiveName.endsWith(".jar")) continue;
                try {
                    ReadableArchive subArchive = archive.getSubArchive(subArchiveName);
                    types.addAll(Collections.list(subArchive.entries()).stream().filter(clazz -> clazz.endsWith(".class")).map(clazz -> clazz.replace("/", ".").replace(".class", "")).map(clazz -> hk2Types.getBy(clazz)).filter(Objects::nonNull).collect(Collectors.toSet()));
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        return types;
    }

    private List<URL> getServerURL(String contextRoot) {
        String hostName;
        ArrayList<URL> result = new ArrayList<URL>();
        ServerContext context = (ServerContext)Globals.get(ServerContext.class);
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            hostName = "localhost";
        }
        String instanceType = ((ServerEnvironment)Globals.get(ServerEnvironment.class)).getRuntimeType().toString();
        ArrayList httpPorts = new ArrayList();
        ArrayList httpsPorts = new ArrayList();
        List networkListeners = context.getConfigBean().getConfig().getNetworkConfig().getNetworkListeners().getNetworkListener();
        String adminListener = context.getConfigBean().getConfig().getAdminListener().getName();
        networkListeners.stream().filter(networkListener -> Boolean.parseBoolean(networkListener.getEnabled())).forEach(networkListener -> {
            List ports;
            int port;
            try {
                port = ((GrizzlyService)Globals.get(GrizzlyService.class)).getRealPort(networkListener);
            }
            catch (MultiException ex) {
                port = Integer.parseInt(networkListener.getPort());
            }
            boolean securityEnabled = Boolean.parseBoolean(networkListener.findProtocol().getSecurityEnabled());
            List list = ports = securityEnabled ? httpsPorts : httpPorts;
            if (!networkListener.getName().equals(adminListener)) {
                ports.add(port);
            } else if (instanceType.equals("MICRO")) {
                ports.add(port);
            }
        });
        for (Integer httpPort : httpPorts) {
            try {
                result.add(new URL("http", hostName, httpPort, contextRoot));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        for (Integer httpsPort : httpsPorts) {
            try {
                result.add(new URL("https", hostName, httpsPort, contextRoot));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return result;
    }
}

