/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.examples;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class ExampleImpl
extends ExtensibleImpl<Example>
implements Example {
    private String summary;
    private String description;
    private Object value;
    private String externalValue;
    private String ref;

    public static Example createInstance(AnnotationModel annotation, ApiContext context) {
        ExampleImpl from = new ExampleImpl();
        from.setSummary((String)annotation.getValue("summary", String.class));
        from.setDescription((String)annotation.getValue("description", String.class));
        from.setValue(annotation.getValue("value", Object.class));
        from.setExternalValue((String)annotation.getValue("externalValue", String.class));
        String ref = (String)annotation.getValue("ref", String.class);
        if (ref != null && !ref.isEmpty()) {
            from.setRef(ref);
        }
        return from;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getExternalValue() {
        return this.externalValue;
    }

    public void setExternalValue(String externalValue) {
        this.externalValue = externalValue;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        if (ref != null && !ref.contains(".") && !ref.contains("/")) {
            ref = "#/components/examples/" + ref;
        }
        this.ref = ref;
    }

    public static void merge(Example from, Example to, boolean override) {
        if (from == null) {
            return;
        }
        to.setSummary(ModelUtils.mergeProperty(to.getSummary(), from.getSummary(), override));
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        to.setValue(ModelUtils.mergeProperty(to.getValue(), from.getValue(), override));
        to.setExternalValue(ModelUtils.mergeProperty(to.getExternalValue(), from.getExternalValue(), override));
    }

    public static void merge(String exampleName, Example example, Map<String, Example> examples, boolean override) {
        if (example == null) {
            return;
        }
        if (exampleName == null || exampleName.isEmpty()) {
            exampleName = "?";
        }
        Example model = examples.getOrDefault(exampleName, new ExampleImpl());
        examples.put(exampleName, model);
        ExampleImpl.merge(example, model, override);
        if (model.getRef() != null) {
            examples.remove(exampleName);
            examples.put(model.getRef().split("/")[3], model);
        }
    }
}

