/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.visitor;

import fish.payara.microprofile.openapi.api.visitor.ApiVisitor;
import fish.payara.microprofile.openapi.api.visitor.ApiWalker;
import fish.payara.microprofile.openapi.impl.model.media.SchemaImpl;
import fish.payara.microprofile.openapi.impl.visitor.AnnotationInfo;
import fish.payara.microprofile.openapi.impl.visitor.OpenApiContext;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.microprofile.openapi.annotations.ExternalDocumentation;
import org.eclipse.microprofile.openapi.annotations.OpenAPIDefinition;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.callbacks.Callback;
import org.eclipse.microprofile.openapi.annotations.callbacks.Callbacks;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.extensions.Extensions;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameters;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBodySchema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponseSchema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirements;
import org.eclipse.microprofile.openapi.annotations.security.SecurityScheme;
import org.eclipse.microprofile.openapi.annotations.security.SecuritySchemes;
import org.eclipse.microprofile.openapi.annotations.servers.Server;
import org.eclipse.microprofile.openapi.annotations.servers.Servers;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.eclipse.microprofile.openapi.annotations.tags.Tags;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.FieldModel;
import org.glassfish.hk2.classmodel.reflect.MethodModel;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;

public class OpenApiWalker<E extends AnnotatedElement>
implements ApiWalker {
    private final Set<Type> allowedTypes = new TreeSet<Type>(Comparator.comparing(AnnotatedElement::getName, String::compareTo));
    private final OpenApiContext context;
    private Map<Class<? extends Annotation>, ApiVisitor.VisitorFunction<AnnotationModel, E>> annotationVisitor;
    private Map<Class<? extends Annotation>, Class<? extends Annotation>> annotationAlternatives;

    public OpenApiWalker(OpenAPI api, Types allTypes, Set<Type> allowedTypes, ClassLoader appClassLoader) {
        this.allowedTypes.addAll(allowedTypes);
        this.context = new OpenApiContext(allTypes, this.allowedTypes, appClassLoader, api);
    }

    @Override
    public void accept(ApiVisitor visitor) {
        for (Type type : this.allowedTypes) {
            if (!(type instanceof ClassModel)) continue;
            this.processAnnotation((ClassModel)type, visitor);
        }
        this.addSchemasToPaths();
    }

    public final void processAnnotation(ClassModel annotatedClass, ApiVisitor visitor) {
        AnnotationInfo annotations = this.context.getAnnotationInfo((ExtensibleType<? extends ExtensibleType>)annotatedClass);
        this.processAnnotation(annotatedClass, annotations, visitor, new OpenApiContext(this.context, (AnnotatedElement)annotatedClass));
        for (MethodModel method : annotatedClass.getMethods()) {
            this.processAnnotation(method, annotations, visitor, new OpenApiContext(this.context, (AnnotatedElement)method));
        }
        for (FieldModel field : annotatedClass.getFields()) {
            this.processAnnotation(field, annotations, visitor, new OpenApiContext(this.context, (AnnotatedElement)field));
        }
        for (MethodModel method : annotatedClass.getMethods()) {
            for (org.glassfish.hk2.classmodel.reflect.Parameter parameter : method.getParameters()) {
                this.processAnnotation(parameter, annotations, visitor, new OpenApiContext(this.context, (AnnotatedElement)method));
            }
        }
    }

    private void processAnnotation(E element, AnnotationInfo annotations, ApiVisitor visitor, OpenApiContext context) {
        for (Class<Annotation> annotationClass : this.getAnnotationVisitor(visitor).keySet()) {
            ApiVisitor.VisitorFunction<AnnotationModel, E> annotationFunction = this.getAnnotationVisitor(visitor).get(annotationClass);
            Class<Annotation> alternative = this.getAnnotationAlternatives().get(annotationClass);
            if (annotations.isAnnotationPresent((Class<? extends Annotation>)annotationClass, (AnnotatedElement)element)) {
                if (element instanceof FieldModel && (annotationClass == HeaderParam.class || annotationClass == CookieParam.class || annotationClass == PathParam.class || annotationClass == QueryParam.class)) {
                    FieldModel field = (FieldModel)element;
                    for (MethodModel method : field.getDeclaringType().getMethods()) {
                        OpenApiContext methodContext = new OpenApiContext(context, (AnnotatedElement)method);
                        if (methodContext.getWorkingOperation() == null) continue;
                        annotationFunction.apply(annotations.getAnnotation((Class<? extends Annotation>)annotationClass, (AnnotatedElement)element), element, methodContext);
                    }
                    continue;
                }
                annotationFunction.apply(annotations.getAnnotation((Class<? extends Annotation>)annotationClass, (AnnotatedElement)element), element, context);
                continue;
            }
            if (!(element instanceof MethodModel) || !annotations.isAnnotationPresent(annotationClass) || alternative != null && annotations.isAnnotationPresent((Class<? extends Annotation>)alternative, (AnnotatedElement)element) || context.getPath() == null) continue;
            annotationFunction.apply(annotations.getAnnotation(annotationClass), element, context);
        }
    }

    private Map<Class<? extends Annotation>, ApiVisitor.VisitorFunction<AnnotationModel, E>> getAnnotationVisitor(ApiVisitor visitor) {
        if (this.annotationVisitor == null) {
            this.annotationVisitor = new LinkedHashMap<Class<? extends Annotation>, ApiVisitor.VisitorFunction<AnnotationModel, E>>();
            this.annotationVisitor.put(OpenAPIDefinition.class, visitor::visitOpenAPI);
            this.annotationVisitor.put(GET.class, (annot, element, con) -> visitor.visitGET((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(POST.class, (annot, element, con) -> visitor.visitPOST((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(PUT.class, (annot, element, con) -> visitor.visitPUT((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(DELETE.class, (annot, element, con) -> visitor.visitDELETE((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(HEAD.class, (annot, element, con) -> visitor.visitHEAD((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(OPTIONS.class, (annot, element, con) -> visitor.visitOPTIONS((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(PATCH.class, (annot, element, con) -> visitor.visitPATCH((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(QueryParam.class, visitor::visitQueryParam);
            this.annotationVisitor.put(PathParam.class, visitor::visitPathParam);
            this.annotationVisitor.put(HeaderParam.class, visitor::visitHeaderParam);
            this.annotationVisitor.put(CookieParam.class, visitor::visitCookieParam);
            this.annotationVisitor.put(FormParam.class, visitor::visitFormParam);
            this.annotationVisitor.put(Schema.class, visitor::visitSchema);
            this.annotationVisitor.put(XmlRootElement.class, visitor::visitSchema);
            this.annotationVisitor.put(Server.class, visitor::visitServer);
            this.annotationVisitor.put(Servers.class, visitor::visitServers);
            this.annotationVisitor.put(Extensions.class, visitor::visitExtensions);
            this.annotationVisitor.put(Extension.class, visitor::visitExtension);
            this.annotationVisitor.put(Operation.class, visitor::visitOperation);
            this.annotationVisitor.put(Callback.class, visitor::visitCallback);
            this.annotationVisitor.put(Callbacks.class, visitor::visitCallbacks);
            this.annotationVisitor.put(APIResponse.class, visitor::visitAPIResponse);
            this.annotationVisitor.put(APIResponses.class, visitor::visitAPIResponses);
            this.annotationVisitor.put(APIResponseSchema.class, visitor::visitAPIResponseSchema);
            this.annotationVisitor.put(Parameters.class, visitor::visitParameters);
            this.annotationVisitor.put(Parameter.class, visitor::visitParameter);
            this.annotationVisitor.put(ExternalDocumentation.class, visitor::visitExternalDocumentation);
            this.annotationVisitor.put(Tag.class, visitor::visitTag);
            this.annotationVisitor.put(Tags.class, visitor::visitTags);
            this.annotationVisitor.put(SecurityScheme.class, visitor::visitSecurityScheme);
            this.annotationVisitor.put(SecuritySchemes.class, visitor::visitSecuritySchemes);
            this.annotationVisitor.put(SecurityRequirement.class, visitor::visitSecurityRequirement);
            this.annotationVisitor.put(SecurityRequirements.class, visitor::visitSecurityRequirements);
            this.annotationVisitor.put(Produces.class, visitor::visitProduces);
            this.annotationVisitor.put(Consumes.class, visitor::visitConsumes);
            this.annotationVisitor.put(RequestBody.class, visitor::visitRequestBody);
            this.annotationVisitor.put(RequestBodySchema.class, visitor::visitRequestBodySchema);
        }
        return this.annotationVisitor;
    }

    private Map<Class<? extends Annotation>, Class<? extends Annotation>> getAnnotationAlternatives() {
        if (this.annotationAlternatives == null) {
            this.annotationAlternatives = new HashMap<Class<? extends Annotation>, Class<? extends Annotation>>();
            this.annotationAlternatives.put(Server.class, Servers.class);
            this.annotationAlternatives.put(Servers.class, Server.class);
            this.annotationAlternatives.put(Extensions.class, Extension.class);
            this.annotationAlternatives.put(Extension.class, Extensions.class);
            this.annotationAlternatives.put(Callback.class, Callbacks.class);
            this.annotationAlternatives.put(Callbacks.class, Callback.class);
            this.annotationAlternatives.put(APIResponse.class, APIResponses.class);
            this.annotationAlternatives.put(APIResponses.class, APIResponse.class);
            this.annotationAlternatives.put(Parameters.class, Parameter.class);
            this.annotationAlternatives.put(Parameter.class, Parameters.class);
            this.annotationAlternatives.put(Tag.class, Tags.class);
            this.annotationAlternatives.put(Tags.class, Tag.class);
            this.annotationAlternatives.put(SecurityScheme.class, SecuritySchemes.class);
            this.annotationAlternatives.put(SecuritySchemes.class, SecurityScheme.class);
            this.annotationAlternatives.put(SecurityRequirement.class, SecurityRequirements.class);
            this.annotationAlternatives.put(SecurityRequirements.class, SecurityRequirement.class);
        }
        return this.annotationAlternatives;
    }

    private void addSchemasToPaths() {
        OpenAPI api = this.context.getApi();
        api.getPaths().getPathItems().forEach((s, t) -> t.getOperations().forEach((u, v) -> v.getResponses().getAPIResponses().forEach((w, x) -> {
            if (x.getContent() != null) {
                x.getContent().getMediaTypes().forEach((y, z) -> {
                    SchemaImpl.merge(z.getSchema(), z.getSchema(), true, this.context);
                    if (z.getSchema() instanceof SchemaImpl) {
                        SchemaImpl schema = (SchemaImpl)z.getSchema();
                        schema.setImplementation(null);
                    }
                });
            }
        })));
    }
}

