/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.eventbus;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.LocalTopicStats;
import com.hazelcast.topic.MessageListener;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.nucleus.eventbus.ClusterMessage;
import fish.payara.nucleus.eventbus.MessageReceiver;
import fish.payara.nucleus.eventbus.TopicListener;
import fish.payara.nucleus.events.HazelcastEvents;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="payara-event-bus")
@RunLevel(value=10)
public class EventBus
implements EventListener,
MonitoringDataSource {
    private static final Logger logger = Logger.getLogger(EventBus.class.getCanonicalName());
    @Inject
    private HazelcastCore hzCore;
    @Inject
    private Events events;
    private Map<String, TopicListener> messageReceivers;

    @PostConstruct
    public void postConstruct() {
        this.events.register((EventListener)this);
        this.messageReceivers = new ConcurrentHashMap<String, TopicListener>(2);
    }

    public void collect(MonitoringDataCollector rootCollector) {
        MonitoringDataCollector eventCollector = rootCollector.in((CharSequence)"topic");
        if (this.hzCore.isEnabled()) {
            HazelcastInstance hz = this.hzCore.getInstance();
            for (DistributedObject obj : hz.getDistributedObjects()) {
                if (!"hz:impl:topicService".equals(obj.getServiceName())) continue;
                LocalTopicStats stats = hz.getTopic(obj.getName()).getLocalTopicStats();
                eventCollector.group((CharSequence)obj.getName()).collect((CharSequence)"PublishedCount", stats.getPublishOperationCount()).collect((CharSequence)"ReceiveedCount", stats.getReceiveOperationCount());
            }
        }
    }

    public boolean publish(String topic, ClusterMessage message) {
        boolean result = false;
        if (this.hzCore.isEnabled()) {
            this.hzCore.getInstance().getTopic(topic).publish((Object)message);
            result = true;
        }
        return result;
    }

    public boolean addMessageReceiver(String topic, MessageReceiver mr) {
        boolean result = false;
        if (this.hzCore.isEnabled()) {
            TopicListener tl = this.messageReceivers.get(topic);
            if (tl == null) {
                TopicListener newTL = new TopicListener(topic);
                UUID regId = this.hzCore.getInstance().getTopic(topic).addMessageListener((MessageListener)newTL);
                this.messageReceivers.put(topic, newTL);
                tl = newTL;
                tl.setRegistrationID(regId);
            }
            tl.addMessageReceiver(mr);
            result = true;
        }
        return result;
    }

    public void removeMessageReceiver(String topic, MessageReceiver mr) {
        int remaining;
        TopicListener tl = this.messageReceivers.get(topic);
        if (tl != null && (remaining = tl.removeMessageReceiver(mr)) == 0) {
            this.messageReceivers.remove(topic);
            if (this.hzCore.isEnabled()) {
                this.hzCore.getInstance().getTopic(topic).removeMessageListener(tl.getRegistrationID());
            }
        }
    }

    public void event(EventListener.Event event) {
        if (event.is(HazelcastEvents.HAZELCAST_BOOTSTRAP_COMPLETE) && this.hzCore.isEnabled()) {
            logger.config("Payara Clustered Event Bus Enabled");
        }
    }
}

