/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.store;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.map.LocalMapStats;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.nucleus.events.HazelcastEvents;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import fish.payara.nucleus.hazelcast.encryption.HazelcastSymmetricEncryptor;
import fish.payara.nucleus.hazelcast.encryption.PayaraHazelcastEncryptedValueHolder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.JavaEEContextUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="payara-cluster-store")
@RunLevel(value=9)
public class ClusteredStore
implements EventListener,
MonitoringDataSource {
    private static final Logger logger = Logger.getLogger(ClusteredStore.class.getCanonicalName());
    @Inject
    private HazelcastCore hzCore;
    @Inject
    private Events events;
    @Inject
    private JavaEEContextUtil ctxUtil;

    @PostConstruct
    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public void collect(MonitoringDataCollector collector) {
        if (this.hzCore.isEnabled()) {
            try (JavaEEContextUtil.Context ctx = this.ctxUtil.empty().pushContext();){
                HazelcastInstance hz = this.hzCore.getInstance();
                for (DistributedObject obj : hz.getDistributedObjects()) {
                    IMap map;
                    MapConfig config;
                    if (!"hz:impl:mapService".equals(obj.getServiceName()) || !(config = hz.getConfig().getMapConfig(obj.getName())).isStatisticsEnabled() || (map = hz.getMap(obj.getName())) == null) continue;
                    LocalMapStats stats = map.getLocalMapStats();
                    collector.in((CharSequence)"map").group((CharSequence)map.getName()).collect((CharSequence)"GetCount", stats.getGetOperationCount()).collect((CharSequence)"PutCount", stats.getPutOperationCount()).collect((CharSequence)"EntryCount", stats.getOwnedEntryCount());
                }
            }
        }
    }

    public UUID getInstanceId() {
        return this.hzCore.getUUID();
    }

    public boolean isEnabled() {
        return this.hzCore.isEnabled();
    }

    public boolean set(String storeName, Serializable key, Serializable value) {
        boolean result = false;
        if (this.isEnabled()) {
            try (JavaEEContextUtil.Context ctx = this.ctxUtil.empty().pushContext();){
                if (value != null && this.hzCore.isDatagridEncryptionEnabled()) {
                    value = new PayaraHazelcastEncryptedValueHolder(HazelcastSymmetricEncryptor.encode(HazelcastSymmetricEncryptor.objectToByteArray(value)));
                }
                this.hzCore.getInstance().getMap(storeName).set((Object)key, (Object)value);
                result = true;
            }
        }
        return result;
    }

    public boolean remove(String storeName, Serializable key) {
        boolean result = false;
        if (this.isEnabled()) {
            try (JavaEEContextUtil.Context ctx = this.ctxUtil.empty().pushContext();){
                IMap map = this.hzCore.getInstance().getMap(storeName);
                if (map != null) {
                    Object value = map.remove((Object)key);
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean containsKey(String storeName, Serializable key) {
        boolean result = false;
        if (this.isEnabled()) {
            try (JavaEEContextUtil.Context ctx = this.ctxUtil.empty().pushContext();){
                IMap map = this.hzCore.getInstance().getMap(storeName);
                if (map != null) {
                    result = map.containsKey((Object)key);
                }
            }
        }
        return result;
    }

    public Serializable get(String storeName, Serializable key) {
        Serializable result = null;
        if (this.isEnabled()) {
            try (JavaEEContextUtil.Context ctx = this.ctxUtil.empty().pushContext();){
                IMap map = this.hzCore.getInstance().getMap(storeName);
                if (map != null && (result = (Serializable)map.get((Object)key)) instanceof PayaraHazelcastEncryptedValueHolder && this.hzCore.isDatagridEncryptionEnabled()) {
                    result = (Serializable)HazelcastSymmetricEncryptor.byteArrayToObject(HazelcastSymmetricEncryptor.decode(((PayaraHazelcastEncryptedValueHolder)result).getEncryptedObjectBytes()));
                }
            }
        }
        return result;
    }

    public void event(EventListener.Event event) {
        if (event.is(HazelcastEvents.HAZELCAST_BOOTSTRAP_COMPLETE) && this.hzCore.isEnabled()) {
            logger.config("Payara Clustered Store Service Enabled");
        }
    }

    public Map<Serializable, Serializable> getMap(String storeName) {
        HashMap<Serializable, Serializable> result = new HashMap<Serializable, Serializable>();
        if (this.hzCore.isEnabled()) {
            try (JavaEEContextUtil.Context ctx = this.ctxUtil.empty().pushContext();){
                IMap map = this.hzCore.getInstance().getMap(storeName);
                if (map != null) {
                    Set keys = map.keySet();
                    for (Serializable key : keys) {
                        Serializable value = (Serializable)map.get((Object)key);
                        if (value instanceof PayaraHazelcastEncryptedValueHolder && this.hzCore.isDatagridEncryptionEnabled()) {
                            value = (Serializable)HazelcastSymmetricEncryptor.byteArrayToObject(HazelcastSymmetricEncryptor.decode(((PayaraHazelcastEncryptedValueHolder)value).getEncryptedObjectBytes()));
                        }
                        result.put(key, value);
                    }
                }
            }
        }
        return result;
    }
}

