/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.AuthenticationMechanism;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.Connector;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

@Connector(description={"Resource adapter wrapping implementation of driver"}, displayName={"Resource Adapter"}, vendorName="Sun Microsystems", eisType="Database", version="1.0", authMechanisms={@AuthenticationMechanism(authMechanism="BasicPassword", credentialInterface=AuthenticationMechanism.CredentialInterface.PasswordCredential)})
public class ResourceAdapterImpl
implements ResourceAdapter {
    private static ResourceAdapterImpl ra;
    private BootstrapContext bootstrapContext;
    private Timer timer;
    private static Logger _logger;

    public ResourceAdapterImpl() {
        if (ra == null) {
            ra = this;
        }
    }

    public static ResourceAdapterImpl getInstance() {
        if (ra == null) {
            throw new IllegalStateException("ResourceAdapter not initialized");
        }
        return ra;
    }

    public void endpointActivation(MessageEndpointFactory mef, ActivationSpec as) throws NotSupportedException {
        throw new NotSupportedException("This method is not supported for this JDBC connector");
    }

    public void endpointDeactivation(MessageEndpointFactory mef, ActivationSpec as) {
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws NotSupportedException {
        throw new NotSupportedException("This method is not supported for this JDBC connector");
    }

    public void start(BootstrapContext ctx) {
        this.bootstrapContext = ctx;
    }

    public void stop() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Cancelling the timer");
        }
        if (this.timer != null) {
            this.timer.purge();
            this.timer.cancel();
        }
    }

    public Timer getTimer() {
        if (this.bootstrapContext != null && this.timer == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Creating the timer");
            }
            ClassLoader appClassLoader = Utility.getClassLoader();
            Utility.setContextClassLoader(null);
            try {
                this.timer = AccessController.doPrivileged(() -> ((BootstrapContext)this.bootstrapContext).createTimer());
            }
            catch (PrivilegedActionException ex) {
                _logger.log(Level.SEVERE, "jdbc-ra.timer_creation_exception", ex.getCause().getMessage());
            }
            finally {
                Utility.setContextClassLoader((ClassLoader)appClassLoader);
            }
        }
        return this.timer;
    }

    static {
        _logger = LogDomains.getLogger(ResourceAdapterImpl.class, (String)"javax.enterprise.resource.resourceadapter");
    }
}

