/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jdbc.stats;

import com.sun.gjc.util.SQLTrace;
import com.sun.gjc.util.SQLTraceCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public class FrequentSQLTraceCache
extends SQLTraceCache {
    protected long maxStoredEntries = 10000L;

    public FrequentSQLTraceCache(String poolName, int numToReport, long timeToKeepQueries) {
        super(poolName, numToReport, timeToKeepQueries);
    }

    public FrequentSQLTraceCache(String poolName, int numToReport, long timeToKeepQueries, long maxStoredEntries) {
        super(poolName, numToReport, timeToKeepQueries);
        this.maxStoredEntries = maxStoredEntries;
    }

    @Override
    public void checkAndUpdateCache(SQLTrace cacheObj) {
        if (cacheObj != null) {
            SQLTrace trace = (SQLTrace)this.cache.get(cacheObj.getQueryName());
            if (trace != null) {
                trace.setNumExecutions(trace.getNumExecutions() + 1);
                trace.setLastUsageTime(System.currentTimeMillis());
            } else if ((long)this.cache.size() < this.maxStoredEntries) {
                this.cache.put(cacheObj.getQueryName(), cacheObj);
            } else if (_logger.isLoggable(Level.CONFIG)) {
                _logger.log(Level.CONFIG, "Frequent SQL Trace Cache full, {0} not stored.", cacheObj.getQueryName());
            } else {
                _logger.log(Level.INFO, "Frequent SQL Trace Cache full, enable CONFIG log level for more info.");
            }
        }
    }

    public List<SQLTrace> getTopQueries() {
        this.purgeEntries();
        ArrayList<SQLTrace> sqlTraceList = new ArrayList<SQLTrace>(this.cache.values());
        Collections.sort(sqlTraceList, SQLTrace.SQLTraceFrequencyComparator);
        return sqlTraceList;
    }
}

