/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.util.AMXDebug;
import org.glassfish.admin.amx.util.Output;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.jmx.AttributeChangeNotificationBuilder;
import org.glassfish.admin.amx.util.jmx.NotificationBuilder;
import org.glassfish.admin.amx.util.jmx.NotificationEmitterSupport;
import org.glassfish.admin.amx.util.jmx.NotificationSender;
import org.glassfish.admin.amx.util.stringifier.SmartStringifier;

public abstract class MBeanImplBase
implements MBeanRegistration,
NotificationSender {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected volatile MBeanServer mServer;
    protected volatile ObjectName mSelfObjectName;
    private volatile NotificationEmitterSupport mNotificationEmitter;
    private volatile Map<String, NotificationBuilder> mNotificationBuilders;
    private final Output mDebug = AMXDebug.getInstance().getOutput(this.getDebugID());

    public MBeanImplBase() {
    }

    public MBeanImplBase(MBeanServer mbeanServer) {
        this.mServer = mbeanServer;
    }

    public final int getListenerCount() {
        return this.getNotificationEmitter().getListenerCount();
    }

    public final int getNotificationTypeListenerCount(String type) {
        return this.getNotificationEmitter().getNotificationTypeListenerCount(type);
    }

    protected final synchronized NotificationEmitterSupport getNotificationEmitter() {
        if (this.mNotificationEmitter == null) {
            this.mNotificationEmitter = new NotificationEmitterSupport(true);
        }
        return this.mNotificationEmitter;
    }

    public synchronized void addNotificationListener(NotificationListener listener) {
        this.getNotificationEmitter().addNotificationListener(listener, null, null);
    }

    public synchronized void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.getNotificationEmitter().addNotificationListener(listener, filter, handback);
    }

    public synchronized void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.getNotificationEmitter().removeNotificationListener(listener);
    }

    public synchronized void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.getNotificationEmitter().removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void sendNotification(Notification notification) {
        this.getNotificationEmitter().sendNotification(notification);
    }

    protected NotificationBuilder createNotificationBuilder(String notificationType) {
        NotificationBuilder builder = null;
        builder = notificationType.equals("jmx.attribute.change") ? new AttributeChangeNotificationBuilder(this.getObjectName()) : new NotificationBuilder(notificationType, this.getObjectName());
        return builder;
    }

    protected synchronized NotificationBuilder getNotificationBuilder(String notificationType) {
        NotificationBuilder builder;
        if (this.mNotificationBuilders == null) {
            this.mNotificationBuilders = new HashMap<String, NotificationBuilder>();
        }
        if ((builder = this.mNotificationBuilders.get(notificationType)) == null) {
            builder = this.createNotificationBuilder(notificationType);
            this.mNotificationBuilders.put(notificationType, builder);
        }
        return builder;
    }

    protected void sendNotification(String notificationType) {
        this.sendNotification(notificationType, notificationType, null, null);
    }

    protected void sendNotification(String notificationType, String key, Serializable value) {
        String message = "no message specified";
        this.sendNotification(notificationType, "no message specified", key, value);
    }

    protected void sendNotification(String notificationType, String message, String key, Serializable value) {
        NotificationBuilder builder = this.getNotificationBuilder(notificationType);
        Notification notif = builder.buildNew(message);
        NotificationBuilder.putMapData(notif, key, value);
        this.sendNotification(notif);
    }

    public final ObjectName getObjectName() {
        return this.mSelfObjectName;
    }

    public String getJMXDomain() {
        return this.getObjectName().getDomain();
    }

    public final MBeanServer getMBeanServer() {
        return this.mServer;
    }

    protected static String toString(Object o) {
        if (o == null) {
            return "";
        }
        return SmartStringifier.toString(o);
    }

    protected final void trace(Object o) {
        this.debug(o);
    }

    protected final void logSevere(Object o) {
        String msg = MBeanImplBase.toString(o);
        this.debug((Object)msg);
        if (this.getMBeanLogLevelInt() <= Level.SEVERE.intValue()) {
            this.getMBeanLogger().severe(msg);
        }
    }

    protected final void logWarning(Object o) {
        String msg = MBeanImplBase.toString(o);
        this.debug((Object)msg);
        if (this.getMBeanLogLevelInt() <= Level.WARNING.intValue()) {
            this.getMBeanLogger().warning(msg);
        }
    }

    protected final void logInfo(Object o) {
        String msg = MBeanImplBase.toString(o);
        this.debug((Object)msg);
        if (this.getMBeanLogLevelInt() <= Level.INFO.intValue()) {
            this.getMBeanLogger().info(msg);
        }
    }

    protected final void logFine(Object o) {
        String msg = MBeanImplBase.toString(o);
        this.debug((Object)msg);
        if (this.getMBeanLogLevelInt() <= Level.FINE.intValue()) {
            this.getMBeanLogger().fine(msg);
        }
    }

    protected final void logFiner(Object o) {
        String msg = MBeanImplBase.toString(o);
        this.debug((Object)msg);
        if (this.getMBeanLogLevelInt() <= Level.FINER.intValue()) {
            this.getMBeanLogger().finer(msg);
        }
    }

    protected final void logFinest(Object o) {
        String msg = MBeanImplBase.toString(o);
        this.debug((Object)msg);
        if (this.getMBeanLogLevelInt() <= Level.FINEST.intValue()) {
            this.getMBeanLogger().finest(msg);
        }
    }

    protected final Logger getMBeanLogger() {
        return Logger.getLogger("MBeans");
    }

    protected final Level _getMBeanLogLevel() {
        Logger logger = this.getMBeanLogger();
        assert (logger != null);
        Level level = logger.getLevel();
        while (level == null) {
            logger = logger.getParent();
            level = logger.getLevel();
        }
        return level;
    }

    public final String getMBeanLogLevel() {
        return "" + this._getMBeanLogLevel();
    }

    public final void setMBeanLogLevel(String level) {
        this.getMBeanLogger().setLevel(Level.parse(level));
    }

    protected final int getMBeanLogLevelInt() {
        return this._getMBeanLogLevel().intValue();
    }

    public final String getMBeanLoggerName() {
        return this.getMBeanLogger().getName();
    }

    protected static String quote(Object o) {
        return StringUtil.quote("" + o);
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName nameIn) throws Exception {
        assert (nameIn != null);
        this.mServer = server;
        this.mSelfObjectName = nameIn;
        return this.mSelfObjectName;
    }

    protected void postRegisterHook(Boolean registrationSucceeded) {
    }

    @Override
    public final void postRegister(Boolean registrationSucceeded) {
        if (registrationSucceeded.booleanValue()) {
            this.getMBeanLogger().log(Level.FINEST, "postRegister: {0}", this.getObjectName());
        } else {
            this.getMBeanLogger().log(Level.FINEST, "postRegister: FAILURE: {0}", this.getObjectName());
        }
        this.postRegisterHook(registrationSucceeded);
    }

    protected void preDeregisterHook() throws Exception {
    }

    @Override
    public final void preDeregister() throws Exception {
        this.getMBeanLogger().log(Level.FINEST, "preDeregister: {0}", this.getObjectName());
        this.preDeregisterHook();
    }

    protected void postDeregisterHook() {
    }

    @Override
    public final void postDeregister() {
        this.getMBeanLogger().log(Level.FINEST, "postDeregister: {0}", this.getObjectName());
        this.postDeregisterHook();
        if (this.mNotificationEmitter != null) {
            this.mNotificationEmitter.cleanup();
            this.mNotificationEmitter = null;
        }
        if (this.mNotificationBuilders != null) {
            this.mNotificationBuilders.clear();
            this.mNotificationBuilders = null;
        }
    }

    protected String getDebugID() {
        return this.getClass().getName();
    }

    public final boolean getAMXDebug() {
        return AMXDebug.getInstance().getDebug(this.getDebugID());
    }

    public boolean enableAMXDebug(boolean enabled) {
        boolean formerValue = this.getAMXDebug();
        if (formerValue != enabled) {
            this.setAMXDebug(enabled);
        }
        return formerValue;
    }

    protected Output getDebugOutput() {
        return AMXDebug.getInstance().getOutput(this.getDebugID());
    }

    public final void setAMXDebug(boolean debug) {
        AMXDebug.getInstance().setDebug(this.getDebugID(), debug);
    }

    protected boolean shouldOmitObjectNameForDebug() {
        return this.mSelfObjectName == null;
    }

    protected final void debug(Object o) {
        if (this.getAMXDebug() && this.mDebug != null) {
            String newline = System.getProperty("line.separator");
            if (this.shouldOmitObjectNameForDebug()) {
                this.mDebug.println(o);
            } else {
                this.mDebug.println(this.mSelfObjectName.toString());
                this.mDebug.println("===> " + o);
            }
            this.mDebug.println(newline);
        }
    }

    protected void debugMethod(String methodName, Object ... args) {
        if (this.getAMXDebug()) {
            this.debug((Object)AMXDebug.methodString(methodName, args));
        }
    }

    protected void debugMethod(String msg, String methodName, Object ... args) {
        if (this.getAMXDebug()) {
            this.debug((Object)(AMXDebug.methodString(methodName, args) + ": " + msg));
        }
    }

    protected void debug(Object ... args) {
        if (this.getAMXDebug()) {
            this.debug((Object)StringUtil.toString("", args));
        }
    }
}

