/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.provider;

import com.sun.enterprise.security.SecurityRoleMapperFactoryGen;
import com.sun.enterprise.security.provider.JDKPolicyFileWrapper;
import com.sun.enterprise.security.provider.PolicyConfigurationFactoryImpl;
import com.sun.enterprise.security.provider.PolicyParser;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import sun.net.www.ParseUtil;
import sun.security.provider.PolicyFile;

public class PolicyConfigurationImpl
implements PolicyConfiguration {
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PolicyConfigurationImpl.class);
    private static final String policySuffix = ".policy";
    private static final String PROVIDER_URL = "policy.url.";
    private static final Class<?>[] permissionParams = new Class[]{String.class, String.class};
    public static final int OPEN_STATE = 0;
    public static final int INSERVICE_STATE = 2;
    public static final int DELETED_STATE = 3;
    String CONTEXT_ID;
    private Permissions excludedPermissions;
    private Permissions uncheckedPermissions;
    private Map<String, Permissions> roleToPermissionsMap;
    protected int state = 0;
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private Lock rLock = this.rwLock.readLock();
    private Lock wLock = this.rwLock.writeLock();
    private boolean writeOnCommit = true;
    private boolean wasRefreshed;
    private Policy policy;
    private String policyUrlValue;
    private long[] lastModTimes = new long[2];
    private final Object refreshLock = new Object();
    private String repository;
    private Permission setPolicyPermission = new SecurityPermission("setPolicy");
    private PolicyConfigurationFactoryImpl configurationFactory;

    protected PolicyConfigurationImpl(String contextId, PolicyConfigurationFactoryImpl configurationFactory) {
        this.CONTEXT_ID = contextId;
        this.configurationFactory = configurationFactory;
        this.repository = configurationFactory.getRepository();
        this.initialize(true, true, false);
    }

    protected PolicyConfigurationImpl(File applicationPolicyDirectory, boolean open, boolean remove, PolicyConfigurationFactoryImpl configurationFactory) {
        this.configurationFactory = configurationFactory;
        this.CONTEXT_ID = applicationPolicyDirectory.getParentFile().getName() + '/' + applicationPolicyDirectory.getName();
        this.repository = configurationFactory.getRepository();
        String policyFileName = this.getPolicyFileName(true);
        File policyFile = new File(policyFileName);
        if (!policyFile.exists()) {
            String defMsg = "Unable to open Policy file: " + policyFileName;
            logger.log(Level.SEVERE, localStrings.getLocalString("pc.file_not_found", defMsg, new Object[]{policyFileName}));
            throw new RuntimeException(defMsg);
        }
        this.initialize(open, remove, true);
    }

    @Override
    public String getContextID() throws PolicyContextException {
        this.checkSetPolicyPermission();
        return this.CONTEXT_ID;
    }

    @Override
    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        this.assertStateIsOpen();
        if (roleName != null && permissions != null) {
            this.checkSetPolicyPermission();
            for (Permission permission : Collections.list(permissions.elements())) {
                this.getRolePermissions(roleName).add(permission);
                this.writeOnCommit = true;
            }
        }
    }

    @Override
    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        this.assertStateIsOpen();
        if (roleName != null && permission != null) {
            this.checkSetPolicyPermission();
            this.getRolePermissions(roleName).add(permission);
            this.writeOnCommit = true;
        }
    }

    @Override
    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        this.assertStateIsOpen();
        if (permissions != null) {
            this.checkSetPolicyPermission();
            for (Permission permission : Collections.list(permissions.elements())) {
                this.getUncheckedPermissions().add(permission);
                this.writeOnCommit = true;
            }
        }
    }

    @Override
    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        this.assertStateIsOpen();
        if (permission != null) {
            this.checkSetPolicyPermission();
            this.getUncheckedPermissions().add(permission);
            this.writeOnCommit = true;
        }
    }

    @Override
    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        this.assertStateIsOpen();
        if (permissions != null) {
            this.checkSetPolicyPermission();
            for (Permission permission : Collections.list(permissions.elements())) {
                this.getExcludedPermissions().add(permission);
                this.writeOnCommit = true;
            }
        }
    }

    @Override
    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        this.assertStateIsOpen();
        if (permission != null) {
            this.checkSetPolicyPermission();
            this.getExcludedPermissions().add(permission);
            this.writeOnCommit = true;
        }
    }

    @Override
    public void removeRole(String roleName) throws PolicyContextException {
        this.assertStateIsOpen();
        if (roleName != null && this.roleToPermissionsMap != null) {
            this.checkSetPolicyPermission();
            if (this.roleToPermissionsMap.remove(roleName) != null) {
                if (this.roleToPermissionsMap.isEmpty()) {
                    this.roleToPermissionsMap = null;
                }
                this.writeOnCommit = true;
            } else if (roleName.equals("*")) {
                boolean wasEmpty = this.roleToPermissionsMap.isEmpty();
                if (!wasEmpty) {
                    this.roleToPermissionsMap.clear();
                }
                this.roleToPermissionsMap = null;
                if (!wasEmpty) {
                    this.writeOnCommit = true;
                }
            }
        }
    }

    @Override
    public void removeUncheckedPolicy() throws PolicyContextException {
        this.assertStateIsOpen();
        this.checkSetPolicyPermission();
        if (this.uncheckedPermissions != null) {
            this.uncheckedPermissions = null;
            this.writeOnCommit = true;
        }
    }

    @Override
    public void removeExcludedPolicy() throws PolicyContextException {
        this.assertStateIsOpen();
        this.checkSetPolicyPermission();
        if (this.excludedPermissions != null) {
            this.excludedPermissions = null;
            this.writeOnCommit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws PolicyContextException {
        Object object = this.refreshLock;
        synchronized (object) {
            if (this.stateIs(3)) {
                String defMsg = "Cannot perform Operation on a deleted PolicyConfiguration";
                logger.log(Level.WARNING, localStrings.getLocalString("pc.invalid_op_for_state_delete", defMsg));
                throw new UnsupportedOperationException(defMsg);
            }
            try {
                this.checkSetPolicyPermission();
                if (this.stateIs(0)) {
                    this.generatePermissions();
                    this.setState(2);
                }
            }
            catch (Exception e) {
                String defMsg = "commit fail for contextod " + this.CONTEXT_ID;
                logger.log(Level.SEVERE, localStrings.getLocalString("pc.commit_failure", defMsg, new Object[]{this.CONTEXT_ID, e}));
                throw new PolicyContextException(e);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC Policy Provider: PC.commit " + this.CONTEXT_ID);
            }
        }
    }

    @Override
    public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
        this.assertStateIsOpen();
        String linkId = link.getContextID();
        if (this.CONTEXT_ID.equals(linkId)) {
            String defMsg = "Operation attempted to link PolicyConfiguration to itself.";
            logger.log(Level.WARNING, localStrings.getLocalString("pc.unsupported_link_operation", defMsg));
            throw new IllegalArgumentException(defMsg);
        }
        this.checkSetPolicyPermission();
        this.updateLinkTable(linkId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws PolicyContextException {
        this.checkSetPolicyPermission();
        Object object = this.refreshLock;
        synchronized (object) {
            try {
                this.removePolicy();
            }
            finally {
                this.setState(3);
            }
        }
    }

    @Override
    public boolean inService() throws PolicyContextException {
        this.checkSetPolicyPermission();
        boolean isInService = this.stateIs(2);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC Policy Provider: inService: " + (isInService ? "true " : "false ") + this.CONTEXT_ID);
        }
        return isInService;
    }

    protected void checkSetPolicyPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(this.setPolicyPermission);
        }
    }

    protected Policy getPolicy() {
        if (this.stateIs(2)) {
            return this.policy;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JACC Policy Provider: getPolicy (" + this.CONTEXT_ID + ") is NOT in service");
        }
        return null;
    }

    protected Permissions getExcludedPolicy() {
        return this.stateIs(2) ? this.excludedPermissions : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(boolean force) {
        Object object = this.refreshLock;
        synchronized (object) {
            if (this.stateIs(2) && (!this.wasRefreshed || force || this.filesChanged())) {
                int i = 0;
                String value = null;
                String urlKey = null;
                while ((value = this.getSecurityProperty(urlKey = PROVIDER_URL + ++i)) != null && !value.equals("")) {
                }
                try {
                    this.setSecurityProperty(urlKey, this.policyUrlValue);
                    if (this.fileChanged(false)) {
                        this.excludedPermissions = this.loadExcludedPolicy();
                    }
                    this.captureFileTime(true);
                    if (this.policy == null) {
                        this.policy = this.getNewPolicy();
                    } else {
                        this.policy.refresh();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("JACC Policy Provider: Called Policy.refresh on contextId: " + this.CONTEXT_ID + " policyUrlValue was " + this.policyUrlValue);
                        }
                    }
                    this.wasRefreshed = true;
                }
                finally {
                    this.setSecurityProperty(urlKey, "");
                }
            }
        }
    }

    private Policy getNewPolicy() {
        Policy wrapper = Policy.getPolicy();
        if (wrapper != null && wrapper instanceof JDKPolicyFileWrapper) {
            return ((JDKPolicyFileWrapper)wrapper).getNewPolicy();
        }
        return new PolicyFile();
    }

    private void captureFileTime(boolean granted) {
        this.lastModTimes[granted ? 1 : 0] = new File(this.getPolicyFileName(granted)).lastModified();
    }

    private boolean filesChanged() {
        return this.fileChanged(true) || this.fileChanged(false);
    }

    private boolean fileChanged(boolean granted) {
        return this._fileChanged(granted, new File(this.getPolicyFileName(granted)));
    }

    private boolean _fileChanged(boolean granted, File f) {
        return this.lastModTimes[granted ? 1 : 0] != f.lastModified();
    }

    private boolean fileArrived(boolean granted) {
        boolean hasFileArrived;
        File policyFile = new File(this.getPolicyFileName(granted));
        boolean bl = hasFileArrived = policyFile.exists() && this._fileChanged(granted, policyFile);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC Policy Provider: file arrival check type: " + (granted ? "granted " : "excluded ") + " arrived: " + hasFileArrived + " exists: " + policyFile.exists() + " lastModified: " + policyFile.lastModified() + " storedTime: " + this.lastModTimes[granted ? 1 : 0] + " state: " + (this.state == 0 ? "open " : "deleted ") + this.CONTEXT_ID);
        }
        return hasFileArrived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(boolean open, boolean remove, boolean fromFile) {
        Object object = this.refreshLock;
        synchronized (object) {
            String name = this.getPolicyFileName(true);
            if (open || remove) {
                this.setState(0);
            } else {
                this.setState(2);
            }
            try {
                if (remove) {
                    this.removePolicy();
                }
                this.policyUrlValue = ParseUtil.fileToEncodedURL(new File(name)).toString();
                if (fromFile && !remove) {
                    this.uncheckedPermissions = null;
                    this.roleToPermissionsMap = null;
                    this.excludedPermissions = this.loadExcludedPolicy();
                    this.initLinkTable();
                    this.captureFileTime(true);
                    this.writeOnCommit = false;
                }
                this.wasRefreshed = false;
            }
            catch (MalformedURLException e) {
                String defMsg = "Unable to convert Policy file Name to URL: " + name;
                logger.log(Level.SEVERE, localStrings.getLocalString("pc.file_to_url", defMsg, new Object[]{name, e}));
                throw new RuntimeException(defMsg);
            }
        }
    }

    private String getPolicyFileName(boolean granted) {
        return granted ? this.getContextDirectoryName() + File.separator + "granted" + policySuffix : this.getContextDirectoryName() + File.separator + "excluded" + policySuffix;
    }

    private String getContextDirectoryName() {
        if (this.repository == null) {
            throw new RuntimeException("JACC Policy provider: repository not initialized");
        }
        return this.configurationFactory.getContextDirectoryName(this.CONTEXT_ID);
    }

    private void removePolicyContextDirectory() {
        String directoryName = this.getContextDirectoryName();
        File contextDirectory = new File(directoryName);
        if (contextDirectory.exists()) {
            File[] moduleDirs;
            File appDir;
            File[] fs;
            File[] files = contextDirectory.listFiles();
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].delete()) continue;
                    String msg = localStrings.getLocalString("pc.file_delete_error", "Error while deleting policy file");
                    logger.log(Level.SEVERE, msg);
                    throw new RuntimeException(msg);
                }
            }
            if (!contextDirectory.delete()) {
                String defMsg = "Failure removing policy context directory: " + directoryName;
                logger.log(Level.SEVERE, localStrings.getLocalString("pc.file_delete_error", defMsg));
                throw new RuntimeException(defMsg);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC Policy Provider: Policy context directory removed: " + directoryName);
            }
            if ((fs = (appDir = contextDirectory.getParentFile()).listFiles()) != null && fs.length > 0) {
                int i;
                boolean hasDir = false;
                for (i = 0; i < fs.length; ++i) {
                    if (!fs[i].isDirectory()) continue;
                    hasDir = true;
                    break;
                }
                if (!hasDir) {
                    for (i = 0; i < fs.length; ++i) {
                        fs[i].delete();
                    }
                }
            }
            if (!((moduleDirs = appDir.listFiles()) != null && moduleDirs.length != 0 || appDir.delete())) {
                String defMsg = "Failure removing policy context directory: " + appDir;
                logger.log(Level.SEVERE, localStrings.getLocalString("pc.file_delete_error", defMsg));
                throw new RuntimeException(defMsg);
            }
        }
    }

    private void removePolicyFile(boolean granted) {
        String fileName = this.getPolicyFileName(granted);
        File policyFile = new File(fileName);
        if (policyFile.exists()) {
            if (!policyFile.delete()) {
                String defMsg = "Failure removing policy file: " + fileName;
                logger.log(Level.SEVERE, localStrings.getLocalString("pc.file_delete_error", defMsg, new Object[]{fileName}));
                throw new RuntimeException(defMsg);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC Policy Provider: Policy file removed: " + fileName);
            }
        }
    }

    private void removePolicy() {
        this.excludedPermissions = null;
        this.uncheckedPermissions = null;
        this.roleToPermissionsMap = null;
        this.removePolicyFile(true);
        this.removePolicyFile(false);
        this.removePolicyContextDirectory();
        this.initLinkTable();
        this.policy = null;
        this.writeOnCommit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLinkTable() {
        Object object = this.refreshLock;
        synchronized (object) {
            Set<String> linkSet = this.configurationFactory.getLinkTable().get(this.CONTEXT_ID);
            if (linkSet != null) {
                linkSet.remove(this.CONTEXT_ID);
                this.configurationFactory.getLinkTable().remove(this.CONTEXT_ID);
            }
            linkSet = new HashSet<String>();
            linkSet.add(this.CONTEXT_ID);
            this.configurationFactory.getLinkTable().put(this.CONTEXT_ID, linkSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkTable(String otherId) {
        Object object = this.refreshLock;
        synchronized (object) {
            Set<String> thisLinkSet = this.configurationFactory.getLinkTable().get(this.CONTEXT_ID);
            Set<String> otherLinkSet = this.configurationFactory.getLinkTable().get(otherId);
            if (otherLinkSet == null) {
                logger.log(Level.SEVERE, "pc.invalid_link_target", otherId);
                throw new RuntimeException("Linked policy configuration (" + otherId + ") does not exist");
            }
            for (String otherContextId : otherLinkSet) {
                thisLinkSet.add(otherContextId);
                this.configurationFactory.getLinkTable().put(otherContextId, thisLinkSet);
            }
        }
    }

    private void setState(int stateValue) {
        this.wLock.lock();
        try {
            this.state = stateValue;
        }
        finally {
            this.wLock.unlock();
        }
    }

    private boolean _stateIs(int stateValue) {
        this.rLock.lock();
        try {
            boolean bl = this.state == stateValue;
            return bl;
        }
        finally {
            this.rLock.unlock();
        }
    }

    private boolean stateIs(int stateValue) {
        boolean inState = this._stateIs(stateValue);
        if (stateValue == 2 && !inState) {
            Boolean fileArrived = AccessController.doPrivileged(() -> this.fileArrived(true) || this.fileArrived(false));
            if (fileArrived.booleanValue()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("JACC Policy Provider: file arrived transition to inService:  state: " + (this.state == 0 ? "open " : "deleted ") + this.CONTEXT_ID);
                }
                this.initialize(false, false, true);
            }
            inState = this._stateIs(2);
        }
        return inState;
    }

    private void assertStateIsOpen() {
        if (!this.stateIs(0)) {
            String defMsg = "Operation invoked on closed or deleted PolicyConfiguration.";
            logger.log(Level.WARNING, localStrings.getLocalString("pc.op_requires_state_open", defMsg));
            throw new UnsupportedOperationException(defMsg);
        }
    }

    private Permissions getUncheckedPermissions() {
        if (this.uncheckedPermissions == null) {
            this.uncheckedPermissions = new Permissions();
        }
        return this.uncheckedPermissions;
    }

    private Permissions getExcludedPermissions() {
        if (this.excludedPermissions == null) {
            this.excludedPermissions = new Permissions();
        }
        return this.excludedPermissions;
    }

    private Permissions getRolePermissions(String roleName) {
        if (this.roleToPermissionsMap == null) {
            this.roleToPermissionsMap = new HashMap<String, Permissions>();
        }
        return this.roleToPermissionsMap.computeIfAbsent(roleName, key -> new Permissions());
    }

    private String escapeName(String name) {
        return name != null && name.indexOf(34) > 0 ? name.replaceAll("\"", "\\\\\"") : name;
    }

    private void generatePermissions() throws FileNotFoundException, IOException {
        if (!this.writeOnCommit) {
            return;
        }
        Map<String, Subject> roleToSubjectMap = this.getRoleToSubjectMap();
        this.checkNotNullWhenNeeded(roleToSubjectMap);
        PolicyParser parser = new PolicyParser(false);
        if (this.uncheckedPermissions != null) {
            this.addUncheckedGrantsToParser(parser);
        }
        if (this.roleToPermissionsMap != null) {
            this.addRoleBasedGrantsToParser(roleToSubjectMap, parser);
        }
        this.writeOnCommit = this.createPolicyFile(true, parser, this.writeOnCommit);
        if (this.excludedPermissions != null) {
            PolicyParser excludedParser = new PolicyParser(false);
            this.addExcludedPermissionsToParser(excludedParser);
            this.writeOnCommit = this.createPolicyFile(false, excludedParser, this.writeOnCommit);
        }
        if (!this.writeOnCommit) {
            this.wasRefreshed = false;
        }
    }

    private Map<String, Subject> getRoleToSubjectMap() {
        if (this.roleToPermissionsMap == null) {
            return null;
        }
        Map roleToSubjectMap = null;
        SecurityRoleMapperFactory factory = SecurityRoleMapperFactoryGen.getSecurityRoleMapperFactory();
        if (factory != null) {
            Set<String> linkContextIds;
            SecurityRoleMapper securityRoleMapper = factory.getRoleMapper(this.CONTEXT_ID);
            if (securityRoleMapper != null) {
                roleToSubjectMap = securityRoleMapper.getRoleToSubjectMapping();
            }
            if (roleToSubjectMap != null && (linkContextIds = this.configurationFactory.getLinkTable().get(this.CONTEXT_ID)) != null) {
                for (String contextId : linkContextIds) {
                    if (this.CONTEXT_ID.equals(contextId)) continue;
                    SecurityRoleMapper otherSecurityRoleMapper = factory.getRoleMapper(contextId);
                    Map otherRoleToSubjectMap = null;
                    if (otherSecurityRoleMapper != null) {
                        otherRoleToSubjectMap = otherSecurityRoleMapper.getRoleToSubjectMapping();
                    }
                    if (otherRoleToSubjectMap == roleToSubjectMap) continue;
                    String defMsg = "Linked policy contexts have different roleToSubjectMaps (" + this.CONTEXT_ID + ")<->(" + contextId + ")";
                    logger.log(Level.SEVERE, localStrings.getLocalString("pc.linked_with_different_role_maps", defMsg, new Object[]{this.CONTEXT_ID, contextId}));
                    throw new RuntimeException(defMsg);
                }
            }
        }
        return roleToSubjectMap;
    }

    private void checkNotNullWhenNeeded(Map<String, Subject> roleToSubjectMap) {
        if (roleToSubjectMap == null && this.roleToPermissionsMap != null) {
            String defMsg = "This application has no role mapper factory defined";
            logger.log(Level.SEVERE, localStrings.getLocalString("pc.role_map_not_defined_at_commit", defMsg, new Object[]{this.CONTEXT_ID}));
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.deployment.norolemapperfactorydefine", defMsg));
        }
    }

    private void addUncheckedGrantsToParser(PolicyParser parser) {
        ArrayList<Permission> permissions = Collections.list(this.uncheckedPermissions.elements());
        if (!permissions.isEmpty()) {
            PolicyParser.GrantEntry grant = new PolicyParser.GrantEntry();
            this.addPermissionsToGrant(permissions, grant);
            parser.add(grant);
        }
    }

    private void addRoleBasedGrantsToParser(Map<String, Subject> roleToSubjectMap, PolicyParser parser) {
        for (String roleName : this.roleToPermissionsMap.keySet()) {
            boolean withPrincipals = false;
            Permissions rolePermissions = this.getRolePermissions(roleName);
            Subject subject = roleToSubjectMap.get(roleName);
            if (subject != null) {
                for (Principal principal : subject.getPrincipals()) {
                    if (principal != null) {
                        withPrincipals = true;
                        PolicyParser.GrantEntry grant = new PolicyParser.GrantEntry();
                        grant.principals.add(new PolicyParser.PrincipalEntry(principal.getClass().getName(), this.escapeName(principal.getName())));
                        this.addPermissionsToGrant(rolePermissions, grant);
                        parser.add(grant);
                        continue;
                    }
                    logger.log(Level.WARNING, localStrings.getLocalString("pc.non_principal_mapped_to_role", "non principal mapped to role " + roleName, new Object[]{principal, roleName}));
                }
            }
            if (!withPrincipals && "**".equals(roleName)) {
                withPrincipals = true;
                PolicyParser.GrantEntry grant = new PolicyParser.GrantEntry();
                grant.principals.add(new PolicyParser.PrincipalEntry("WILDCARD_PRINCIPAL_CLASS", "WILDCARD_PRINCIPAL_NAME"));
                this.addPermissionsToGrant(rolePermissions, grant);
                parser.add(grant);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("JACC Policy Provider: added role grant for any authenticated user");
                }
            }
            if (withPrincipals) continue;
            logger.log(Level.WARNING, localStrings.getLocalString("pc.no_principals_mapped_to_role", "no principals mapped to role " + roleName, new Object[]{roleName}));
        }
    }

    private void addExcludedPermissionsToParser(PolicyParser parser) {
        ArrayList<Permission> permissions = Collections.list(this.excludedPermissions.elements());
        if (!permissions.isEmpty()) {
            PolicyParser.GrantEntry grant = new PolicyParser.GrantEntry();
            this.addPermissionsToGrant(permissions, grant);
            parser.add(grant);
        }
    }

    private void addPermissionsToGrant(Permissions permissions, PolicyParser.GrantEntry grant) {
        this.addPermissionsToGrant(Collections.list(permissions.elements()), grant);
    }

    private void addPermissionsToGrant(List<Permission> permissions, PolicyParser.GrantEntry grant) {
        for (Permission permission : permissions) {
            grant.add(new PolicyParser.PermissionEntry(permission.getClass().getName(), permission.getName(), permission.getActions()));
        }
    }

    private void createPolicyContextDirectory() {
        String contextDirectoryName = this.getContextDirectoryName();
        File contectDirectory = new File(contextDirectoryName);
        String defMsg = "unable to create policy context directory";
        String msg = localStrings.getLocalString("pc.unable_to_create_context_directory", defMsg, new Object[]{contextDirectoryName});
        if (contectDirectory.exists()) {
            if (!contectDirectory.isDirectory()) {
                logger.log(Level.SEVERE, msg);
                throw new RuntimeException(defMsg);
            }
        } else if (!contectDirectory.mkdirs()) {
            logger.log(Level.SEVERE, msg);
            throw new RuntimeException(defMsg);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createPolicyFile(boolean granted, PolicyParser parser, boolean woc) throws IOException {
        boolean result = woc;
        this.createPolicyContextDirectory();
        this.removePolicyFile(granted);
        String name = this.getPolicyFileName(granted);
        OutputStreamWriter writer = null;
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC Policy Provider: Writing grant statements to policy file: " + name);
            }
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(name), "UTF-8");
            parser.write(writer);
            result = false;
            if (writer == null) return result;
        }
        catch (FileNotFoundException fnfe) {
            try {
                logger.log(Level.SEVERE, localStrings.getLocalString("pc.file_error", "file not found " + name, new Object[]{name, fnfe}));
                throw fnfe;
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, localStrings.getLocalString("pc.file_write_error", "file IO error on file " + name, new Object[]{name, ioe}));
                    throw ioe;
                }
            }
            catch (Throwable throwable) {
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    this.captureFileTime(granted);
                    throw throwable;
                }
                catch (Exception e) {
                    String defMsg = "Unable to close Policy file: " + name;
                    logger.log(Level.SEVERE, localStrings.getLocalString("pc.file_close_error", defMsg, new Object[]{name, e}));
                    throw new RuntimeException(defMsg);
                }
            }
        }
        try {
            writer.close();
            this.captureFileTime(granted);
            return result;
        }
        catch (Exception e) {
            String defMsg = "Unable to close Policy file: " + name;
            logger.log(Level.SEVERE, localStrings.getLocalString("pc.file_close_error", defMsg, new Object[]{name, e}));
            throw new RuntimeException(defMsg);
        }
    }

    private Permission loadPermission(String className, String name, String actions) {
        Class<?> clazz = null;
        Permission permission = null;
        try {
            clazz = Class.forName(className);
            Constructor<?> c = clazz.getConstructor(permissionParams);
            permission = (Permission)c.newInstance(name, actions);
        }
        catch (Exception e) {
            String defMsg = "PolicyConfiguration error loading permission";
            String msg = localStrings.getLocalString("pc.permission_load_error", defMsg, new Object[]{className, e});
            logger.log(Level.SEVERE, msg);
            throw new RuntimeException(defMsg, e);
        }
        return permission;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Permissions loadExcludedPolicy() {
        block18: {
            result = null;
            name = this.getPolicyFileName(false);
            parser = new PolicyParser(false);
            reader = null;
            try {
                this.captureFileTime(false);
                reader = new FileReader(name);
                parser.read(reader);
                ** if (reader == null) goto lbl-1000
            }
            catch (FileNotFoundException fnf) {
                parser = null;
                if (reader == null) break block18;
                {
                    catch (Throwable var7_16) {
                        if (reader == null) throw var7_16;
                        try {
                            reader.close();
                            throw var7_16;
                        }
                        catch (Exception e) {
                            defMsg = "Unable to close Policy file: " + name;
                            PolicyConfigurationImpl.logger.log(Level.SEVERE, PolicyConfigurationImpl.localStrings.getLocalString("pc.file_close_error", defMsg, new Object[]{name, e}));
                            throw new RuntimeException(defMsg);
                        }
                    }
                }
                try {
                    reader.close();
                }
                catch (Exception e) {
                    defMsg = "Unable to close Policy file: " + name;
                    PolicyConfigurationImpl.logger.log(Level.SEVERE, PolicyConfigurationImpl.localStrings.getLocalString("pc.file_close_error", defMsg, new Object[]{name, e}));
                    throw new RuntimeException(defMsg);
                }
                catch (IOException ioe) {
                    defMsg = "Error reading Policy file: " + name;
                    PolicyConfigurationImpl.logger.log(Level.SEVERE, PolicyConfigurationImpl.localStrings.getLocalString("pc.file_read_error", defMsg, new Object[]{name, ioe}));
                    throw new RuntimeException(defMsg);
                    catch (PolicyParser.ParsingException pe) {
                        defMsg = "Unable to parse Policy file: " + name;
                        PolicyConfigurationImpl.logger.log(Level.SEVERE, PolicyConfigurationImpl.localStrings.getLocalString("pc.policy_parsing_exception", defMsg, new Object[]{name, pe}));
                        throw new RuntimeException(defMsg);
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    defMsg = "Unable to close Policy file: " + name;
                    PolicyConfigurationImpl.logger.log(Level.SEVERE, PolicyConfigurationImpl.localStrings.getLocalString("pc.file_close_error", defMsg, new Object[]{name, e}));
                    throw new RuntimeException(defMsg);
                }
            }
lbl-1000:
            // 1 sources

            {
            }
        }
        if (parser == null) return result;
        var5_10 = Collections.list(parser.grantElements()).iterator();
        block13: while (true) {
            if (var5_10.hasNext() == false) return result;
            grant = var5_10.next();
            if (grant.codeBase != null || grant.signedBy != null || grant.principals.size() != 0) {
                PolicyConfigurationImpl.logger.log(Level.WARNING, PolicyConfigurationImpl.localStrings.getLocalString("pc.excluded_grant_context_ignored", "ignore excluded grant context", new Object[]{grant}));
                continue;
            }
            var7_17 = Collections.list(grant.permissionEntries.elements()).iterator();
            while (true) {
                if (var7_17.hasNext()) ** break;
                continue block13;
                entry = var7_17.next();
                permission = this.loadPermission(entry.permission, entry.name, entry.action);
                if (result == null) {
                    result = new Permissions();
                }
                result.add(permission);
            }
            break;
        }
    }

    private void setSecurityProperty(final String key, final String value) {
        if (System.getSecurityManager() == null) {
            Security.setProperty(key, value);
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Security.setProperty(key, value);
                return null;
            }
        });
    }

    private String getSecurityProperty(final String key) {
        if (System.getSecurityManager() == null) {
            return Security.getProperty(key);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(key);
            }
        });
    }
}

