/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jacc;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.deployment.runtime.common.wls.SecurityRoleAssignment;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityRoleMapperFactoryGen;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.WebSecurityDeployerProbeProvider;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.ee.SecurityUtil;
import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.enterprise.security.jacc.JaccWebConstraintsTranslator;
import com.sun.enterprise.security.jacc.cache.CachedPermission;
import com.sun.enterprise.security.jacc.cache.CachedPermissionImpl;
import com.sun.enterprise.security.jacc.cache.PermissionCache;
import com.sun.enterprise.security.jacc.cache.PermissionCacheFactory;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import fish.payara.jacc.JaccConfigurationFactory;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.enterprise.CallerPrincipal;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;
import org.glassfish.security.common.Role;

public class JaccWebAuthorizationManager {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    public static final String CONSTRAINT_URI = "org.apache.catalina.CONSTRAINT_URI";
    private static final String RESOURCE = "hasResourcePermission";
    private static final String USERDATA = "hasUserDataPermission";
    private static final String EMPTY_STRING = "";
    private static final WebResourcePermission allResources = new WebResourcePermission("/*", (String)null);
    private static final WebUserDataPermission allConnections = new WebUserDataPermission("/*", null);
    private static Permission[] protoPerms = new Permission[]{allResources, allConnections};
    private static Set<Principal> defaultPrincipalSet = SecurityContext.getDefaultSecurityContext().getPrincipalSet();
    private final String CONTEXT_ID;
    private String CODEBASE;
    protected Policy policy = Policy.getPolicy();
    protected PolicyConfigurationFactory policyConfigurationFactory;
    protected PolicyConfiguration policyConfiguration;
    protected CodeSource codesource;
    private final Map<Set<Principal>, ProtectionDomain> protectionDomainCache = Collections.synchronizedMap(new WeakHashMap());
    private CachedPermission allResourcesCachedPermission;
    private CachedPermission allConnectionsCachedPermission;
    private PermissionCache uncheckedPermissionCache;
    private final WebSecurityManagerFactory webSecurityManagerFactory;
    private final ServerContext serverContext;
    private final WebBundleDescriptor webBundleDescriptor;
    private final WebSecurityDeployerProbeProvider probeProvider = new WebSecurityDeployerProbeProvider();
    private boolean register = true;

    public JaccWebAuthorizationManager(WebBundleDescriptor webBundleDescriptor, ServerContext serverContext, WebSecurityManagerFactory webSecurityManagerFactory, boolean register) throws PolicyContextException {
        this.register = register;
        this.webBundleDescriptor = webBundleDescriptor;
        this.CONTEXT_ID = JaccWebAuthorizationManager.getContextID(webBundleDescriptor);
        this.serverContext = serverContext;
        this.webSecurityManagerFactory = webSecurityManagerFactory;
        String appname = this.getAppId();
        SecurityRoleMapperFactoryGen.getSecurityRoleMapperFactory().setAppNameForContext(this.getAppId(), this.CONTEXT_ID);
        this.initialise(appname);
    }

    public static String getContextID(WebBundleDescriptor webBundleDescriptor) {
        return SecurityUtil.getContextID(webBundleDescriptor);
    }

    public boolean hasNoConstrainedResources() {
        boolean noConstrainedResources = false;
        if (this.allResourcesCachedPermission != null && this.allConnectionsCachedPermission != null) {
            boolean x = this.allResourcesCachedPermission.checkPermission();
            boolean y = this.allConnectionsCachedPermission.checkPermission();
            boolean bl = noConstrainedResources = x && y;
            if (noConstrainedResources) {
                try {
                    JaccWebAuthorizationManager.setPolicyContext(this.CONTEXT_ID);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }
        return noConstrainedResources;
    }

    public int hasUserDataPermission(HttpServletRequest servletRequest, String uri, String httpMethod) {
        WebUserDataPermission dataPermission;
        this.setServletRequestForJACC(servletRequest);
        boolean requestIsSecure = servletRequest.isSecure();
        if (uri == null) {
            dataPermission = new WebUserDataPermission(servletRequest);
        } else {
            String[] stringArray;
            if (httpMethod == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = httpMethod;
            }
            dataPermission = new WebUserDataPermission(uri, stringArray, requestIsSecure ? "CONFIDENTIAL" : null);
        }
        boolean isGranted = this.checkPermission((Permission)dataPermission, defaultPrincipalSet);
        int result = 0;
        if (isGranted) {
            result = 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasUserDataPermission permission: {0}", dataPermission);
            logger.log(Level.FINE, "[Web-Security] hasUserDataPermission isGranted: {0}", isGranted);
        }
        this.recordWebInvocation(servletRequest, USERDATA, isGranted);
        if (!isGranted && !requestIsSecure) {
            String[] stringArray;
            if (uri == null) {
                httpMethod = servletRequest.getMethod();
            }
            String string = dataPermission.getName();
            if (httpMethod == null) {
                stringArray = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = httpMethod;
            }
            dataPermission = new WebUserDataPermission(string, stringArray, "CONFIDENTIAL");
            isGranted = this.checkPermission((Permission)dataPermission, defaultPrincipalSet);
            if (isGranted) {
                result = -1;
            }
        }
        return result;
    }

    public boolean isPermitAll(HttpServletRequest request) {
        boolean isPermitAll = false;
        WebResourcePermission webResourcePermission = this.createWebResourcePermission(request);
        if (this.uncheckedPermissionCache != null) {
            isPermitAll = this.uncheckedPermissionCache.checkPermission((Permission)webResourcePermission);
        }
        if (!isPermitAll) {
            isPermitAll = this.checkPermissionWithoutCache((Permission)webResourcePermission, null);
        }
        return isPermitAll;
    }

    public boolean hasResourcePermission(HttpServletRequest servletRequest) {
        SecurityContext securityContect = this.getSecurityContext(servletRequest.getUserPrincipal());
        WebResourcePermission webResourcePermission = this.createWebResourcePermission(servletRequest);
        this.setServletRequestForJACC(servletRequest);
        boolean isGranted = this.checkPermission((Permission)webResourcePermission, securityContect.getPrincipalSet());
        SecurityContext.setCurrent(securityContect);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasResource isGranted: {0}", isGranted);
            logger.log(Level.FINE, "[Web-Security] hasResource perm: {0}", webResourcePermission);
        }
        this.recordWebInvocation(servletRequest, RESOURCE, isGranted);
        return isGranted;
    }

    public boolean hasRoleRefPermission(String servletName, String role, Principal principal) {
        WebRoleRefPermission requestedPermission = new WebRoleRefPermission(servletName, role);
        Set<Principal> principalSetFromSecurityContext = this.getSecurityContext(principal).getPrincipalSet();
        boolean isGranted = this.checkPermission((Permission)requestedPermission, principalSetFromSecurityContext);
        if (!isGranted) {
            isGranted = this.checkPermissionForModifiedPrincipalSet(principalSetFromSecurityContext, isGranted, requestedPermission);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasRoleRef perm: {0}", requestedPermission);
            logger.log(Level.FINE, "[Web-Security] hasRoleRef isGranted: {0}", isGranted);
        }
        return isGranted;
    }

    private boolean checkPermissionForModifiedPrincipalSet(Set<Principal> principalSetFromSecurityContext, boolean isGranted, WebRoleRefPermission requestedPermission) {
        boolean principalSetContainsCallerPrincipal = false;
        HashSet<Principal> modifiedPrincipalSet = new HashSet<Principal>(principalSetFromSecurityContext.size());
        for (Principal p : principalSetFromSecurityContext) {
            if (p instanceof CallerPrincipal) {
                principalSetContainsCallerPrincipal = true;
                modifiedPrincipalSet.add((Principal)new PrincipalImpl(p.getName()));
                continue;
            }
            modifiedPrincipalSet.add(p);
        }
        if (principalSetContainsCallerPrincipal) {
            isGranted = this.checkPermission((Permission)requestedPermission, modifiedPrincipalSet);
        }
        return isGranted;
    }

    public void release() throws PolicyContextException {
        logger.config(() -> "release(); id of the context: " + this.CONTEXT_ID);
        boolean wasInService = this.getPolicyFactory().inService(this.CONTEXT_ID);
        PolicyConfiguration config = this.getPolicyFactory().getPolicyConfiguration(this.CONTEXT_ID, false);
        this.removePolicyStatements(config, this.webBundleDescriptor);
        if (wasInService) {
            Policy.getPolicy().refresh();
        }
        PermissionCacheFactory.removePermissionCache(this.uncheckedPermissionCache);
        this.uncheckedPermissionCache = null;
        this.webSecurityManagerFactory.getManager(this.CONTEXT_ID, null, true);
    }

    public void destroy() throws PolicyContextException {
        logger.config(() -> "destroy(); id of the context: " + this.CONTEXT_ID);
        PolicyConfigurationFactory policyFactory = this.getPolicyFactory();
        boolean wasInService = policyFactory.inService(this.CONTEXT_ID);
        if (wasInService) {
            this.policy.refresh();
        }
        PermissionCacheFactory.removePermissionCache(this.uncheckedPermissionCache);
        this.uncheckedPermissionCache = null;
        SecurityRoleMapperFactoryGen.getSecurityRoleMapperFactory().removeAppNameForContext(this.CONTEXT_ID);
        if (policyFactory instanceof JaccConfigurationFactory) {
            ((JaccConfigurationFactory)policyFactory).removeContextProviderByPolicyContextId(this.CONTEXT_ID);
            ((JaccConfigurationFactory)policyFactory).removeContextIdMappingByPolicyContextId(this.CONTEXT_ID);
        }
        this.webSecurityManagerFactory.getManager(this.CONTEXT_ID, null, true);
    }

    private void initialise(String appName) throws PolicyContextException {
        LoginConfiguration loginConfiguration;
        logger.finest(() -> String.format("initialise(appName=%s)", appName));
        this.getPolicyFactory();
        this.CODEBASE = this.removeSpaces(this.CONTEXT_ID);
        if ("__asadmin".equals(this.getVirtualServers(appName)) && (loginConfiguration = this.webBundleDescriptor.getLoginConfiguration()) != null) {
            String realmName = loginConfiguration.getRealmName();
            SunWebApp sunDes = this.webBundleDescriptor.getSunDescriptor();
            if (sunDes != null) {
                SecurityRoleAssignment[] roleAssignments;
                SecurityRoleMapping[] roleMappings = sunDes.getSecurityRoleMapping();
                if (roleMappings != null) {
                    for (SecurityRoleMapping roleMapping : roleMappings) {
                        for (String principal : roleMapping.getPrincipalName()) {
                            this.webSecurityManagerFactory.addAdminPrincipal(principal, realmName, (Principal)new PrincipalImpl(principal));
                        }
                        for (String group : roleMapping.getGroupNames()) {
                            this.webSecurityManagerFactory.addAdminGroup(group, realmName, (Principal)new Group(group));
                        }
                    }
                }
                if ((roleAssignments = sunDes.getSecurityRoleAssignments()) != null) {
                    for (SecurityRoleAssignment roleAssignment : roleAssignments) {
                        if (roleAssignment.isExternallyDefined()) {
                            this.webSecurityManagerFactory.addAdminGroup(roleAssignment.getRoleName(), realmName, (Principal)new Group(roleAssignment.getRoleName()));
                            continue;
                        }
                        for (String principal : roleAssignment.getPrincipalNames()) {
                            this.webSecurityManagerFactory.addAdminPrincipal(principal, realmName, (Principal)new PrincipalImpl(principal));
                        }
                    }
                }
            }
        }
        try {
            try {
                logger.log(Level.FINE, "[Web-Security] Creating a Codebase URI with = {0}", this.CODEBASE);
                URI uri = new URI("file:///" + this.CODEBASE);
                if (uri != null) {
                    this.codesource = new CodeSource(new URL(uri.toString()), (Certificate[])null);
                }
            }
            catch (URISyntaxException use) {
                logger.log(Level.FINE, "[Web-Security] Error Creating URI ", use);
                throw new RuntimeException(use);
            }
        }
        catch (MalformedURLException mue) {
            logger.log(Level.SEVERE, "[Web-Security] Exception while getting the CodeSource", mue);
            throw new RuntimeException(mue);
        }
        logger.log(Level.FINE, "[Web-Security] Context id (id under which  WEB component in application will be created) = {0}", this.CONTEXT_ID);
        logger.log(Level.FINE, "[Web-Security] Codebase (module id for web component) {0}", this.CODEBASE);
        this.loadPermissionsInToPolicyConfiguration();
        if (this.uncheckedPermissionCache == null) {
            if (this.register) {
                this.uncheckedPermissionCache = PermissionCacheFactory.createPermissionCache(this.CONTEXT_ID, this.codesource, protoPerms, null);
                this.allResourcesCachedPermission = new CachedPermissionImpl(this.uncheckedPermissionCache, (Permission)allResources);
                this.allConnectionsCachedPermission = new CachedPermissionImpl(this.uncheckedPermissionCache, (Permission)allConnections);
            }
        } else {
            this.uncheckedPermissionCache.reset();
        }
    }

    private void loadPermissionsInToPolicyConfiguration() throws PolicyContextException {
        PolicyConfigurationFactory policyFactory = this.getPolicyFactory();
        if (!policyFactory.inService(this.CONTEXT_ID)) {
            this.policyConfiguration = policyFactory.getPolicyConfiguration(this.CONTEXT_ID, false);
            try {
                JaccWebConstraintsTranslator.translateConstraintsToPermissions(this.webBundleDescriptor, this.policyConfiguration);
            }
            catch (PolicyContextException pce) {
                logger.log(Level.FINE, "[Web-Security] FATAL Permission Translation: " + pce.getMessage());
                throw pce;
            }
        }
    }

    private String removeSpaces(String withSpaces) {
        return withSpaces.replace(' ', '_');
    }

    private String getAppId() {
        return this.webBundleDescriptor.getApplication().getRegistrationName();
    }

    private boolean checkPermission(Permission requestedPermission, Set<Principal> principalSet) {
        boolean hasPermission = false;
        if (this.uncheckedPermissionCache != null) {
            hasPermission = this.uncheckedPermissionCache.checkPermission(requestedPermission);
        }
        if (!hasPermission) {
            hasPermission = this.checkPermissionWithoutCache(requestedPermission, principalSet);
        } else {
            try {
                JaccWebAuthorizationManager.setPolicyContext(this.CONTEXT_ID);
            }
            catch (Throwable t) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "[Web-Security] Web Permission Access Denied.", t);
                }
                hasPermission = false;
            }
        }
        return hasPermission;
    }

    private boolean checkPermissionWithoutCache(Permission requestedPermission, Set<Principal> principals) {
        try {
            JaccWebAuthorizationManager.setPolicyContext(this.CONTEXT_ID);
        }
        catch (Throwable t) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[Web-Security] Web Permission Access Denied.", t);
            }
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] Codesource with Web URL: {0}", this.codesource.getLocation().toString());
            logger.log(Level.FINE, "[Web-Security] Checking Web Permission with Principals : {0}", this.principalSetToString(principals));
            logger.log(Level.FINE, "[Web-Security] Web Permission = {0}", requestedPermission.toString());
        }
        return this.policy.implies(this.getProtectionDomain(principals), requestedPermission);
    }

    private PolicyConfigurationFactory getPolicyFactory() throws PolicyContextException {
        if (this.policyConfigurationFactory != null) {
            return this.policyConfigurationFactory;
        }
        return this._getPolicyFactory();
    }

    private synchronized PolicyConfigurationFactory _getPolicyFactory() throws PolicyContextException {
        if (this.policyConfigurationFactory == null) {
            try {
                this.policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            }
            catch (ClassNotFoundException cnfe) {
                logger.severe("WebSecurityManager - Exception while getting the PolicyFactory");
                throw new PolicyContextException((Throwable)cnfe);
            }
            catch (PolicyContextException pce) {
                logger.severe("WebSecurityManager - Exception while getting the PolicyFactory");
                throw pce;
            }
        }
        return this.policyConfigurationFactory;
    }

    private ProtectionDomain getProtectionDomain(Set<Principal> principalSet) {
        return this.protectionDomainCache.computeIfAbsent(principalSet, e -> {
            Principal[] principals = principalSet == null ? null : principalSet.toArray(new Principal[0]);
            this.logProtectionDomainCreated(principals);
            return new ProtectionDomain(this.codesource, null, null, principals);
        });
    }

    private WebResourcePermission createWebResourcePermission(HttpServletRequest servletRequest) {
        String uri = (String)servletRequest.getAttribute(CONSTRAINT_URI);
        if (uri == null && (uri = servletRequest.getRequestURI()) != null) {
            int contextLength;
            String contextPath = servletRequest.getContextPath();
            int n = contextLength = contextPath == null ? 0 : contextPath.length();
            if (contextLength > 0) {
                uri = uri.substring(contextLength);
            }
        }
        if (uri == null) {
            logger.fine("[Web-Security] mappedUri is null");
            throw new RuntimeException("Fatal Error in creating WebResourcePermission");
        }
        uri = uri.equals("/") ? EMPTY_STRING : uri.replaceAll(":", "%3A");
        return new WebResourcePermission(uri, servletRequest.getMethod());
    }

    private static String setPolicyContext(String newContextID) throws Throwable {
        String oldContextID = PolicyContext.getContextID();
        if (!(oldContextID == newContextID || oldContextID != null && newContextID != null && oldContextID.equals(newContextID))) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[Web-Security] Setting Policy Context ID: old = {0} ctxID = {1}", new Object[]{oldContextID, newContextID});
            }
            try {
                AppservAccessController.privilegedException(() -> PolicyContext.setContextID((String)newContextID));
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof AccessControlException) {
                    logger.log(Level.SEVERE, "[Web-Security] setPolicy SecurityPermission required to call PolicyContext.setContextID", cause);
                } else {
                    logger.log(Level.SEVERE, "[Web-Security] Unexpected Exception while setting policy context", cause);
                }
                throw cause;
            }
        } else {
            logger.log(Level.FINE, "[Web-Security] Policy Context ID was: {0}", oldContextID);
        }
        return oldContextID;
    }

    private SecurityContext getSecurityContext(Principal principal) {
        SecurityContext securityContext = null;
        if (principal != null) {
            if (principal instanceof WebPrincipal) {
                WebPrincipal webPrincipal = (WebPrincipal)((Object)principal);
                securityContext = webPrincipal.getSecurityContext();
            } else {
                securityContext = SecurityContext.getCurrent();
            }
        }
        if (securityContext == null) {
            securityContext = SecurityContext.getDefaultSecurityContext();
        }
        return securityContext;
    }

    private void setServletRequestForJACC(HttpServletRequest httpRequest) {
        if (httpRequest != null) {
            this.webSecurityManagerFactory.pcHandlerImpl.getHandlerData().setHttpServletRequest(httpRequest);
        }
    }

    private void recordWebInvocation(HttpServletRequest servletRequest, String type, boolean isGranted) {
        AuditManager auditManager = SecurityServicesUtil.getInstance().getAuditManager();
        if (auditManager != null && auditManager.isAuditOn() && auditManager instanceof AppServerAuditManager) {
            AppServerAuditManager appServerAuditManager = (AppServerAuditManager)auditManager;
            Principal principal = servletRequest.getUserPrincipal();
            String user = principal != null ? principal.getName() : null;
            appServerAuditManager.webInvocation(user, servletRequest, type, isGranted);
        }
    }

    private void removePolicyStatements(PolicyConfiguration policyConfiguration, WebBundleDescriptor webBundleDescriptor) throws PolicyContextException {
        policyConfiguration.removeUncheckedPolicy();
        policyConfiguration.removeExcludedPolicy();
        for (Role role : webBundleDescriptor.getRoles()) {
            policyConfiguration.removeRole(role.getName());
        }
        policyConfiguration.removeRole("*");
        policyConfiguration.removeRole("*");
    }

    private String principalSetToString(Set<Principal> principalSet) {
        StringBuilder principalStringBuilder = null;
        if (principalSet != null) {
            Principal[] principals = principalSet.toArray(new Principal[0]);
            for (int i = 0; i < principals.length; ++i) {
                if (i == 0) {
                    principalStringBuilder = new StringBuilder(principals[i].toString());
                    continue;
                }
                principalStringBuilder.append(", ").append(principals[i].toString());
            }
        }
        return principalStringBuilder != null ? principalStringBuilder.toString() : null;
    }

    private String getVirtualServers(String applicationName) {
        Server server = this.serverContext.getDefaultServices().getService(Server.class, new Annotation[0]);
        for (ApplicationRef applicationRef : server.getApplicationRef()) {
            if (!applicationRef.getRef().equals(applicationName)) continue;
            return applicationRef.getVirtualServers();
        }
        return null;
    }

    private void logProtectionDomainCreated(Principal[] principals) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] Generating a protection domain for Permission check.");
            if (principals != null) {
                for (Principal principal : principals) {
                    logger.log(Level.FINE, "[Web-Security] Checking with Principal : {0}", principal.toString());
                }
            } else {
                logger.log(Level.FINE, "[Web-Security] Checking with Principals: null");
            }
        }
    }
}

