/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.rfm;

import com.sun.corba.ee.impl.oa.rfm.ReferenceFactoryImpl;
import com.sun.corba.ee.spi.logging.POASystemException;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.oa.rfm.ReferenceFactory;
import com.sun.corba.ee.spi.oa.rfm.ReferenceFactoryManager;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.trace.Poa;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.pfl.basic.contain.Pair;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;

@Poa
@ManagedObject
@Description(value="The ReferenceFactoryManager, used to handle dynamic cluster membership updates")
public class ReferenceFactoryManagerImpl
extends LocalObject
implements ReferenceFactoryManager {
    private static final POASystemException wrapper = POASystemException.self;
    private static final long serialVersionUID = -6689846523143143228L;
    private static final String PARENT_POA_NAME = "#RFMBase#";
    private ReferenceFactoryManager.RFMState state;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition suspendCondition = this.lock.newCondition();
    private final ORB orb;
    private final Map<String, Pair<ServantLocator, List<Policy>>> poatable;
    private final Map<String, ReferenceFactory> factories;
    private final Set<POAManager> managers;
    private final AdapterActivator activator;
    private volatile boolean isActive;
    private POA rootPOA;
    private List<Policy> standardPolicies;
    private POA parentPOA;
    private String[] parentPOAAdapterName;

    public ReferenceFactoryManagerImpl(ORB orb) {
        this.state = ReferenceFactoryManager.RFMState.READY;
        this.orb = orb;
        this.poatable = new HashMap<String, Pair<ServantLocator, List<Policy>>>();
        this.factories = new HashMap<String, ReferenceFactory>();
        this.managers = new HashSet<POAManager>();
        this.activator = new AdapterActivatorImpl();
        this.isActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceFactoryManager.RFMState getState() {
        this.lock.lock();
        try {
            ReferenceFactoryManager.RFMState rFMState = this.state;
            return rFMState;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Poa
    public void activate() {
        this.lock.lock();
        try {
            if (this.isActive) {
                throw wrapper.rfmAlreadyActive();
            }
            this.rootPOA = (POA)this.orb.resolve_initial_references("RootPOA");
            this.standardPolicies = Arrays.asList(ReferenceManagerPolicy.getPolicy(), this.rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), this.rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER), this.rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT));
            Policy[] policies = new Policy[]{ReferenceManagerPolicy.getPolicy()};
            this.parentPOA = this.rootPOA.create_POA(PARENT_POA_NAME, null, policies);
            this.parentPOAAdapterName = ((ObjectAdapter)ObjectAdapter.class.cast(this.parentPOA)).getIORTemplate().getObjectKeyTemplate().getObjectAdapterId().getAdapterName();
            POAManager pm = this.parentPOA.the_POAManager();
            this.parentPOA.the_activator(this.activator);
            pm.activate();
            this.isActive = true;
        }
        catch (Exception exc) {
            throw wrapper.rfmActivateFailed(exc);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Poa
    public ReferenceFactory create(String name, String repositoryId, List<Policy> policies, ServantLocator locator) {
        this.lock.lock();
        try {
            if (this.state == ReferenceFactoryManager.RFMState.SUSPENDED) {
                throw wrapper.rfmMightDeadlock();
            }
            if (!this.isActive) {
                throw wrapper.rfmNotActive();
            }
            ArrayList<Policy> newPolicies = null;
            if (policies != null) {
                newPolicies = new ArrayList<Policy>(policies);
            }
            Map<String, Pair<ServantLocator, List<Policy>>> map = this.poatable;
            synchronized (map) {
                this.poatable.put(name, (Pair<ServantLocator, List<Policy>>)new Pair((java.lang.Object)locator, newPolicies));
            }
            ReferenceFactoryImpl factory = new ReferenceFactoryImpl(this, name, repositoryId);
            this.factories.put(name, factory);
            ReferenceFactoryImpl referenceFactoryImpl = factory;
            return referenceFactoryImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Poa
    public ReferenceFactory find(String[] adapterName) {
        this.lock.lock();
        try {
            if (this.state == ReferenceFactoryManager.RFMState.SUSPENDED) {
                throw wrapper.rfmMightDeadlock();
            }
            if (!this.isActive) {
                ReferenceFactory referenceFactory = null;
                return referenceFactory;
            }
            int expectedLength = this.parentPOAAdapterName.length + 1;
            if (expectedLength != adapterName.length) {
                ReferenceFactory referenceFactory = null;
                return referenceFactory;
            }
            for (int ctr = 0; ctr < expectedLength - 1; ++ctr) {
                if (adapterName[ctr].equals(this.parentPOAAdapterName[ctr])) continue;
                ReferenceFactory referenceFactory = null;
                return referenceFactory;
            }
            ReferenceFactory referenceFactory = this.factories.get(adapterName[expectedLength - 1]);
            return referenceFactory;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceFactory find(String name) {
        this.lock.lock();
        try {
            if (this.state == ReferenceFactoryManager.RFMState.SUSPENDED) {
                throw wrapper.rfmMightDeadlock();
            }
            if (!this.isActive) {
                ReferenceFactory referenceFactory = null;
                return referenceFactory;
            }
            ReferenceFactory referenceFactory = this.factories.get(name);
            return referenceFactory;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Poa
    public void suspend() {
        this.lock.lock();
        HashSet<POAManager> pms = new HashSet<POAManager>(this.managers);
        try {
            if (!this.isActive) {
                throw wrapper.rfmNotActive();
            }
            while (this.state == ReferenceFactoryManager.RFMState.SUSPENDED) {
                try {
                    this.suspendCondition.await();
                }
                catch (InterruptedException exc) {
                    throw wrapper.rfmSuspendConditionWaitInterrupted();
                }
            }
            this.state = ReferenceFactoryManager.RFMState.SUSPENDED;
        }
        finally {
            this.lock.unlock();
        }
        try {
            for (POAManager pm : pms) {
                pm.hold_requests(true);
            }
        }
        catch (AdapterInactive ai) {
            throw wrapper.rfmManagerInactive((Exception)((java.lang.Object)ai));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Poa
    public void resume() {
        this.lock.lock();
        HashSet<POAManager> pms = new HashSet<POAManager>(this.managers);
        try {
            if (!this.isActive) {
                throw wrapper.rfmNotActive();
            }
            this.state = ReferenceFactoryManager.RFMState.READY;
            this.suspendCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        try {
            for (POAManager pm : pms) {
                pm.activate();
            }
        }
        catch (AdapterInactive ai) {
            throw wrapper.rfmManagerInactive((Exception)((java.lang.Object)ai));
        }
        this.lock.lock();
        try {
            this.managers.removeAll(pms);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Poa
    public void restartFactories(Map<String, Pair<ServantLocator, List<Policy>>> updates) {
        this.lock.lock();
        try {
            if (!this.isActive) {
                throw wrapper.rfmNotActive();
            }
            if (this.state != ReferenceFactoryManager.RFMState.SUSPENDED) {
                throw wrapper.rfmMethodRequiresSuspendedState("restartFactories");
            }
        }
        finally {
            this.lock.unlock();
        }
        if (updates == null) {
            throw wrapper.rfmNullArgRestart();
        }
        Map<String, Pair<ServantLocator, List<Policy>>> map = this.poatable;
        synchronized (map) {
            this.poatable.putAll(updates);
        }
        try {
            for (POA poa : this.parentPOA.the_children()) {
                poa.destroy(false, true);
            }
        }
        catch (Exception exc) {
            throw wrapper.rfmRestartFailed(exc);
        }
    }

    @Override
    public void restartFactories() {
        this.restartFactories(new HashMap<String, Pair<ServantLocator, List<Policy>>>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Poa
    public void restart(Map<String, Pair<ServantLocator, List<Policy>>> updates) {
        this.suspend();
        try {
            this.restartFactories(updates);
        }
        finally {
            this.resume();
        }
    }

    @Override
    public void restart() {
        this.restart(new HashMap<String, Pair<ServantLocator, List<Policy>>>());
    }

    @Poa
    Object createReference(String name, byte[] key, String repositoryId) {
        try {
            POA child = this.parentPOA.find_POA(name, true);
            return child.create_reference_with_id(key, repositoryId);
        }
        catch (Exception exc) {
            throw wrapper.rfmCreateReferenceFailed(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Poa
    void destroy(String name) {
        try {
            POA child = this.parentPOA.find_POA(name, true);
            Map<String, Pair<ServantLocator, List<Policy>>> map = this.poatable;
            synchronized (map) {
                this.poatable.remove(name);
            }
            this.lock.lock();
            try {
                this.factories.remove(name);
                POAManager pm = child.the_POAManager();
                this.managers.remove(pm);
            }
            finally {
                this.lock.unlock();
            }
            child.destroy(false, true);
        }
        catch (Exception exc) {
            throw wrapper.rfmDestroyFailed(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validatePOACreation(POA poa) {
        if (!this.isActive) {
            return;
        }
        Policy policy = ((ObjectAdapter)ObjectAdapter.class.cast(poa)).getEffectivePolicy(1398079492);
        if (policy != null) {
            return;
        }
        POA parent = poa.the_parent();
        Policy parentPolicy = ((ObjectAdapter)ObjectAdapter.class.cast(parent)).getEffectivePolicy(1398079492);
        if (parentPolicy != null) {
            throw wrapper.rfmIllegalParentPoaUsage();
        }
        this.lock.lock();
        try {
            if (this.managers.contains(poa.the_POAManager())) {
                throw wrapper.rfmIllegalPoaManagerUsage();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Poa
    public boolean isRfmName(String[] adapterName) {
        if (!this.isActive) {
            return false;
        }
        int expectedLength = this.parentPOAAdapterName.length + 1;
        if (expectedLength != adapterName.length) {
            return false;
        }
        for (int ctr = 0; ctr < expectedLength - 1; ++ctr) {
            if (adapterName[ctr].equals(this.parentPOAAdapterName[ctr])) continue;
            return false;
        }
        return true;
    }

    private static class ReferenceManagerPolicy
    extends LocalObject
    implements Policy {
        private static Policy thisPolicy = new ReferenceManagerPolicy();
        private static final long serialVersionUID = -4780983694679451387L;

        public static Policy getPolicy() {
            return thisPolicy;
        }

        private ReferenceManagerPolicy() {
        }

        public int policy_type() {
            return 1398079492;
        }

        public Policy copy() {
            return this;
        }

        public void destroy() {
        }
    }

    @Poa
    private class AdapterActivatorImpl
    extends LocalObject
    implements AdapterActivator {
        private static final long serialVersionUID = 7922226881290146012L;

        private AdapterActivatorImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Poa
        public boolean unknown_adapter(POA parent, String name) {
            Pair data = null;
            Map map = ReferenceFactoryManagerImpl.this.poatable;
            synchronized (map) {
                data = (Pair)ReferenceFactoryManagerImpl.this.poatable.get(name);
            }
            if (data == null) {
                return false;
            }
            try {
                ArrayList policies = new ArrayList();
                if (data.second() != null) {
                    policies.addAll((Collection)data.second());
                }
                policies.addAll(ReferenceFactoryManagerImpl.this.standardPolicies);
                Policy[] arr = policies.toArray(new Policy[policies.size()]);
                POA child = ReferenceFactoryManagerImpl.this.parentPOA.create_POA(name, null, arr);
                POAManager pm = child.the_POAManager();
                ReferenceFactoryManagerImpl.this.lock.lock();
                try {
                    ReferenceFactoryManagerImpl.this.managers.add(pm);
                }
                finally {
                    ReferenceFactoryManagerImpl.this.lock.unlock();
                }
                child.set_servant_manager((ServantManager)data.first());
                pm.activate();
                return true;
            }
            catch (Exception exc) {
                wrapper.rfmAdapterActivatorFailed(exc);
                return false;
            }
        }
    }
}

