/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.remote.RemoteRestAdminCommand;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.v3.admin.adapter.AdminEndpointDecider;
import com.sun.enterprise.v3.admin.cluster.CommandRunnable;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ProgressStatus;

public class ClusterCommandHelper {
    private static final String NL = System.getProperty("line.separator");
    private static final int ADMIN_DEFAULT_POOL_SIZE = 5;
    private final Domain domain;
    private final CommandRunner runner;
    private ProgressStatus progress;
    private long adminTimeout;

    public ClusterCommandHelper(Domain domain, CommandRunner runner) {
        this.domain = domain;
        this.runner = runner;
        this.adminTimeout = RemoteRestAdminCommand.getReadTimeout();
    }

    public ActionReport runCommand(String command, ParameterMap map, String targetName, AdminCommandContext context, boolean verbose) throws CommandException {
        return this.runCommand(command, map, targetName, context, verbose, false);
    }

    public ActionReport runCommand(String command, ParameterMap map, String targetName, AdminCommandContext context, boolean verbose, boolean rolling) throws CommandException {
        String msg;
        long startTime = System.currentTimeMillis();
        Logger logger = context.getLogger();
        ActionReport report = context.getActionReport();
        Cluster cluster = this.domain.getClusterNamed(targetName);
        if (cluster == null && this.domain.getDeploymentGroupNamed(targetName) == null) {
            throw new CommandException(Strings.get("cluster.command.unknownCluster", targetName));
        }
        List<Server> targetServers = this.domain.getServersInTarget(targetName);
        if (targetServers == null || targetServers.isEmpty()) {
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(Strings.get("cluster.command.noInstances", targetName));
            return report;
        }
        int nInstances = targetServers.size();
        StringBuilder failedServerNames = new StringBuilder();
        StringBuilder succeededServerNames = new StringBuilder();
        ArrayList<String> waitingForServerNames = new ArrayList<String>();
        ReportResult reportResult = new ReportResult();
        boolean failureOccurred = false;
        this.progress = context.getProgressStatus();
        StringBuilder output = new StringBuilder();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Original instance list %s", ClusterCommandHelper.serverListToString(targetServers)));
        }
        targetServers = this.optimizeServerListOrder(targetServers);
        ArrayBlockingQueue<CommandRunnable> responseQueue = new ArrayBlockingQueue<CommandRunnable>(nInstances);
        int threadPoolSize = 1;
        if (!rolling && (threadPoolSize = Math.min(nInstances, this.getAdminThreadPoolSize() / 2)) < 1) {
            threadPoolSize = 1;
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(threadPoolSize);
        if (map == null) {
            map = new ParameterMap();
        }
        logger.info(String.format("Executing %s on %d instances using a thread pool of size %d: %s", command, nInstances, threadPoolSize, ClusterCommandHelper.serverListToString(targetServers)));
        this.progress.setTotalStepCount(nInstances);
        this.progress.progress(Strings.get("cluster.command.executing", command, Integer.toString(nInstances)));
        for (Server server : targetServers) {
            String serverName = server.getName();
            waitingForServerNames.add(serverName);
            ParameterMap instanceParameterMap = new ParameterMap(map);
            instanceParameterMap.set((Object)"DEFAULT", (Object)serverName);
            ActionReport instanceReport = this.runner.getActionReport("plain");
            instanceReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            CommandRunner.CommandInvocation invocation = this.runner.getCommandInvocation(command, instanceReport, context.getSubject());
            invocation.parameters(instanceParameterMap);
            msg = command + " " + serverName;
            logger.info(msg);
            if (verbose) {
                output.append(msg).append(NL);
            }
            CommandRunnable cmdRunnable = new CommandRunnable(invocation, instanceReport, responseQueue);
            cmdRunnable.setName(serverName);
            threadPool.execute(cmdRunnable);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("%s commands queued, waiting for responses", command));
        }
        this.adminTimeout -= 3000L;
        if (this.adminTimeout <= 0L) {
            this.adminTimeout = 57000L;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Initial cluster command timeout: %d ms", this.adminTimeout));
        }
        for (int n = 0; n < nInstances; ++n) {
            long timeLeft = this.adminTimeout - (System.currentTimeMillis() - startTime);
            if (timeLeft < 0L) {
                timeLeft = 0L;
            }
            CommandRunnable cmdRunnable = null;
            try {
                cmdRunnable = (CommandRunnable)responseQueue.poll(timeLeft, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                threadPool.shutdownNow();
                String msg2 = Strings.get("cluster.command.interrupted", targetName, Integer.toString(n), Integer.toString(nInstances), command);
                logger.warning(msg2);
                output.append(msg2).append(NL);
                failureOccurred = true;
                Thread.currentThread().interrupt();
                break;
            }
            if (cmdRunnable == null) break;
            String iname = cmdRunnable.getName();
            waitingForServerNames.remove(iname);
            ActionReport instanceReport = cmdRunnable.getActionReport();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("Instance %d of %d (%s) has responded with %s", n + 1, nInstances, iname, instanceReport.getActionExitCode()));
            }
            if (instanceReport.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                failureOccurred = true;
                failedServerNames.append(iname).append(" ");
                reportResult.failedServerNames.add(iname);
                msg = iname + ": " + instanceReport.getMessage();
                logger.severe(msg);
                output.append(msg).append(NL);
                msg = Strings.get("cluster.command.instancesFailed", command, iname);
                this.progress.progress(1, msg);
                continue;
            }
            succeededServerNames.append(iname).append(" ");
            reportResult.succeededServerNames.add(iname);
            this.progress.progress(1, iname);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (failureOccurred) {
            report.setResultType(List.class, reportResult.failedServerNames);
        } else {
            report.setResultType(List.class, reportResult.succeededServerNames);
        }
        if (succeededServerNames.length() > 0 && (verbose || failureOccurred)) {
            output.append(NL).append(Strings.get("cluster.command.instancesSucceeded", command, succeededServerNames));
        }
        if (failureOccurred) {
            output.append(NL).append(Strings.get("cluster.command.instancesFailed", command, failedServerNames));
            if (succeededServerNames.length() > 0) {
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        }
        if (!waitingForServerNames.isEmpty()) {
            String msg3 = Strings.get("cluster.command.instancesTimedOut", command, ClusterCommandHelper.listToString(waitingForServerNames));
            logger.warning(msg3);
            if (output.length() > 0) {
                output.append(NL);
            }
            output.append(msg3);
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        }
        report.setMessage(output.toString());
        threadPool.shutdown();
        return report;
    }

    private int getAdminThreadPoolSize() {
        Config config = this.domain.getConfigNamed("server-config");
        if (config == null) {
            return 5;
        }
        return new AdminEndpointDecider(config).getMaxThreadPoolSize();
    }

    public List<Server> optimizeServerListOrder(List<Server> original) {
        if (original.size() < 3) {
            return original;
        }
        HashMap<String, ArrayList<Server>> serverTable = new HashMap<String, ArrayList<Server>>();
        int count = 0;
        for (Server server : original) {
            String nodeName = server.getNodeRef();
            ArrayList<Server> serverList = (ArrayList<Server>)serverTable.get(nodeName);
            if (serverList == null) {
                serverList = new ArrayList<Server>();
                serverTable.put(nodeName, serverList);
            }
            serverList.add(server);
            ++count;
        }
        ArrayList<Server> optimized = new ArrayList<Server>(count);
        Set nodes = serverTable.keySet();
        while (count > 0) {
            for (String nodeName : nodes) {
                List serverList = (List)serverTable.get(nodeName);
                if (serverList.isEmpty()) continue;
                optimized.add((Server)serverList.remove(0));
                --count;
            }
        }
        return optimized;
    }

    private static String serverListToString(List<Server> servers) {
        StringBuilder serverListBuilder = new StringBuilder();
        for (Server server : servers) {
            serverListBuilder.append(server.getNodeRef()).append(":").append(server.getName()).append(" ");
        }
        return serverListBuilder.toString().trim();
    }

    private static String listToString(List<String> slist) {
        StringBuilder sb = new StringBuilder();
        for (String s : slist) {
            sb.append(s).append(" ");
        }
        return sb.toString().trim();
    }

    public void setAdminTimeout(long adminTimeout) {
        this.adminTimeout = adminTimeout;
    }

    public static class ReportResult {
        public final List<String> succeededServerNames = new ArrayList<String>();
        public final List<String> failedServerNames = new ArrayList<String>();
    }
}

