/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.cluster.NodeInfo;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class ListNodesHelper {
    private Servers servers;
    private static final String EOL = "\n";
    String listType;
    boolean long_opt;
    boolean terse;
    List<Node> nodeList;
    List<NodeInfo> infos = new LinkedList<NodeInfo>();

    public ListNodesHelper(Logger _logger, Servers servers, Nodes nodes, String type, boolean long_opt, boolean terse) {
        this.listType = type;
        this.long_opt = long_opt;
        this.terse = terse;
        this.servers = servers;
        this.nodeList = nodes.getNode();
        this.infos = new LinkedList<NodeInfo>();
    }

    public String getNodeList() {
        StringBuilder sb = new StringBuilder();
        boolean firstNode = true;
        for (Node n : this.nodeList) {
            String nodeType = n.getType();
            if (!this.listType.equals(nodeType) && !this.listType.equals("ALL") || nodeType.equals("TEMP")) continue;
            String name = n.getName();
            String host = n.getNodeHost();
            String installDir = n.getInstallDir();
            if (firstNode) {
                firstNode = false;
            } else {
                sb.append(EOL);
            }
            if (this.terse) {
                sb.append(name);
            } else if (!this.long_opt) {
                sb.append(name).append("  ").append(nodeType).append("  ").append(host);
            }
            if (!this.long_opt) continue;
            List serversOnNode = this.servers.getServersOnNode(n);
            StringBuilder instanceList = new StringBuilder();
            if (!serversOnNode.isEmpty()) {
                int i = 0;
                for (Server server : serversOnNode) {
                    if (i > 0) {
                        instanceList.append(", ");
                    }
                    instanceList.append(server.getName());
                    ++i;
                }
            }
            NodeInfo ni = new NodeInfo(name, host, installDir, nodeType, instanceList.toString());
            this.infos.add(ni);
        }
        if (this.long_opt) {
            return NodeInfo.format(this.infos);
        }
        return sb.toString();
    }

    public List<String> getNodeNamesList() {
        ArrayList<String> nodeNamesList = new ArrayList<String>();
        for (Node n : this.nodeList) {
            String name = n.getName();
            String nodeType = n.getType();
            if (!this.listType.equals(nodeType) && !this.listType.equals("ALL")) continue;
            nodeNamesList.add(name);
        }
        return nodeNamesList;
    }
}

