/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.cdi;

import fish.payara.microprofile.config.cdi.model.ConfigPropertyModel;
import fish.payara.nucleus.microprofile.config.spi.ConfigValueResolver;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigPropertyProducer {
    @ConfigProperty
    @Dependent
    public static final Object getGenericProperty(InjectionPoint ip) {
        ConfigPropertyModel property = new ConfigPropertyModel(ip);
        return ConfigPropertyProducer.getGenericPropertyFromModel(property);
    }

    public static final Object getGenericPropertyFromModel(ConfigPropertyModel property) {
        Object result = null;
        Config config = ConfigProvider.getConfig();
        String name = property.getName();
        Type type = property.getInjectionPoint().getType();
        String defaultValue = property.getDefaultValue();
        if (type instanceof Class) {
            result = type == OptionalDouble.class ? config.getValue(property.getName(), ConfigValueResolver.class).throwOnFailedConversion().withDefault(property.getDefaultValue()).as(OptionalDouble.class).orElse(OptionalDouble.empty()) : (type == OptionalInt.class ? config.getValue(property.getName(), ConfigValueResolver.class).throwOnFailedConversion().withDefault(property.getDefaultValue()).as(OptionalInt.class).orElse(OptionalInt.empty()) : (type == OptionalLong.class ? config.getValue(property.getName(), ConfigValueResolver.class).throwOnFailedConversion().withDefault(property.getDefaultValue()).as(OptionalLong.class).orElse(OptionalLong.empty()) : config.getValue(name, ConfigValueResolver.class).throwOnMissingProperty(defaultValue == null).throwOnFailedConversion().withDefault(defaultValue).withPolicy(ConfigValueResolver.ElementPolicy.FAIL).as((Class)type).get()));
        } else if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Type rawType = ptype.getRawType();
            result = List.class.equals((Object)rawType) ? config.getValue(name, ConfigValueResolver.class).throwOnMissingProperty(defaultValue == null).throwOnFailedConversion().withDefault(defaultValue).withPolicy(ConfigValueResolver.ElementPolicy.FAIL).asList(ConfigPropertyProducer.getElementTypeFrom(ptype)) : (Set.class.equals((Object)rawType) ? config.getValue(name, ConfigValueResolver.class).throwOnMissingProperty(defaultValue == null).throwOnFailedConversion().withDefault(defaultValue).withPolicy(ConfigValueResolver.ElementPolicy.FAIL).asSet(ConfigPropertyProducer.getElementTypeFrom(ptype)) : (Supplier.class.equals((Object)rawType) ? config.getValue(name, ConfigValueResolver.class).throwOnMissingProperty(defaultValue == null).throwOnFailedConversion().withDefault(defaultValue).withPolicy(ConfigValueResolver.ElementPolicy.FAIL).asSupplier(ConfigPropertyProducer.getElementTypeFrom(ptype)) : (Optional.class.equals((Object)rawType) ? config.getValue(name, ConfigValueResolver.class).throwOnMissingProperty(false).throwOnFailedConversion().withDefault(defaultValue).withPolicy(ConfigValueResolver.ElementPolicy.FAIL).as(ConfigPropertyProducer.getElementTypeFrom(ptype)) : config.getValue(name, (Class)rawType))));
        }
        if (result == null) {
            throw new DeploymentException("Microprofile Config Property " + property.getName() + " can not be found");
        }
        return result;
    }

    private static Class<?> getElementTypeFrom(ParameterizedType collectionType) {
        Type elementType = collectionType.getActualTypeArguments()[0];
        if (!(elementType instanceof Class)) {
            throw new DeploymentException("Only config values of lists and sets of non generic types (Class types) are supported but found: " + collectionType);
        }
        return (Class)elementType;
    }
}

