/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.impl;

import fish.payara.microprofile.metrics.impl.Clock;
import fish.payara.microprofile.metrics.impl.ExponentiallyWeightedMovingAverage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.metrics.Meter;

@Vetoed
public class MeterImpl
implements Meter {
    private static final double NANOS_IN_A_SEC = TimeUnit.SECONDS.toNanos(1L);
    private static final long TICK_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private final ExponentiallyWeightedMovingAverage m1Rate = ExponentiallyWeightedMovingAverage.oneMinuteEWMA();
    private final ExponentiallyWeightedMovingAverage m5Rate = ExponentiallyWeightedMovingAverage.fiveMinuteEWMA();
    private final ExponentiallyWeightedMovingAverage m15Rate = ExponentiallyWeightedMovingAverage.fifteenMinuteEWMA();
    private final AtomicLong count = new AtomicLong();
    private final long startTime;
    private final AtomicLong lastTick;
    private final Clock clock;

    public MeterImpl() {
        this(Clock.defaultClock());
    }

    public MeterImpl(Clock clock) {
        this.clock = clock;
        this.startTime = this.clock.getTick();
        this.lastTick = new AtomicLong(this.startTime);
    }

    @Override
    public void mark() {
        this.mark(1L);
    }

    @Override
    public void mark(long n) {
        this.tickIfNecessary();
        this.count.addAndGet(n);
        this.m1Rate.update(n);
        this.m5Rate.update(n);
        this.m15Rate.update(n);
    }

    private void tickIfNecessary() {
        long newIntervalStartTick;
        long oldTick = this.lastTick.get();
        long newTick = this.clock.getTick();
        long age = newTick - oldTick;
        if (age > TICK_INTERVAL && this.lastTick.compareAndSet(oldTick, newIntervalStartTick = newTick - age % TICK_INTERVAL)) {
            long requiredTicks = age / TICK_INTERVAL;
            for (long i = 0L; i < requiredTicks; ++i) {
                this.m1Rate.tick();
                this.m5Rate.tick();
                this.m15Rate.tick();
            }
        }
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    @Override
    public double getFifteenMinuteRate() {
        this.tickIfNecessary();
        return this.m15Rate.getRate(TimeUnit.SECONDS);
    }

    @Override
    public double getFiveMinuteRate() {
        this.tickIfNecessary();
        return this.m5Rate.getRate(TimeUnit.SECONDS);
    }

    @Override
    public double getMeanRate() {
        if (this.getCount() == 0L) {
            return 0.0;
        }
        long nanosPast = this.clock.getTick() - this.startTime;
        double secondsPast = (double)nanosPast / NANOS_IN_A_SEC;
        return (double)this.getCount() / secondsPast;
    }

    @Override
    public double getOneMinuteRate() {
        this.tickIfNecessary();
        return this.m1Rate.getRate(TimeUnit.SECONDS);
    }

    public String toString() {
        return "Meter[" + this.getCount() + "]";
    }
}

