/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.impl;

import fish.payara.microprofile.metrics.impl.Clock;
import fish.payara.microprofile.metrics.impl.CompleteMinuteMinMaxTracker;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.metrics.SimpleTimer;

@Vetoed
public class SimpleTimerImpl
extends CompleteMinuteMinMaxTracker
implements SimpleTimer {
    private final AtomicLong callCount = new AtomicLong();
    private final AtomicLong totalDurationNanos = new AtomicLong();

    public SimpleTimerImpl(Clock clock) {
        super(clock);
    }

    @Override
    public void update(Duration duration) {
        long nanos = duration.toNanos();
        this.totalDurationNanos.addAndGet(nanos);
        this.callCount.incrementAndGet();
        this.updateValue(nanos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(Duration.ofNanos(this.clock.getTick() - startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void time(Runnable event) {
        long startTime = this.clock.getTick();
        try {
            event.run();
        }
        finally {
            this.update(Duration.ofNanos(this.clock.getTick() - startTime));
        }
    }

    @Override
    public SimpleTimer.Context time() {
        return new Context(this, this.clock);
    }

    @Override
    public Duration getElapsedTime() {
        return Duration.ofNanos(this.totalDurationNanos.get());
    }

    @Override
    public long getCount() {
        return this.callCount.get();
    }

    @Override
    public Duration getMaxTimeDuration() {
        Long nanos = this.getMaxValue();
        return nanos == null ? null : Duration.ofNanos(nanos);
    }

    @Override
    public Duration getMinTimeDuration() {
        Long nanos = this.getMinValue();
        return nanos == null ? null : Duration.ofNanos(nanos);
    }

    public String toString() {
        return "SimpleTimer[" + this.getCount() + "]";
    }

    private static final class Context
    implements SimpleTimer.Context {
        private final SimpleTimer timer;
        private final Clock clock;
        private final long startTime;

        Context(SimpleTimer timer, Clock clock) {
            this.timer = timer;
            this.clock = clock;
            this.startTime = clock.getTick();
        }

        @Override
        public long stop() {
            long elapsed = this.clock.getTick() - this.startTime;
            this.timer.update(Duration.ofNanos(elapsed));
            return elapsed;
        }

        @Override
        public void close() {
            this.stop();
        }
    }
}

