/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.rest;

import fish.payara.microprofile.metrics.admin.MetricsServiceConfiguration;
import fish.payara.microprofile.metrics.rest.MetricsResource;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.servlet.HttpConstraintElement;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.glassfish.common.util.StringHelper;
import org.glassfish.internal.api.Globals;

public class MetricsServletContainerInitializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> set, ServletContext ctx) throws ServletException {
        ServletRegistration reg2;
        MetricsServiceConfiguration configuration = (MetricsServiceConfiguration)Globals.getDefaultBaseServiceLocator().getService(MetricsServiceConfiguration.class, new Annotation[0]);
        if (!"".equals(ctx.getContextPath())) {
            return;
        }
        Map registrations = ctx.getServletRegistrations();
        for (ServletRegistration reg2 : registrations.values()) {
            if (!reg2.getClass().equals(MetricsResource.class)) continue;
            return;
        }
        String virtualServers = configuration.getVirtualServers();
        if (!StringHelper.isEmpty((String)virtualServers) && !Arrays.asList(virtualServers.split(",")).contains(ctx.getVirtualServerName())) {
            return;
        }
        reg2 = ctx.addServlet("microprofile-metrics-resource", MetricsResource.class);
        reg2.addMapping(new String[]{"/" + configuration.getEndpoint() + "/*"});
        if (Boolean.parseBoolean(configuration.getSecurityEnabled())) {
            String[] roles = configuration.getRoles().split(",");
            reg2.setServletSecurity(new ServletSecurityElement(new HttpConstraintElement(ServletSecurity.TransportGuarantee.CONFIDENTIAL, roles)));
            ctx.declareRoles(roles);
            if (Boolean.getBoolean("fish.payara.test.create-insecure-endpoint")) {
                ServletRegistration.Dynamic insecureReg = ctx.addServlet("microprofile-metrics-resource-insecure", MetricsResource.class);
                insecureReg.addMapping(new String[]{"/" + configuration.getEndpoint() + "-insecure/*"});
            }
        }
    }
}

