/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.timer.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.map.IMap;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBTimerSchedule;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.NonPersistentEJBTimerService;
import com.sun.ejb.containers.RuntimeTimerState;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import fish.payara.appserver.micro.services.PayaraInstanceImpl;
import fish.payara.ejb.timer.hazelcast.EjbTimerEvent;
import fish.payara.ejb.timer.hazelcast.HZTimer;
import fish.payara.micro.data.InstanceDescriptor;
import fish.payara.nucleus.cluster.ClusterListener;
import fish.payara.nucleus.cluster.MemberEvent;
import fish.payara.nucleus.cluster.PayaraCluster;
import fish.payara.nucleus.eventbus.ClusterMessage;
import fish.payara.nucleus.eventbus.MessageReceiver;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.TimerConfig;
import javax.transaction.TransactionManager;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.ScheduledTimerDescriptor;
import org.glassfish.internal.api.Globals;

public class HazelcastTimerStore
extends NonPersistentEJBTimerService
implements ClusterListener,
MessageReceiver<EjbTimerEvent> {
    private static final String EJB_TIMER_CACHE_NAME = "HZEjbTmerCache";
    private static final String EJB_TIMER_CONTAINER_CACHE_NAME = "HZEjbTmerContainerCache";
    private static final String EJB_TIMER_APPLICAION_CACHE_NAME = "HZEjbTmerApplicationCache";
    private final IMap<String, HZTimer> pkCache;
    private final IMap<Long, Set<TimerPrimaryKey>> containerCache;
    private final IMap<Long, Set<TimerPrimaryKey>> applicationCache;
    private final String serverName;
    private final HazelcastInstance hazelcast;
    private static final Logger logger = LogDomains.getLogger(HazelcastTimerStore.class, (String)"javax.enterprise.system.container.ejb");

    static void init(HazelcastCore core) {
        try {
            HazelcastTimerStore store = new HazelcastTimerStore(core);
            ((PayaraCluster)Globals.getDefaultBaseServiceLocator().getService(PayaraCluster.class, new Annotation[0])).addClusterListener(store);
            EJBTimerService.setPersistentTimerService((EJBTimerService)store);
            ((PayaraCluster)Globals.getDefaultBaseServiceLocator().getService(PayaraCluster.class, new Annotation[0])).getEventBus().addMessageReceiver("payara.server.internal.ejb.timer.event", store);
        }
        catch (Exception ex) {
            Logger.getLogger(HazelcastTimerStore.class.getName()).log(Level.WARNING, "Problem when initialising Timer Store", ex);
        }
    }

    public HazelcastTimerStore(HazelcastCore core) throws Exception {
        if (!core.isEnabled()) {
            throw new Exception("Hazelcast MUST be enabled when using the HazelcastTimerStore");
        }
        this.hazelcast = core.getInstance();
        this.pkCache = this.hazelcast.getMap(EJB_TIMER_CACHE_NAME);
        this.containerCache = this.hazelcast.getMap(EJB_TIMER_CONTAINER_CACHE_NAME);
        this.applicationCache = this.hazelcast.getMap(EJB_TIMER_APPLICAION_CACHE_NAME);
        this.ownerIdOfThisServer_ = this.serverName = core.getAttribute(core.getInstance().getCluster().getLocalMember().getUuid(), "GLASSFISH-INSTANCE");
        this.domainName_ = core.getInstance().getConfig().getClusterName();
    }

    private void removeTimers(Set<TimerPrimaryKey> timerIdsToRemove) {
        for (TimerPrimaryKey timerPrimaryKey : timerIdsToRemove) {
            this.removeTimer((HZTimer)this.pkCache.get((Object)timerPrimaryKey.timerId));
        }
    }

    protected void _createTimer(TimerPrimaryKey timerId, long containerId, long applicationId, Object timedObjectPrimaryKey, String server_name, Date initialExpiration, long intervalDuration, EJBTimerSchedule schedule, TimerConfig timerConfig) throws Exception {
        if (timerConfig.isPersistent()) {
            boolean localTx;
            this.pkCache.put((Object)timerId.timerId, (Object)new HZTimer(timerId, containerId, applicationId, timedObjectPrimaryKey, server_name, server_name, initialExpiration, intervalDuration, schedule, timerConfig));
            HashSet<TimerPrimaryKey> keysForContainer = (HashSet<TimerPrimaryKey>)this.containerCache.get((Object)containerId);
            if (keysForContainer == null) {
                keysForContainer = new HashSet<TimerPrimaryKey>();
            }
            keysForContainer.add(timerId);
            this.containerCache.put((Object)containerId, keysForContainer);
            HashSet<TimerPrimaryKey> keysForApp = (HashSet<TimerPrimaryKey>)this.applicationCache.get((Object)applicationId);
            if (keysForApp == null) {
                keysForApp = new HashSet<TimerPrimaryKey>();
            }
            keysForApp.add(timerId);
            this.applicationCache.put((Object)applicationId, keysForApp);
            JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
            boolean bl = localTx = tm.getTransaction() == null;
            if (localTx) {
                tm.begin();
            }
            this.addTimerSynchronization(null, timerId.getTimerId(), initialExpiration, containerId, this.ownerIdOfThisServer_, true);
            if (localTx) {
                tm.commit();
            }
        } else {
            this.addTimerSynchronization(null, timerId.getTimerId(), initialExpiration, containerId, this.ownerIdOfThisServer_, false);
        }
    }

    public void destroyAllTimers(long applicationId) {
        Set timerIds = (Set)this.applicationCache.get((Object)applicationId);
        if (timerIds == null || timerIds.isEmpty()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "No timers to be deleted for id: {0}", applicationId);
            }
            return;
        }
        for (TimerPrimaryKey timerId : timerIds) {
            this.pkCache.remove((Object)timerId.timerId);
        }
        logger.log(Level.INFO, "Destroyed {0} timers for application {1}", new Object[]{timerIds.size(), applicationId});
        timerIds.clear();
        this.applicationCache.remove((Object)applicationId);
    }

    public void destroyTimers(long containerId) {
        Set timerIds = (Set)this.containerCache.get((Object)containerId);
        if (timerIds == null || timerIds.isEmpty()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "No timers to be deleted for id: {0}", containerId);
            }
            return;
        }
        logger.log(Level.INFO, "Destroyed {0} timers for container {1}", new Object[]{timerIds.size(), containerId});
        timerIds.clear();
        this.applicationCache.put((Object)containerId, (Object)timerIds);
    }

    protected void cancelTimer(TimerPrimaryKey timerId) throws FinderException, Exception {
        HZTimer timer;
        if (!this.cancelNonPersistentTimer(timerId) && (timer = (HZTimer)this.pkCache.get((Object)timerId.timerId)) != null) {
            boolean localTx;
            JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
            boolean bl = localTx = tm.getTransaction() == null;
            if (localTx) {
                tm.begin();
            }
            super.cancelTimerSynchronization(null, timerId, timer.getContainerId(), timer.getOwnerId());
            if (localTx) {
                tm.commit();
            }
        }
    }

    protected Serializable getInfo(TimerPrimaryKey timerId) throws FinderException {
        if (this.isNonpersistent(timerId)) {
            return super.getInfo(timerId);
        }
        HZTimer timer = (HZTimer)this.pkCache.get((Object)timerId.timerId);
        if (timer == null) {
            throw new FinderException("Unable to find timer " + timerId);
        }
        return timer.getTimerConfig().getInfo();
    }

    protected Date getNextTimeout(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        if (rt != null) {
            return this._getNextTimeout(rt);
        }
        HZTimer timer = this.getPersistentTimer(timerId);
        Date initialExpiration = timer.getInitialExpiration();
        long intervalDuration = timer.getIntervalDuration();
        EJBTimerSchedule ts = timer.getSchedule();
        Date nextTimeout = null;
        nextTimeout = ts != null ? this.getNextScheduledTimeout(ts) : (intervalDuration > 0L ? this.calcNextFixedRateExpiration(initialExpiration, intervalDuration) : initialExpiration);
        return nextTimeout;
    }

    protected void cancelTimersByKey(long containerId, Object primaryKey) {
        Set timers = (Set)this.containerCache.get((Object)containerId);
        if (timers != null) {
            HashSet<HZTimer> timersToCancel = new HashSet<HZTimer>();
            for (TimerPrimaryKey timer : timers) {
                HZTimer hzTimer = (HZTimer)this.pkCache.get((Object)timer.timerId);
                if (hzTimer == null || !hzTimer.getTimedObjectPk().equals(primaryKey)) continue;
                timersToCancel.add(hzTimer);
            }
            for (HZTimer hZTimer : timersToCancel) {
                this.removeTimer(hZTimer);
            }
        }
    }

    public void createSchedules(long containerId, long applicationId, Map<MethodDescriptor, List<ScheduledTimerDescriptor>> methodDescriptorSchedules, String server_name) {
        JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
        try {
            tm.begin();
            Set keys = (Set)this.containerCache.get((Object)containerId);
            if (keys == null || keys.isEmpty()) {
                this.createSchedules(containerId, applicationId, methodDescriptorSchedules, null, server_name, false, true);
            }
            tm.commit();
        }
        catch (Exception e) {
            this.recoverAndCreateSchedulesError(e, (TransactionManager)tm);
        }
    }

    public void createSchedulesOnServer(EjbDescriptor ejbDescriptor, String server_name) {
        HashMap<MethodDescriptor, List<ScheduledTimerDescriptor>> schedules = new HashMap<MethodDescriptor, List<ScheduledTimerDescriptor>>();
        for (ScheduledTimerDescriptor schd : ejbDescriptor.getScheduledTimerDescriptors()) {
            ArrayList<ScheduledTimerDescriptor> list;
            MethodDescriptor method = schd.getTimeoutMethod();
            if (method == null || !schd.getPersistent()) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "... processing {0}", method);
            }
            if ((list = (ArrayList<ScheduledTimerDescriptor>)schedules.get(method)) == null) {
                list = new ArrayList<ScheduledTimerDescriptor>();
                schedules.put(method, list);
            }
            list.add(schd);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "EJBTimerService - creating schedules for {0}", ejbDescriptor.getUniqueId());
        }
        this.createSchedules(ejbDescriptor.getUniqueId(), ejbDescriptor.getApplication().getUniqueId(), schedules, server_name);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "EJBTimerService - finished processing schedules for BEAN ID: {0}", ejbDescriptor.getUniqueId());
        }
    }

    protected void expungeTimer(TimerPrimaryKey timerId, boolean removeTimerBean) {
        HZTimer timer = (HZTimer)this.pkCache.get((Object)timerId.timerId);
        if (timer != null) {
            this.removeTimer(timer);
        }
        super.expungeTimer(timerId, removeTimerBean);
    }

    protected Collection<TimerPrimaryKey> getTimerIds(Collection<Long> containerIds) {
        Collection result = super.getTimerIds(containerIds);
        for (Long containerId : containerIds) {
            Set colKeys = (Set)this.containerCache.get((Object)containerId);
            if (colKeys == null) continue;
            result.addAll(colKeys);
        }
        return result;
    }

    protected Collection<TimerPrimaryKey> getTimerIds(long containerId, Object timedObjectPrimaryKey) {
        HashSet<TimerPrimaryKey> timerIdsForTimedObject = new HashSet<TimerPrimaryKey>();
        if (timedObjectPrimaryKey == null) {
            Set contKeys = (Set)this.containerCache.get((Object)containerId);
            if (contKeys != null) {
                timerIdsForTimedObject.addAll(contKeys);
            }
        } else {
            Collection timersForTimedObject = (Collection)this.containerCache.get((Object)containerId);
            if (timersForTimedObject != null) {
                for (TimerPrimaryKey timer : timersForTimedObject) {
                    HZTimer hzTimer = (HZTimer)this.pkCache.get((Object)timer.timerId);
                    if (hzTimer == null || !hzTimer.getTimedObjectPk().equals(timedObjectPrimaryKey)) continue;
                    timerIdsForTimedObject.add(timer);
                }
            }
        }
        timerIdsForTimedObject.addAll(super.getTimerIds(containerId, null));
        return timerIdsForTimedObject;
    }

    protected EJBTimerSchedule getTimerSchedule(TimerPrimaryKey timerId) throws FinderException {
        EJBTimerSchedule ts = null;
        if (this.isNonpersistent(timerId)) {
            ts = super.getTimerSchedule(timerId);
        } else {
            HZTimer timer = this.getPersistentTimer(timerId);
            ts = timer.getSchedule();
        }
        return ts;
    }

    public boolean isPersistent() {
        return true;
    }

    protected boolean isCancelledByAnotherInstance(RuntimeTimerState timerState) {
        if (timerState.isPersistent() && !this.isDas) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "For Timer :{0}: check the database to ensure that the timer is still  valid, before delivering the ejbTimeout call", timerState.getTimerId());
            }
            if (!this.checkForTimerValidity(timerState.getTimerId())) {
                return true;
            }
        }
        return false;
    }

    protected boolean isPersistent(TimerPrimaryKey timerId) throws FinderException {
        if (this.isNonpersistent(timerId)) {
            return false;
        }
        this.getPersistentTimer(timerId);
        return true;
    }

    protected boolean isValidTimerForThisServer(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
        HZTimer timer;
        boolean result = true;
        if (timerState.isPersistent() && ((timer = (HZTimer)this.pkCache.get((Object)timerId.timerId)) == null || !timer.getMemberName().equals(this.serverName))) {
            result = false;
            this.removeLocalTimer(timer);
        }
        return result;
    }

    static String[] listTimers(Collection<HZTimer> timers, String[] serverIds) {
        String[] result = new String[serverIds.length];
        HashMap<String, Long> counts = new HashMap<String, Long>();
        for (HZTimer timer : timers) {
            String serverName = timer.getMemberName();
            Long val = (Long)counts.get(serverName);
            if (val == null) {
                val = new Long(0L);
            }
            counts.put(serverName, new Long(val.intValue() + 1));
        }
        for (int i = 0; i < serverIds.length; ++i) {
            Long count = (Long)counts.get(serverIds[i]);
            result[i] = count != null ? ((Long)counts.get(serverIds[i])).toString() : "0";
        }
        return result;
    }

    public String[] listTimers(String[] serverIds) {
        return HazelcastTimerStore.listTimers(this.pkCache.values(), serverIds);
    }

    public int migrateTimers(String fromOwnerId) {
        String ownerIdOfThisServer = this.getOwnerIdOfThisServer();
        if (fromOwnerId.equals(ownerIdOfThisServer)) {
            logger.log(Level.WARNING, "Attempt to migrate timers from {0} to itself", ownerIdOfThisServer);
            throw new IllegalStateException("Attempt to migrate timers from " + ownerIdOfThisServer + " to itself");
        }
        logger.log(Level.INFO, "Beginning timer migration process from owner {0} to {1}", new Object[]{fromOwnerId, ownerIdOfThisServer});
        JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
        HashMap<String, HZTimer> toRestore = new HashMap<String, HZTimer>();
        int totalTimersMigrated = 0;
        for (String string : this.pkCache.keySet()) {
            HZTimer hZTimer = (HZTimer)this.pkCache.get((Object)string);
            if (!hZTimer.getOwnerId().equals(fromOwnerId)) continue;
            toRestore.put(string, hZTimer);
            hZTimer.setOwnerId(ownerIdOfThisServer);
            hZTimer.setMemberName(this.serverName);
        }
        for (Map.Entry entry : toRestore.entrySet()) {
            this.pkCache.put(entry.getKey(), entry.getValue());
            ++totalTimersMigrated;
        }
        if (totalTimersMigrated > 0) {
            boolean success = false;
            try {
                logger.log(Level.INFO, "Timer migration phase 1 complete. Changed ownership of {0} timers.  Now reactivating timers...", toRestore.size());
                this._notifyContainers(toRestore.values());
                tm.begin();
                this._restoreTimers(toRestore.values());
                success = true;
                this._notifyMigratedFromInstance(fromOwnerId);
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "timer restoration error", exception);
                EJBException ejbEx = this.createEJBException(exception);
                throw ejbEx;
            }
            finally {
                block13: {
                    try {
                        tm.commit();
                    }
                    catch (Exception re) {
                        logger.log(Level.FINE, "timer migration error", re);
                        if (!success) break block13;
                        EJBException ejbEx = this.createEJBException(re);
                        throw ejbEx;
                    }
                }
            }
        }
        logger.log(Level.INFO, "{0} has 0 timers in need of migration", fromOwnerId);
        return totalTimersMigrated;
    }

    protected Map<TimerPrimaryKey, Method> recoverAndCreateSchedules(long containerId, long applicationId, Map<Method, List<ScheduledTimerDescriptor>> schedules, boolean deploy) {
        HashMap<TimerPrimaryKey, Method> result = new HashMap<TimerPrimaryKey, Method>();
        boolean lostCluster = false;
        HashSet<HZTimer> activeTimers = new HashSet<HZTimer>();
        Set containerKeys = (Set)this.containerCache.get((Object)containerId);
        HashSet<TimerPrimaryKey> deadKeys = new HashSet<TimerPrimaryKey>();
        HashSet<HZTimer> timers = new HashSet<HZTimer>();
        if (containerKeys != null) {
            for (TimerPrimaryKey containerKey : containerKeys) {
                HZTimer timer = (HZTimer)this.pkCache.get((Object)containerKey.timerId);
                if (timer != null) {
                    if (timer.getMemberName().equals(this.serverName)) {
                        activeTimers.add(timer);
                        continue;
                    }
                    timers.add(timer);
                    continue;
                }
                deadKeys.add(containerKey);
            }
            if (!deadKeys.isEmpty()) {
                logger.log(Level.INFO, "Cleaning out {0} dead timer ids from Container Cache ", deadKeys.size());
                for (TimerPrimaryKey deadKey : deadKeys) {
                    containerKeys.remove(deadKey);
                }
                this.containerCache.put((Object)containerId, (Object)containerKeys);
            }
        } else if (containerKeys == null && !deploy) {
            logger.log(Level.INFO, "Looks like we lost the data grid storage will recreate timers");
            lostCluster = true;
        }
        timers.addAll(this._restoreTimers((Set<HZTimer>)activeTimers));
        if (timers.size() > 0) {
            logger.log(Level.FINE, "Found {0} persistent timers for containerId: {1}", new Object[]{timers.size(), containerId});
        }
        boolean schedulesExist = schedules.size() > 0;
        for (HZTimer timer : timers) {
            EJBTimerSchedule ts = timer.getSchedule();
            if (ts == null || !ts.isAutomatic() || !schedulesExist) continue;
            Iterator<Map.Entry<Method, List<ScheduledTimerDescriptor>>> schedulesIterator = schedules.entrySet().iterator();
            while (schedulesIterator.hasNext()) {
                Map.Entry<Method, List<ScheduledTimerDescriptor>> entry = schedulesIterator.next();
                Method m = entry.getKey();
                if (!m.getName().equals(ts.getTimerMethodName()) || m.getParameterTypes().length != ts.getMethodParamCount()) continue;
                result.put(new TimerPrimaryKey(timer.getKey().getTimerId()), m);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "@@@ FOUND existing schedule: {0} FOR method: {1}", new Object[]{ts.getScheduleAsString(), m});
                }
                schedulesIterator.remove();
            }
        }
        try {
            if (!schedules.isEmpty()) {
                this.createSchedules(containerId, applicationId, schedules, result, this.serverName, true, deploy && this.isDas || lostCluster);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(HazelcastTimerStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    protected boolean redeliverTimeout(RuntimeTimerState timerState) {
        return (long)timerState.getNumFailedDeliveries() < this.getMaxRedeliveries();
    }

    protected void resetLastExpiration(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
        if (timerState.isPersistent()) {
            HZTimer timer = (HZTimer)this.pkCache.get((Object)timerId.timerId);
            if (null == timer) {
                return;
            }
            if (this.removeLocalTimer(timer)) {
                return;
            }
            Date now = new Date();
            timer.setLastExpiration(now);
            this.pkCache.put((Object)timer.getKey().timerId, (Object)timer);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Setting last expiration for periodic timer {0} to {1}", new Object[]{timerState, now});
            }
        }
    }

    protected void resetEJBTimers(String target) {
        if (target == null) {
            logger.log(Level.INFO, "==> Restoring Timers ... ");
            if (this.restoreEJBTimers()) {
                logger.log(Level.INFO, "<== ... Timers Restored.");
            }
        }
    }

    protected boolean stopOnFailure() {
        return false;
    }

    protected boolean timerExists(TimerPrimaryKey timerId) {
        HZTimer timer;
        boolean exists = super.timerExists(timerId);
        if (!exists && (timer = (HZTimer)this.pkCache.get((Object)timerId.timerId)) != null) {
            exists = true;
        }
        return exists;
    }

    protected void stopTimers(long containerId) {
        super.stopTimers(containerId);
        this.stopTimers((Set)this.containerCache.get((Object)containerId));
    }

    private HZTimer getPersistentTimer(TimerPrimaryKey timerId) throws FinderException {
        HZTimer result = (HZTimer)this.pkCache.get((Object)timerId.timerId);
        if (result == null) {
            throw new FinderException("Unable to find timer " + timerId);
        }
        return result;
    }

    private void removeTimer(HZTimer timer) {
        this.pkCache.remove((Object)timer.getKey().timerId);
        Set keys = (Set)this.applicationCache.get((Object)timer.getApplicationId());
        if (keys != null) {
            keys.remove(timer.getKey());
            this.applicationCache.put((Object)timer.getApplicationId(), (Object)keys);
        }
        if ((keys = (Set)this.containerCache.get((Object)timer.getContainerId())) != null) {
            keys.remove(timer.getKey());
            this.containerCache.put((Object)timer.getContainerId(), (Object)keys);
        }
    }

    private void recoverAndCreateSchedulesError(Exception e, TransactionManager tm) {
        logger.log(Level.WARNING, "Timer restore or schedule creation error", e);
        try {
            tm.rollback();
        }
        catch (Exception re) {
            logger.log(Level.FINE, "Timer restore or schedule creation rollback error", re);
        }
        EJBException ejbEx = this.createEJBException(e);
        throw ejbEx;
    }

    private boolean checkForTimerValidity(TimerPrimaryKey timerId) {
        boolean result = false;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(HazelcastTimerStore.class.getClassLoader());
        HZTimer timer = (HZTimer)this.pkCache.get((Object)timerId.timerId);
        if (timer != null && timer.getMemberName().equals(this.serverName)) {
            result = true;
        }
        Thread.currentThread().setContextClassLoader(cl);
        return result;
    }

    private void _notifyContainers(Collection<HZTimer> timers) {
        for (HZTimer timer : timers) {
            EJBTimerSchedule ts = timer.getSchedule();
            if (ts == null || !ts.isAutomatic()) continue;
            this.addToSchedules(timer.getContainerId(), timer.getKey(), ts);
        }
    }

    private void restoreTimers() throws Exception {
        if (this.totalTimedObjectsInitialized_ == 0L) {
            return;
        }
        this._restoreTimers(this.findActiveTimersOwnedByThisServer());
    }

    private Collection<HZTimer> _restoreTimers(Collection<HZTimer> timersEligibleForRestoration) {
        HashMap<RuntimeTimerState, Date> timersToRestore = new HashMap<RuntimeTimerState, Date>();
        HashSet<TimerPrimaryKey> timerIdsToRemove = new HashSet<TimerPrimaryKey>();
        HashSet<HZTimer> result = new HashSet<HZTimer>();
        for (HZTimer hZTimer : timersEligibleForRestoration) {
            TimerPrimaryKey timerId = hZTimer.getKey();
            if (this.getTimerState(timerId) != null) {
                logger.log(Level.FINE, "@@@ Timer already restored: {0}", hZTimer);
                result.add(hZTimer);
                continue;
            }
            long containerId = hZTimer.getContainerId();
            BaseContainer container = this.getContainer(containerId);
            if (container != null) {
                long appid = hZTimer.getApplicationId();
                if (appid == 0L) {
                    hZTimer.setApplicationId(container.getApplicationId());
                }
                if (!hZTimer.getMemberName().equals(this.serverName)) {
                    hZTimer.setMemberName(this.serverName);
                }
                Date initialExpiration = hZTimer.getInitialExpiration();
                Object timedObjectPrimaryKey = null;
                if (container.getContainerType() == BaseContainer.ContainerType.ENTITY) {
                    timedObjectPrimaryKey = hZTimer.getTimedObjectPk();
                }
                RuntimeTimerState timerState = new RuntimeTimerState(timerId, initialExpiration, hZTimer.getIntervalDuration(), container, timedObjectPrimaryKey, hZTimer.getSchedule(), null, true);
                this.timerCache_.addTimer(timerId, timerState);
                Date expirationTime = initialExpiration;
                Date now = new Date();
                if (timerState.isPeriodic()) {
                    Date lastExpiration = hZTimer.getLastExpiration();
                    EJBTimerSchedule ts = hZTimer.getSchedule();
                    if (lastExpiration == null && now.after(initialExpiration)) {
                        if (!timerState.isExpired()) {
                            logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer {0}. Timer expirations should  have been delivered starting at {1}", new Object[]{timerState, initialExpiration});
                        }
                    } else if (lastExpiration != null && (ts != null && ts.getNextTimeout(lastExpiration).getTimeInMillis() < now.getTime() || ts == null && now.getTime() - lastExpiration.getTime() > hZTimer.getIntervalDuration())) {
                        logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer {0}.  Last timer expiration occurred at {1}", new Object[]{timerState, lastExpiration});
                    } else {
                        expirationTime = this.calcNextFixedRateExpiration(timerState);
                    }
                } else if (now.after(initialExpiration)) {
                    logger.log(Level.INFO, "Rescheduling missed expiration for single-action timer {0}. Timer expiration should  have been delivered at {1}", new Object[]{timerState, initialExpiration});
                }
                if (expirationTime == null) {
                    logger.log(Level.INFO, "Removing schedule-based timer {0} that will never expire again", timerState);
                    timerIdsToRemove.add(timerId);
                    continue;
                }
                timersToRestore.put(timerState, expirationTime);
                result.add(hZTimer);
                continue;
            }
            logger.log(Level.FINE, "Skipping timer {0} for container that is not up: {1}", new Object[]{timerId, containerId});
        }
        this.removeTimers(timerIdsToRemove);
        for (Map.Entry entry : timersToRestore.entrySet()) {
            RuntimeTimerState nextTimer = (RuntimeTimerState)entry.getKey();
            TimerPrimaryKey timerId = nextTimer.getTimerId();
            Date expiration = (Date)entry.getValue();
            this.scheduleTask(timerId, expiration);
            logger.log(Level.FINE, "EJBTimerService.restoreTimers(), scheduling timer {0}", nextTimer);
        }
        logger.log(Level.FINE, "DONE EJBTimerService.restoreTimers()");
        return result;
    }

    private Set<HZTimer> _restoreTimers(Set<HZTimer> timersEligibleForRestoration) {
        HashMap<RuntimeTimerState, Date> timersToRestore = new HashMap<RuntimeTimerState, Date>();
        HashSet<TimerPrimaryKey> timerIdsToRemove = new HashSet<TimerPrimaryKey>();
        HashSet<HZTimer> result = new HashSet<HZTimer>();
        for (HZTimer hZTimer : timersEligibleForRestoration) {
            TimerPrimaryKey timerId = hZTimer.getKey();
            if (this.getTimerState(timerId) != null) {
                logger.log(Level.FINE, "@@@ Timer already restored: {0}", hZTimer);
                result.add(hZTimer);
                continue;
            }
            long containerId = hZTimer.getContainerId();
            BaseContainer container = this.getContainer(containerId);
            if (container != null) {
                long appid = hZTimer.getApplicationId();
                if (appid == 0L) {
                    hZTimer.setApplicationId(container.getApplicationId());
                }
                Date initialExpiration = hZTimer.getInitialExpiration();
                Object timedObjectPrimaryKey = null;
                if (container.getContainerType() == BaseContainer.ContainerType.ENTITY) {
                    timedObjectPrimaryKey = hZTimer.getTimedObjectPk();
                }
                RuntimeTimerState timerState = new RuntimeTimerState(timerId, initialExpiration, hZTimer.getIntervalDuration(), container, timedObjectPrimaryKey, hZTimer.getSchedule(), null, true);
                this.timerCache_.addTimer(timerId, timerState);
                Date expirationTime = initialExpiration;
                Date now = new Date();
                if (timerState.isPeriodic()) {
                    Date lastExpiration = hZTimer.getLastExpiration();
                    EJBTimerSchedule ts = hZTimer.getSchedule();
                    if (lastExpiration == null && now.after(initialExpiration)) {
                        if (!timerState.isExpired()) {
                            logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer {0}. Timer expirations should  have been delivered starting at {1}", new Object[]{timerState, initialExpiration});
                        }
                    } else if (lastExpiration != null && (ts != null && ts.getNextTimeout(lastExpiration).getTimeInMillis() < now.getTime() || ts == null && now.getTime() - lastExpiration.getTime() > hZTimer.getIntervalDuration())) {
                        logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer {0}.  Last timer expiration occurred at {1}", new Object[]{timerState, lastExpiration});
                    } else {
                        expirationTime = this.calcNextFixedRateExpiration(timerState);
                    }
                } else if (now.after(initialExpiration)) {
                    logger.log(Level.INFO, "Rescheduling missed expiration for single-action timer {0}. Timer expiration should  have been delivered at {1}", new Object[]{timerState, initialExpiration});
                }
                if (expirationTime == null) {
                    logger.log(Level.INFO, "Removing schedule-based timer {0} that will never expire again", timerState);
                    timerIdsToRemove.add(timerId);
                    continue;
                }
                timersToRestore.put(timerState, expirationTime);
                result.add(hZTimer);
                continue;
            }
            logger.log(Level.FINE, "Skipping timer {0} for container that is not up: {1}", new Object[]{timerId, containerId});
        }
        this.removeTimers(timerIdsToRemove);
        for (Map.Entry entry : timersToRestore.entrySet()) {
            RuntimeTimerState nextTimer = (RuntimeTimerState)entry.getKey();
            TimerPrimaryKey timerId = nextTimer.getTimerId();
            Date expiration = (Date)entry.getValue();
            this.scheduleTask(timerId, expiration);
            logger.log(Level.FINE, "EJBTimerService.restoreTimers(), scheduling timer {0}", nextTimer);
        }
        logger.log(Level.FINE, "DONE EJBTimerService.restoreTimers()");
        return result;
    }

    private Collection<HZTimer> findActiveTimersOwnedByThisServer() {
        HashSet<HZTimer> result = new HashSet<HZTimer>();
        for (HZTimer timer : this.pkCache.values()) {
            if (!timer.getMemberName().equals(this.serverName)) continue;
            result.add(timer);
        }
        return result;
    }

    private boolean restoreEJBTimers() {
        boolean rc = false;
        try {
            if (this.totalTimedObjectsInitialized_ > 0L) {
                this.restoreTimers();
                rc = true;
            } else {
                int s = this.findActiveTimersOwnedByThisServer().size();
                if (s > 0) {
                    logger.log(Level.INFO, "[{0}] EJB Timers owned by this server will be restored when timeout beans are loaded", s);
                } else {
                    logger.log(Level.INFO, "There are no EJB Timers owned by this server");
                }
                rc = true;
            }
        }
        catch (Exception ex) {
            EJBTimerService.setPersistentTimerService(null);
            logger.log(Level.WARNING, "ejb.timer_service_init_error", ex);
        }
        return rc;
    }

    @Override
    public void memberAdded(MemberEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberRemoved(MemberEvent event) {
        FencedLock hazelcastLock = this.hazelcast.getCPSubsystem().getLock("EJB-TIMER-LOCK");
        hazelcastLock.lock();
        try {
            Collection allTimers = this.pkCache.values();
            HashSet<HZTimer> removedTimers = new HashSet<HZTimer>();
            for (HZTimer timer : allTimers) {
                if (!timer.getMemberName().equals(event.getServer())) continue;
                removedTimers.add(timer);
            }
            if (!removedTimers.isEmpty()) {
                logger.log(Level.INFO, "==> Restoring Timers ... ");
                Collection<HZTimer> restored = this._restoreTimers((Collection<HZTimer>)removedTimers);
                for (HZTimer timer : restored) {
                    this.pkCache.put((Object)timer.getKey().getTimerId(), (Object)timer);
                }
                logger.log(Level.INFO, "<== ... Timers Restored.");
            }
        }
        finally {
            hazelcastLock.unlock();
        }
    }

    private void removeLocalTimers() {
        Collection allTimers = this.pkCache.values();
        for (HZTimer timer : allTimers) {
            this.removeLocalTimer(timer);
        }
    }

    private boolean removeLocalTimer(HZTimer timer) {
        boolean result = false;
        TimerPrimaryKey timerId = timer.getKey();
        if (!timer.getOwnerId().equals(this.getOwnerIdOfThisServer()) && this.getTimerState(timerId) != null) {
            logger.log(Level.INFO, "The timer (" + timerId + ") is now owned by (" + timer.getOwnerId() + "). Removing from local cache");
            super.expungeTimer(timerId, false);
            result = true;
        }
        return result;
    }

    private void _notifyMigratedFromInstance(String fromOwnerId) {
        PayaraCluster cluster = (PayaraCluster)Globals.getDefaultBaseServiceLocator().getService(PayaraCluster.class, new Annotation[0]);
        PayaraInstanceImpl instance = (PayaraInstanceImpl)Globals.getDefaultBaseServiceLocator().getService(PayaraInstanceImpl.class, new Annotation[0]);
        if (cluster == null || instance == null) {
            return;
        }
        InstanceDescriptor fromOwnerInstanceDescriptor = null;
        for (InstanceDescriptor instanceDescriptor : instance.getClusteredPayaras()) {
            if (!instanceDescriptor.getInstanceName().equals(fromOwnerId)) continue;
            fromOwnerInstanceDescriptor = instanceDescriptor;
            break;
        }
        if (fromOwnerInstanceDescriptor == null) {
            return;
        }
        EjbTimerEvent ejbTimerEvent = new EjbTimerEvent(EjbTimerEvent.Event.MIGRATED, fromOwnerInstanceDescriptor);
        ClusterMessage<EjbTimerEvent> message = new ClusterMessage<EjbTimerEvent>(ejbTimerEvent);
        cluster.getEventBus().publish("payara.server.internal.ejb.timer.event", message);
    }

    @Override
    public void receiveMessage(ClusterMessage<EjbTimerEvent> ejbTimerEvent) {
        if (ejbTimerEvent.getPayload().getEventType().equals((Object)EjbTimerEvent.Event.MIGRATED)) {
            PayaraInstanceImpl instance = (PayaraInstanceImpl)Globals.getDefaultBaseServiceLocator().getService(PayaraInstanceImpl.class, new Annotation[0]);
            if (instance == null) {
                return;
            }
            if (ejbTimerEvent.getPayload().getId().equals((Object)instance.getLocalDescriptor())) {
                this.removeLocalTimers();
            }
        }
    }
}

