/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.SerialContext;
import com.sun.enterprise.naming.impl.WrappedSerialContext;
import com.sun.enterprise.naming.util.LogFacade;
import java.lang.annotation.Annotation;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;
import org.glassfish.api.naming.NamingClusterInfo;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ORBLocator;
import org.omg.CORBA.ORB;

public class SerialInitContextFactory
implements InitialContextFactory {
    private static volatile boolean initialized = false;
    private static String defaultHost = null;
    private static String defaultPort = null;
    private static ServiceLocator defaultServices = null;
    private final ServiceLocator services;

    static void setDefaultHost(String host) {
        defaultHost = host;
    }

    static void setDefaultPort(String port) {
        defaultPort = port;
    }

    static void setDefaultServices(ServiceLocator h) {
        defaultServices = h;
    }

    static ServiceLocator getDefaultServices() {
        return defaultServices;
    }

    private boolean propertyIsSet(Hashtable env, String pname) {
        String value = this.getEnvSysProperty(env, pname);
        return value != null && !value.isEmpty();
    }

    private String getEnvSysProperty(Hashtable env, String pname) {
        String value = (String)env.get(pname);
        if (value == null) {
            value = System.getProperty(pname);
        }
        return value;
    }

    private String getCorbalocURL(List<String> list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String str : list) {
            if (first) {
                first = false;
                sb.append("corbaloc:");
            } else {
                sb.append(',');
            }
            sb.append("iiop:1.2@");
            sb.append(str.trim());
        }
        return sb.toString();
    }

    public SerialInitContextFactory() {
        ServiceLocator temp = defaultServices;
        if (temp == null) {
            temp = Globals.getDefaultHabitat();
        }
        if (temp == null) {
            temp = Globals.getStaticHabitat();
        }
        this.services = temp;
    }

    private ORB getORB() {
        ORBLocator orbLocator;
        if (this.services != null && (orbLocator = (ORBLocator)this.services.getService(ORBLocator.class, new Annotation[0])) != null) {
            return orbLocator.getORB();
        }
        throw new RuntimeException("Could not get ORB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Context getInitialContext(Hashtable env) throws NamingException {
        Hashtable<String, String> myEnv;
        Hashtable<String, String> hashtable = myEnv = env == null ? new Hashtable<String, String>() : env;
        if (LogFacade.logger.isLoggable(Level.FINE)) {
            LogFacade.logger.log(Level.FINE, "getInitialContext: env={0}", env);
        }
        boolean useLB = this.propertyIsSet(myEnv, "com.sun.appserv.iiop.endpoints") || this.propertyIsSet(myEnv, "com.sun.appserv.iiop.loadbalancingpolicy");
        NamingClusterInfo namingClusterInfo = null;
        boolean enableClusterUpdate = true;
        enableClusterUpdate = Boolean.parseBoolean(System.getProperty("fish.payara.iiop.clusterupdate", "true"));
        if (this.propertyIsSet(myEnv, "fish.payara.iiop.clusterupdate")) {
            enableClusterUpdate = Boolean.parseBoolean(this.getEnvSysProperty(myEnv, "fish.payara.iiop.clusterupdate"));
        }
        if (useLB) {
            if (!initialized) {
                Class<SerialInitContextFactory> clazz = SerialInitContextFactory.class;
                // MONITORENTER : com.sun.enterprise.naming.impl.SerialInitContextFactory.class
                if (!initialized) {
                    namingClusterInfo = (NamingClusterInfo)this.services.getService(NamingClusterInfo.class, new Annotation[0]);
                    namingClusterInfo.initGroupInfoService(myEnv, defaultHost, defaultPort, this.getORB(), this.services, enableClusterUpdate);
                    initialized = true;
                }
                // MONITOREXIT : clazz
            }
            if (!myEnv.containsKey("com.sun.appserv.ee.iiop.endpointslist")) {
                Context ctx = SerialContext.getStickyContext();
                if (ctx != null) {
                    return ctx;
                }
                if (namingClusterInfo == null) {
                    namingClusterInfo = (NamingClusterInfo)this.services.getService(NamingClusterInfo.class, new Annotation[0]);
                    namingClusterInfo.setClusterInstanceInfo(myEnv, defaultHost, defaultPort, !enableClusterUpdate);
                }
                List rrList = namingClusterInfo.getNextRotation();
                if (LogFacade.logger.isLoggable(Level.FINE)) {
                    LogFacade.logger.log(Level.FINE, "getInitialContext: RoundRobinPolicy list = {0}", rrList);
                }
                myEnv.put("com.sun.appserv.ee.iiop.endpointslist", this.getCorbalocURL(rrList));
            }
            myEnv.put("java.naming.corba.orb", (String)this.getORB());
            return this.createInitialContext(myEnv);
        }
        if (defaultHost != null) {
            myEnv.put("org.omg.CORBA.ORBInitialHost", defaultHost);
        }
        if (defaultPort == null) return this.createInitialContext(myEnv);
        myEnv.put("org.omg.CORBA.ORBInitialPort", defaultPort);
        return this.createInitialContext(myEnv);
    }

    private Context createInitialContext(Hashtable env) throws NamingException {
        SerialContext serialContext = new SerialContext(env, this.services);
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return new WrappedSerialContext(env, serialContext);
        }
        return serialContext;
    }
}

