/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.InvalidConfigException;
import com.sun.enterprise.admin.servermgmt.Validator;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.HashMap;

public abstract class DomainConfigValidator
extends Validator {
    private static final StringManager STRING_MANAGER = StringManager.getManager(DomainConfigValidator.class);
    private DomainConfigEntryInfo[] entries;

    protected DomainConfigValidator(DomainConfigEntryInfo[] entries) {
        super(STRING_MANAGER.getString("domainConfig"), DomainConfig.class);
        this.entries = entries;
    }

    protected DomainConfigValidator(String name, Class type, DomainConfigEntryInfo[] entries) {
        super(name, type);
        this.entries = entries;
    }

    @Override
    public void validate(Object domainConfig) throws InvalidConfigException {
        super.validate(domainConfig);
        for (DomainConfigEntryInfo entry : this.entries) {
            if (!this.isValidate(entry.key, domainConfig)) continue;
            Object value = ((HashMap)domainConfig).get(entry.key);
            if (!entry.hasValidator()) continue;
            entry.validator.validate(value);
        }
    }

    public boolean isKeyAllowed(Object key) {
        return this.get(key) != null;
    }

    public boolean isValueValid(Object key, Object value) {
        boolean isValid = false;
        DomainConfigEntryInfo info = this.get(key);
        if (info != null) {
            if (info.hasValidator()) {
                try {
                    info.validator.validate(value);
                }
                catch (InvalidConfigException idce) {
                    isValid = false;
                }
            } else {
                isValid = true;
            }
        }
        return isValid;
    }

    public String getDataType(Object key) {
        DomainConfigEntryInfo info = this.get(key);
        if (info != null) {
            return info.dataType;
        }
        return "";
    }

    protected abstract boolean isValidate(String var1, Object var2);

    private DomainConfigEntryInfo get(Object key) {
        for (DomainConfigEntryInfo entry : this.entries) {
            if (!entry.key.equals(key)) continue;
            return entry;
        }
        return null;
    }

    protected static class DomainConfigEntryInfo {
        final String key;
        final String dataType;
        final Validator validator;

        public DomainConfigEntryInfo(String key, String dataType, Validator validator) {
            this.key = key;
            this.dataType = dataType;
            this.validator = validator;
        }

        public boolean hasValidator() {
            return this.validator != null;
        }
    }
}

