/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class RepositoryConfig
extends HashMap<String, Object> {
    public static final String K_INSTALL_ROOT = "install.root";
    public static final String K_CONFIG_ROOT = "config.root";
    public static final String K_REFRESH_CONFIG_CONTEXT = "refresh.cc";
    private String repositoryName;
    private String repositoryRoot;
    private String instanceName;
    private String configurationName;

    public RepositoryConfig(String repositoryName, String repositoryRoot, String instanceName, String configName) {
        this.instanceName = instanceName;
        this.repositoryName = repositoryName;
        this.repositoryRoot = repositoryRoot;
        this.configurationName = configName;
        Map<String, String> envProperties = this.getEnvProps();
        this.put(K_INSTALL_ROOT, this.getFilePath(envProperties.get("com.sun.aas.installRoot")));
        this.put(K_CONFIG_ROOT, this.getFilePath(envProperties.get("com.sun.aas.installRoot")));
        this.put(K_REFRESH_CONFIG_CONTEXT, true);
    }

    public RepositoryConfig(String repositoryName, String repositoryRoot, String instanceName) {
        this(repositoryName, repositoryRoot, instanceName, null);
    }

    public RepositoryConfig(String repositoryName, String repositoryRoot) {
        this(repositoryName, repositoryRoot, null);
    }

    public RepositoryConfig() {
        this(System.getProperty("com.sun.aas.instanceRoot"));
    }

    public RepositoryConfig(String instanceRootString) {
        File instanceRoot = new File(instanceRootString);
        File repositoryDir = instanceRoot.getParentFile();
        this.instanceName = instanceRoot.getName();
        this.repositoryName = repositoryDir.getName();
        this.repositoryRoot = FileUtils.makeForwardSlashes((String)repositoryDir.getParentFile().getAbsolutePath());
        this.configurationName = null;
        Map<String, String> envProperties = this.getEnvProps();
        this.put(K_INSTALL_ROOT, envProperties.get("com.sun.aas.installRoot"));
        this.put(K_CONFIG_ROOT, this.getFilePath(envProperties.get("com.sun.aas.configRoot")));
    }

    @Override
    public String toString() {
        return "repositoryRoot " + this.repositoryRoot + " repositoryName " + this.repositoryName + " instanceName " + this.instanceName + " configurationName " + this.configurationName;
    }

    protected String getFilePath(String propertyName) {
        File f = new File(propertyName);
        return FileUtils.makeForwardSlashes((String)f.getAbsolutePath());
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public String getDisplayName() {
        return this.getRepositoryName();
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    protected void setRepositoryRoot(String repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
    }

    public String getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public String getInstallRoot() {
        return (String)this.get(K_INSTALL_ROOT);
    }

    public String getConfigRoot() {
        return (String)this.get(K_CONFIG_ROOT);
    }

    public Boolean getRefreshConfigContext() {
        return (Boolean)this.get(K_REFRESH_CONFIG_CONTEXT);
    }

    public void setRefreshConfingContext(boolean refresh) {
        this.put(K_REFRESH_CONFIG_CONTEXT, refresh);
    }

    private Map<String, String> getEnvProps() {
        ASenvPropertyReader pr = new ASenvPropertyReader();
        return pr.getProps();
    }
}

