/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.ColumnFormatter;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.io.DomainDirs;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-domains")
@PerLookup
public final class ListDomainsCommand
extends LocalDomainCommand {
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(ListDomainsCommand.class);
    private String domainsRoot = null;
    @Param(name="long", shortName="l", optional=true)
    boolean longOpt;
    @Param(shortName="h", optional=true, defaultValue="true")
    boolean header;

    @Override
    protected void validate() throws CommandException, CommandValidationException {
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            File domainsDirFile = ListDomainsCommand.ok((String)this.domainDirParam) ? new File(this.domainDirParam) : DomainDirs.getDefaultDomainsDir();
            DomainConfig domainConfig = new DomainConfig(null, domainsDirFile.getAbsolutePath());
            PEDomainsManager manager = new PEDomainsManager();
            String[] domainsList = manager.listDomains(domainConfig);
            this.programOpts.setInteractive(false);
            if (domainsList.length > 0) {
                if (this.longOpt) {
                    String[] headings = new String[]{"DOMAIN", "ADMIN_HOST", "ADMIN_PORT", "RUNNING", "RESTART_REQUIRED"};
                    ColumnFormatter cf = this.header ? new ColumnFormatter(headings) : new ColumnFormatter();
                    for (String dn : domainsList) {
                        DomainInfo di = this.getStatus(dn);
                        cf.addRow(new Object[]{dn, di.adminAddr.getHost(), di.adminAddr.getPort(), di.status, di.restartRequired});
                    }
                    logger.info(cf.toString());
                } else {
                    for (String dn : domainsList) {
                        logger.info(this.getStatus((String)dn).statusMsg);
                    }
                }
            } else {
                logger.fine(STRINGS.get("NoDomainsToList"));
            }
        }
        catch (Exception ex) {
            throw new CommandException(ex.getLocalizedMessage());
        }
        return 0;
    }

    protected Map<String, Boolean> getDomains() throws IOException, DomainException, CommandException {
        HashMap<String, Boolean> runningDomains = new HashMap<String, Boolean>();
        File domainsDirFile = ListDomainsCommand.ok((String)this.domainDirParam) ? new File(this.domainDirParam) : DomainDirs.getDefaultDomainsDir();
        DomainConfig domainConfig = new DomainConfig(null, domainsDirFile.getAbsolutePath());
        PEDomainsManager manager = new PEDomainsManager();
        String[] domainsList = manager.listDomains(domainConfig);
        this.programOpts.setInteractive(false);
        for (String domain : domainsList) {
            runningDomains.put(domain, this.getStatus((String)domain).status);
        }
        return runningDomains;
    }

    private DomainInfo getStatus(String dn) throws IOException, CommandException {
        this.setDomainName(dn);
        this.initDomain();
        DomainInfo di = new DomainInfo();
        di.adminAddr = this.getAdminAddress();
        this.programOpts.setHostAndPort(di.adminAddr);
        di.status = this.isThisDAS(this.getDomainRootDir());
        if (di.status) {
            di.statusMsg = STRINGS.get("list.domains.StatusRunning", new Object[]{dn});
            try {
                RemoteCLICommand cmd = new RemoteCLICommand("_get-restart-required", this.programOpts, this.env);
                String restartRequired = cmd.executeAndReturnOutput(new String[]{"_get-restart-required"});
                di.restartRequired = Boolean.parseBoolean(restartRequired.trim());
                if (di.restartRequired) {
                    di.statusMsg = STRINGS.get("list.domains.StatusRestartRequired", new Object[]{dn});
                }
            }
            catch (Exception exception) {}
        } else {
            di.statusMsg = STRINGS.get("list.domains.StatusNotRunning", new Object[]{dn});
        }
        return di;
    }

    static class DomainInfo {
        public HostAndPort adminAddr;
        public boolean status;
        public String statusMsg;
        public boolean restartRequired;

        DomainInfo() {
        }
    }
}

