/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.cli.Strings;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.Jps;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class LocalServerCommand
extends CLICommand {
    private ServerDirs serverDirs;
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(LocalDomainCommand.class);
    private static final int IS_RUNNING_DEFAULT_TIMEOUT = 2000;
    protected static final String DEFAULT_MASTER_PASSWORD = "changeit";

    protected boolean checkForSpecialFiles() {
        return true;
    }

    protected final HostAndPort getAdminAddress() throws CommandException {
        return this.getAdminAddress("server");
    }

    protected final HostAndPort getAdminAddress(String serverName) throws CommandException {
        try {
            MiniXmlParser parser = new MiniXmlParser(this.getDomainXml(), serverName);
            List addrSet = parser.getAdminAddresses();
            if (!addrSet.isEmpty()) {
                return (HostAndPort)addrSet.get(0);
            }
            throw new CommandException(STRINGS.get("NoAdminPort"));
        }
        catch (MiniXmlParserException ex) {
            throw new CommandException(STRINGS.get("NoAdminPortEx", new Object[]{ex}), (Throwable)ex);
        }
    }

    protected final void setServerDirs(ServerDirs sd) {
        this.serverDirs = sd;
    }

    protected final boolean isLocal() {
        return this.serverDirs != null && this.serverDirs.getServerName() != null;
    }

    protected final boolean isRemote() {
        return !this.isLocal();
    }

    private void resetLocalPassword() throws IOException {
        this.resetServerDirs();
        this.setLocalPassword();
    }

    protected final void setLocalPassword() {
        String pw;
        String string = pw = this.serverDirs == null ? null : this.serverDirs.getLocalPassword();
        if (LocalServerCommand.ok((String)pw)) {
            this.programOpts.setPassword(pw != null ? pw.toCharArray() : null, ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
            logger.finer("Using local password");
        } else {
            logger.finer("Not using local password");
        }
    }

    protected final void unsetLocalPassword() {
        this.programOpts.setPassword(null, ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
    }

    protected final void resetServerDirs() throws IOException {
        if (this.serverDirs == null) {
            throw new RuntimeException(Strings.get("NoServerDirs"));
        }
        this.serverDirs = this.serverDirs.refresh();
    }

    protected final ServerDirs getServerDirs() {
        return this.serverDirs;
    }

    protected final File getDomainXml() {
        if (this.serverDirs == null) {
            throw new RuntimeException(Strings.get("NoServerDirs"));
        }
        return this.serverDirs.getDomainXml();
    }

    protected final String readFromMasterPasswordFile() {
        File mpf = this.getMasterPasswordFile();
        if (mpf == null) {
            return null;
        }
        try {
            PasswordAdapter pw = new PasswordAdapter(mpf.getAbsolutePath(), "master-password".toCharArray());
            return pw.getPasswordForAlias("master-password");
        }
        catch (Exception e) {
            logger.log(Level.FINER, "master password file reading error: {0}", e.getMessage());
            return null;
        }
    }

    protected final boolean verifyMasterPassword(String mpv) {
        return this.loadAndVerifyKeystore(this.getJKS(), mpv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadAndVerifyKeystore(File jks, String mpv) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(jks);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(fis, mpv.toCharArray());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(e.getMessage());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected final String getMasterPassword() throws CommandException {
        int RETRIES = 3;
        long t0 = this.now();
        String mpv = (String)this.passwords.get("AS_ADMIN_MASTERPASSWORD");
        if (mpv == null) {
            mpv = DEFAULT_MASTER_PASSWORD;
            if (!this.verifyMasterPassword(mpv) && !this.verifyMasterPassword(mpv = this.readFromMasterPasswordFile())) {
                mpv = this.retry(3);
            }
        } else if (!this.verifyMasterPassword(mpv)) {
            mpv = this.retry(3);
        }
        long t1 = this.now();
        logger.log(Level.FINER, "Time spent in master password extraction: {0} msec", t1 - t0);
        return mpv;
    }

    protected final boolean isThisServer(File ourDir, String directoryKey) {
        if (!LocalServerCommand.ok((String)directoryKey)) {
            throw new NullPointerException();
        }
        ourDir = this.getUniquePath(ourDir);
        logger.log(Level.FINER, "Check if server is at location {0}", ourDir);
        try {
            this.programOpts.setHostAndPort(this.getAdminAddress());
            RemoteCLICommand cmd = new RemoteCLICommand("__locations", this.programOpts, this.env);
            ActionReport report = cmd.executeAndReturnActionReport(new String[]{"__locations"});
            String theirDirPath = report.findProperty(directoryKey);
            logger.log(Level.FINER, "Remote server has root directory {0}", theirDirPath);
            if (LocalServerCommand.ok((String)theirDirPath)) {
                File theirDir = this.getUniquePath(new File(theirDirPath));
                return theirDir.equals(ourDir);
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected final int getServerPid() {
        try {
            return Integer.parseInt(new RemoteCLICommand("__locations", this.programOpts, this.env).executeAndReturnActionReport(new String[]{"__locations"}).findProperty("Pid"));
        }
        catch (Exception e) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean isRunning(String host, int port) {
        try (Socket server = new Socket();){
            if (host == null) {
                host = InetAddress.getByName(null).getHostName();
            }
            server.connect(new InetSocketAddress(host, port), 2000);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.log(Level.FINER, "\nisRunning got exception: {0}", ex);
            return false;
        }
    }

    protected boolean isRunning() {
        int pp = this.getPrevPid();
        if (pp < 0) {
            return this.isRunningByCheckingForPidFile();
        }
        Boolean b = ProcessUtils.isProcessRunning((int)pp);
        if (b == null) {
            return this.isRunningUsingJps();
        }
        return b;
    }

    protected final void waitForRestart(int oldServerPid) throws CommandException {
        this.waitForRestart(oldServerPid, 600000L);
    }

    protected final void waitForRestart(int oldServerPid, long timeout) throws CommandException {
        long end = this.getEndTime(timeout);
        while (this.now() < end) {
            try {
                int newServerPid;
                if (this.isLocal()) {
                    this.resetLocalPassword();
                }
                if ((newServerPid = this.getServerPid()) > 0 && newServerPid != oldServerPid) {
                    logger.log(Level.FINER, "oldserver-pid, newserver-pid = {0} --- {1}", new Object[]{oldServerPid, newServerPid});
                    return;
                }
                Thread.sleep(300L);
            }
            catch (Exception exception) {}
        }
        throw new CommandException(STRINGS.get("restartDomain.noGFStart"));
    }

    protected final int getPrevPid() {
        try {
            File prevPidFile = new File(this.getServerDirs().getPidFile().getPath() + ".prev");
            if (!prevPidFile.canRead()) {
                return -1;
            }
            String pids = FileUtils.readSmallFile((File)prevPidFile).trim();
            return Integer.parseInt(pids);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private boolean isRunningUsingJps() {
        int pp = this.getPrevPid();
        if (pp < 0) {
            return this.isRunningByCheckingForPidFile();
        }
        return Jps.isPid((int)pp);
    }

    private boolean isRunningByCheckingForPidFile() {
        File pf = this.getServerDirs().getPidFile();
        if (pf != null) {
            return pf.exists();
        }
        return this.isRunning(this.programOpts.getHost(), this.programOpts.getPort());
    }

    protected final long getUptime() throws CommandException {
        RemoteCLICommand cmd = new RemoteCLICommand("uptime", this.programOpts, this.env);
        String up = cmd.executeAndReturnOutput(new String[]{"uptime", "--milliseconds"}).trim();
        long uptimeMillis = this.parseUptime(up);
        if (uptimeMillis <= 0L) {
            throw new CommandException(STRINGS.get("restart.dasNotRunning"));
        }
        logger.log(Level.FINER, "server uptime: {0}", uptimeMillis);
        return uptimeMillis;
    }

    protected final boolean isRestartable() throws CommandException {
        RemoteCLICommand cmd = new RemoteCLICommand("_get-runtime-info", this.programOpts, this.env);
        ActionReport report = cmd.executeAndReturnActionReport(new String[]{"_get-runtime-info"});
        if (report != null) {
            String val = report.findProperty("restartable_value");
            return !LocalServerCommand.ok((String)val) || !val.equals("false");
        }
        return true;
    }

    private long parseUptime(String up) {
        try {
            return Long.parseLong(up);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private File getJKS() {
        if (this.serverDirs == null) {
            return null;
        }
        File mp = new File(new File(this.serverDirs.getServerDir(), "config"), "cacerts.jks");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    protected File getMasterPasswordFile() {
        if (this.serverDirs == null) {
            return null;
        }
        File mp = new File(this.serverDirs.getConfigDir(), "master-password");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    private String retry(int times) throws CommandException {
        for (int i = 0; i < times; ++i) {
            String mpv;
            String prompt = STRINGS.get("mp.prompt", new Object[]{times - i});
            char[] mpvArr = super.readPassword(prompt);
            String string = mpv = mpvArr != null ? new String(mpvArr) : null;
            if (mpv == null) {
                throw new CommandException(STRINGS.get("no.console"));
            }
            if (this.verifyMasterPassword(mpv)) {
                return mpv;
            }
            if (i >= times - 1) continue;
            logger.info(STRINGS.get("retry.mp"));
        }
        throw new CommandException(STRINGS.get("mp.giveup", new Object[]{times}));
    }

    private File getUniquePath(File f) {
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException ioex) {
            f = SmartFile.sanitize((File)f);
        }
        return f;
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private long getEndTime(long timeout) {
        return timeout + this.now();
    }

    protected boolean dataGridEncryptionEnabled() throws IOException, XMLStreamException {
        XMLEventReader xmlReader = XMLInputFactory.newInstance().createXMLEventReader(new FileInputStream(this.getDomainXml()));
        while (xmlReader.hasNext()) {
            XMLEvent event = xmlReader.nextEvent();
            if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals("hazelcast-runtime-configuration")) continue;
            Attribute attribute = event.asStartElement().getAttributeByName(new QName("datagrid-encryption-enabled"));
            if (attribute == null) {
                return false;
            }
            return Boolean.parseBoolean(attribute.getValue());
        }
        logger.warning("Could not determine if data grid encryption is enabled - you will need to regenerate the encryption key if it is");
        return false;
    }

    protected String getInstallRootPath() throws CommandException {
        String installRootPath = this.getSystemProperty("com.sun.aas.installRoot");
        if (!StringUtils.ok((String)installRootPath)) {
            installRootPath = System.getProperty("com.sun.aas.installRoot");
        }
        if (!StringUtils.ok((String)installRootPath)) {
            throw new CommandException("noInstallDirPath");
        }
        return installRootPath;
    }

    protected void checkAdditionalTrustAndKeyStores() throws IOException, XMLStreamException {
        HashMap<String, String> additionalTrustandKeyStores = new HashMap<String, String>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.getDomainXml());
            NodeList jvmOptionsNodes = document.getElementsByTagName("jvm-options");
            for (int i = 0; i < jvmOptionsNodes.getLength(); ++i) {
                String jvmOption = jvmOptionsNodes.item(i).getTextContent();
                if (jvmOption.startsWith("-Dfish.payara.ssl.additionalKeyStores")) {
                    String additionalKeyStores = jvmOption.split("=")[1];
                    additionalTrustandKeyStores.compute("additionalKeyStores", (key, value) -> value == null ? additionalKeyStores : value.concat(", " + additionalKeyStores));
                    continue;
                }
                if (!jvmOption.startsWith("-Dfish.payara.ssl.additionalTrustStores")) continue;
                String additionalTrustStores = jvmOption.split("=")[1];
                additionalTrustandKeyStores.compute("additionalTrustStores", (key, value) -> value == null ? additionalTrustStores : value.concat(", " + additionalTrustStores));
            }
            if (additionalTrustandKeyStores.containsKey("additionalKeyStores")) {
                logger.log(Level.INFO, "The passwords of additional KeyStores {0} have not been changed - please update these manually to continue using them.", Arrays.toString(((String)additionalTrustandKeyStores.get("additionalKeyStores")).split(File.pathSeparator)));
            }
            if (additionalTrustandKeyStores.containsKey("additionalTrustStores")) {
                logger.log(Level.INFO, "The passwords of additional TrustStores {0} have not been changed - please update these manually to continue using them.", Arrays.toString(((String)additionalTrustandKeyStores.get("additionalTrustStores")).split(File.pathSeparator)));
            }
        }
        catch (ParserConfigurationException | SAXException exception) {
            logger.warning("Could not determine if there were additional Key Stores or Trust stores, if the master-password has been updated, the password for the additional stores need updating in order to continue using them.");
        }
    }
}

