/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.domain;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.domain.CustomTokenClient;
import com.sun.enterprise.admin.servermgmt.domain.DomainInfoManager;
import com.sun.enterprise.admin.servermgmt.domain.DomainPortValidator;
import com.sun.enterprise.admin.servermgmt.domain.DomainSecurity;
import com.sun.enterprise.admin.servermgmt.domain.DomainTemplate;
import com.sun.enterprise.admin.servermgmt.domain.SubstitutableTokens;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainConfigValidator;
import com.sun.enterprise.admin.servermgmt.stringsubs.StringSubstitutionFactory;
import com.sun.enterprise.admin.servermgmt.stringsubs.StringSubstitutor;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.AttributePreprocessorImpl;
import com.sun.enterprise.admin.servermgmt.template.TemplateInfoHolder;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.Property;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.PropertyType;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DomainBuilder {
    private static final Logger LOGGER = SLogger.getLogger();
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(DomainBuilder.class);
    private static final String STRINGSUBS_FILE = "stringsubs.xml";
    private static final String TEMPLATE_INFO_XML = "template-info.xml";
    private static final String META_DIR_NAME = "META-INF";
    private static final String DEFAULT_TEMPLATE_RELATIVE_PATH = "common" + File.separator + "templates" + File.separator + "gf";
    private final DomainConfig domainConfig;
    private JarFile templateJar;
    private DomainTemplate domainTemplate;
    private final Properties defaultPropertiesValue = new Properties();
    private byte[] keystoreBytes = null;
    private final Set<String> _extractedEntries = new HashSet<String>();

    public DomainBuilder(DomainConfig domainConfig) throws DomainException {
        this.domainConfig = domainConfig;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws DomainException {
        File template;
        String templateJarPath = (String)this.domainConfig.get("template.name");
        if (templateJarPath == null || templateJarPath.isEmpty()) {
            String defaultTemplateName = Version.getDefaultDomainTemplate();
            if (defaultTemplateName == null || defaultTemplateName.isEmpty()) {
                throw new DomainException(STRINGS.get("missingDefaultTemplateName"));
            }
            Map envProperties = new ASenvPropertyReader().getProps();
            templateJarPath = (String)envProperties.get("com.sun.aas.installRoot") + File.separator + DEFAULT_TEMPLATE_RELATIVE_PATH + File.separator + defaultTemplateName;
        }
        if (!(template = new File(templateJarPath)).exists() || !template.getName().endsWith(".jar")) {
            throw new DomainException(STRINGS.get("invalidTemplateJar", new Object[]{template.getAbsolutePath()}));
        }
        try {
            this.templateJar = new JarFile(new File(templateJarPath));
            JarEntry je = this.templateJar.getJarEntry("config/domain.xml");
            if (je == null) {
                throw new DomainException(STRINGS.get("missingMandatoryFile", new Object[]{"domain.xml"}));
            }
            je = this.templateJar.getJarEntry(TEMPLATE_INFO_XML);
            if (je == null) {
                throw new DomainException(STRINGS.get("missingMandatoryFile", new Object[]{TEMPLATE_INFO_XML}));
            }
            TemplateInfoHolder templateInfoHolder = new TemplateInfoHolder(this.templateJar.getInputStream(je), templateJarPath);
            this._extractedEntries.add(TEMPLATE_INFO_XML);
            je = this.templateJar.getJarEntry(STRINGSUBS_FILE);
            StringSubstitutor stringSubstitutor = null;
            if (je != null) {
                stringSubstitutor = StringSubstitutionFactory.createStringSubstitutor(this.templateJar.getInputStream(je));
                List<Property> defaultPortSubstituteProperties = stringSubstitutor.getDefaultProperties(PropertyType.PORT);
                for (Property property : defaultPortSubstituteProperties) {
                    this.defaultPropertiesValue.setProperty(property.getKey(), property.getValue());
                }
                List<Property> defaultStringSubstituteProperties = stringSubstitutor.getDefaultProperties(PropertyType.STRING);
                for (Property property : defaultStringSubstituteProperties) {
                    this.defaultPropertiesValue.setProperty(property.getKey(), property.getValue());
                }
                this._extractedEntries.add(je.getName());
            } else {
                LOGGER.log(Level.WARNING, "NCLS-SRVRMGMT-00013", STRINGSUBS_FILE);
            }
            this.domainTemplate = new DomainTemplate(templateInfoHolder, stringSubstitutor, templateJarPath);
            je = this.templateJar.getJarEntry("config/keystore.jks");
            if (je != null) {
                this.keystoreBytes = new byte[(int)je.getSize()];
                int count = 0;
                try (InputStream in = null;){
                    in = this.templateJar.getInputStream(je);
                    count = in.read(this.keystoreBytes);
                    if (count < this.keystoreBytes.length) {
                        throw new DomainException(STRINGS.get("loadingFailure", new Object[]{je.getName()}));
                    }
                }
                this._extractedEntries.add(je.getName());
            }
            File parentDomainDir = FileUtils.safeGetCanonicalFile((File)new File(this.domainConfig.getRepositoryRoot()));
            this.createDirectory(parentDomainDir);
        }
        catch (Exception e) {
            throw new DomainException(e);
        }
    }

    public void validateTemplate() throws DomainException {
        try {
            RepositoryManager repoManager = new RepositoryManager();
            repoManager.checkRepository(this.domainConfig, false);
            DomainPortValidator portValidator = new DomainPortValidator(this.domainConfig, this.defaultPropertiesValue);
            portValidator.validateAndSetPorts();
            this.setProperties();
            new PEDomainConfigValidator().validate(this.domainConfig);
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
    }

    public void setProperties() {
        Properties domainProperties = this.domainConfig.getDomainProperties();
        String hazelcastAutoIncrement = this.getProperty(domainProperties, "hazelcast.auto.increment", (String)this.domainConfig.get("hazelcast.auto.increment"), this.defaultPropertiesValue.getProperty("HAZELCAST_AUTO_INCREMENT"));
        this.domainConfig.add("hazelcast.auto.increment", Boolean.valueOf(hazelcastAutoIncrement));
    }

    public String getProperty(Properties properties, String key, String currentValue, String defaultPorperty) {
        String property;
        if (currentValue != null && !currentValue.equals("")) {
            return currentValue;
        }
        if (properties != null && (property = properties.getProperty(key)) != null && !property.equals("")) {
            return property;
        }
        return defaultPorperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws RepositoryException, DomainException {
        File domainDir = FileUtils.safeGetCanonicalFile((File)new File(this.domainConfig.getRepositoryRoot(), this.domainConfig.getDomainName()));
        this.createDirectory(domainDir);
        try {
            byte[] buffer = new byte[10000];
            Enumeration<JarEntry> entry = this.templateJar.entries();
            while (entry.hasMoreElements()) {
                JarEntry jarEntry = entry.nextElement();
                String entryName = jarEntry.getName();
                if (entryName.startsWith(META_DIR_NAME) || this._extractedEntries.contains(entryName)) continue;
                if (jarEntry.isDirectory()) {
                    File dir = new File(domainDir, jarEntry.getName());
                    if (dir.exists() || dir.mkdir()) continue;
                    LOGGER.log(Level.WARNING, "NCLS-SRVRMGMT-00011", dir.getName());
                    continue;
                }
                InputStream in = null;
                FilterOutputStream outputStream = null;
                try {
                    in = this.templateJar.getInputStream(jarEntry);
                    outputStream = new BufferedOutputStream(new FileOutputStream(new File(domainDir.getAbsolutePath(), jarEntry.getName())));
                    int i = 0;
                    while ((i = in.read(buffer)) != -1) {
                        ((BufferedOutputStream)outputStream).write(buffer, 0, i);
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception i) {}
                    }
                    if (outputStream == null) continue;
                    try {
                        outputStream.close();
                    }
                    catch (Exception i) {}
                }
            }
            File configDir = new File(domainDir, "config");
            DomainSecurity domainSecurity = this.processDomainSecurity(configDir);
            CustomTokenClient tokenClient = new CustomTokenClient(this.domainConfig);
            Map<String, String> generatedTokens = tokenClient.getSubstitutableTokens();
            if (this.domainTemplate.hasStringsubs()) {
                StringSubstitutor substitutor = this.domainTemplate.getStringSubs();
                Map<String, String> lookUpMap = SubstitutableTokens.getSubstitutableTokens(this.domainConfig);
                lookUpMap.putAll(generatedTokens);
                substitutor.setAttributePreprocessor(new AttributePreprocessorImpl(lookUpMap));
                substitutor.substituteAll();
            }
            try {
                File binDir = new File(domainDir, "bin");
                if (binDir.exists() && binDir.isDirectory()) {
                    domainSecurity.changeMode("-R u+x ", binDir);
                }
                domainSecurity.changeMode("-R g-rwx,o-rwx ", configDir);
            }
            catch (Exception e) {
                throw new DomainException(STRINGS.get("setPermissionError"), e);
            }
            DomainInfoManager domainInfoManager = new DomainInfoManager();
            domainInfoManager.process(this.domainTemplate, domainDir);
        }
        catch (DomainException de) {
            FileUtils.liquidate((File)domainDir);
            throw de;
        }
        catch (Exception ex) {
            FileUtils.liquidate((File)domainDir);
            throw new DomainException(ex);
        }
    }

    private void createDirectory(File dir) throws RepositoryException {
        if (!dir.exists()) {
            try {
                if (!dir.mkdirs()) {
                    throw new RepositoryException(STRINGS.get("directoryCreationError", new Object[]{dir}));
                }
            }
            catch (Exception e) {
                throw new RepositoryException(STRINGS.get("directoryCreationError", new Object[]{dir}), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainSecurity processDomainSecurity(File configDir) throws IOException, RepositoryException {
        String user = (String)this.domainConfig.get("domain.user");
        String password = (String)this.domainConfig.get("domain.password");
        String[] adminUserGroups = ((String)this.domainConfig.get("domain.admin.groups")).split(",");
        String masterPassword = (String)this.domainConfig.get("domain.masterPassword");
        Boolean saveMasterPassword = (Boolean)this.domainConfig.get("domain.saveMasterPassword");
        DomainSecurity domainSecurity = new DomainSecurity();
        domainSecurity.processAdminKeyFile(new File(configDir, "admin-keyfile"), user, password, adminUserGroups);
        try {
            domainSecurity.createSSLCertificateDatabase(configDir, this.domainConfig, masterPassword);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, STRINGS.getString("SomeProblemWithKeytool", e.getMessage()));
            try (FileOutputStream fos = null;){
                File keystoreFile = new File(configDir, "keystore.jks");
                fos = new FileOutputStream(keystoreFile);
                fos.write(this.keystoreBytes);
            }
        }
        domainSecurity.changeMasterPasswordInMasterPasswordFile(new File(configDir, "master-password"), masterPassword, (boolean)saveMasterPassword);
        domainSecurity.createPasswordAliasKeystore(new File(configDir, "domain-passwords"), masterPassword);
        return domainSecurity;
    }
}

