/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.controller;

import fish.payara.security.openid.OpenIdUtil;
import fish.payara.security.openid.api.OpenIdState;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.openid.http.HttpStorageController;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ApplicationScoped
public class StateController {
    private static final String STATE_KEY = "oidc.state";
    @Inject
    OpenIdConfiguration configuration;

    public void store(OpenIdState state, OpenIdConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        HttpStorageController storage = HttpStorageController.getInstance(configuration, request, response);
        storage.store(STATE_KEY, state.getValue(), null);
        storage.store("oidc.original.request", StateController.getFullURL(request), null);
    }

    private static String getFullURL(HttpServletRequest request) {
        StringBuilder requestURL = new StringBuilder(request.getRequestURL().toString());
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }

    public Optional<OpenIdState> get(HttpServletRequest request, HttpServletResponse response) {
        return HttpStorageController.getInstance(this.configuration, request, response).getAsString(STATE_KEY).filter(OpenIdUtil.not(OpenIdUtil::isEmpty)).map(OpenIdState::new);
    }

    public void remove(HttpServletRequest request, HttpServletResponse response) {
        HttpStorageController.getInstance(this.configuration, request, response).remove(STATE_KEY);
    }
}

