/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.controller;

import fish.payara.security.openid.api.IdentityToken;
import fish.payara.security.openid.api.RefreshToken;
import fish.payara.security.openid.controller.AccessTokenClaimsSetVerifier;
import fish.payara.security.openid.controller.IdTokenClaimsSetVerifier;
import fish.payara.security.openid.controller.JWTValidator;
import fish.payara.security.openid.controller.NonceController;
import fish.payara.security.openid.controller.RefreshedIdTokenClaimsSetVerifier;
import fish.payara.security.openid.domain.AccessTokenImpl;
import fish.payara.security.openid.domain.IdentityTokenImpl;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.openid.domain.OpenIdNonce;
import fish.payara.security.shaded.nimbusds.jose.Algorithm;
import fish.payara.security.shaded.nimbusds.jwt.JWTClaimsSet;
import java.util.Collections;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;

@ApplicationScoped
public class TokenController {
    @Inject
    private NonceController nonceController;
    @Inject
    OpenIdConfiguration configuration;
    @Inject
    JWTValidator validator;

    public Response getTokens(HttpServletRequest request) {
        String authorizationCode = request.getParameter("code");
        Form form = new Form().param("client_id", this.configuration.getClientId()).param("client_secret", new String(this.configuration.getClientSecret())).param("grant_type", "authorization_code").param("code", authorizationCode).param("redirect_uri", this.configuration.buildRedirectURI(request));
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(this.configuration.getProviderMetadata().getTokenEndpoint());
        return target.request().accept(new String[]{"application/json"}).post(Entity.form((Form)form));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JWTClaimsSet validateIdToken(IdentityTokenImpl idToken, HttpMessageContext httpContext) {
        JWTClaimsSet claimsSet;
        HttpServletRequest request = httpContext.getRequest();
        HttpServletResponse response = httpContext.getResponse();
        String expectedNonceHash = null;
        if (this.configuration.isUseNonce()) {
            OpenIdNonce expectedNonce = this.nonceController.get(this.configuration, request, response);
            expectedNonceHash = this.nonceController.getNonceHash(expectedNonce);
        }
        try {
            IdTokenClaimsSetVerifier jwtVerifier = new IdTokenClaimsSetVerifier(expectedNonceHash, this.configuration);
            claimsSet = this.validator.validateBearerToken(idToken.getTokenJWT(), jwtVerifier);
        }
        finally {
            this.nonceController.remove(this.configuration, request, response);
        }
        return claimsSet;
    }

    public JWTClaimsSet validateRefreshedIdToken(IdentityToken previousIdToken, IdentityTokenImpl newIdToken) {
        RefreshedIdTokenClaimsSetVerifier jwtVerifier = new RefreshedIdTokenClaimsSetVerifier(previousIdToken, this.configuration);
        JWTClaimsSet claimsSet = this.validator.validateBearerToken(newIdToken.getTokenJWT(), jwtVerifier);
        return claimsSet;
    }

    public Map<String, Object> validateAccessToken(AccessTokenImpl accessToken, Algorithm idTokenAlgorithm, Map<String, Object> idTokenClaims) {
        Map<String, Object> claims = Collections.emptyMap();
        AccessTokenClaimsSetVerifier jwtVerifier = new AccessTokenClaimsSetVerifier(accessToken, idTokenAlgorithm, idTokenClaims, this.configuration);
        jwtVerifier.validateAccessToken();
        return claims;
    }

    public Response refreshTokens(RefreshToken refreshToken) {
        Form form = new Form().param("client_id", this.configuration.getClientId()).param("client_secret", new String(this.configuration.getClientSecret())).param("grant_type", "refresh_token").param("refresh_token", refreshToken.getToken());
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(this.configuration.getProviderMetadata().getTokenEndpoint());
        return target.request().accept(new String[]{"application/json"}).post(Entity.form((Form)form));
    }
}

