/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.http;

import fish.payara.security.openid.OpenIdUtil;
import fish.payara.security.openid.http.HttpStorageController;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieController
implements HttpStorageController {
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public CookieController(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    @Override
    public void store(String name, String value, Integer maxAge) {
        Cookie cookie = new Cookie(name, value);
        if (maxAge != null) {
            cookie.setMaxAge(maxAge.intValue());
        }
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        String contextPath = this.request.getContextPath();
        cookie.setPath(OpenIdUtil.isEmpty(contextPath) ? "/" : contextPath);
        this.response.addCookie(cookie);
    }

    public Optional<Cookie> get(String name) {
        if (this.request.getCookies() != null) {
            for (Cookie cookie : this.request.getCookies()) {
                if (!name.equals(cookie.getName()) || !Objects.nonNull(cookie.getValue()) || cookie.getValue().trim().isEmpty()) continue;
                return Optional.of(cookie);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getAsString(String name) {
        return this.get(name).map(Cookie::getValue);
    }

    @Override
    public void remove(String name) {
        this.store(name, null, 0);
    }
}

