/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.shaded.nimbusds.jose.crypto;

import fish.payara.security.shaded.jcip.annotations.ThreadSafe;
import fish.payara.security.shaded.nimbusds.jose.EncryptionMethod;
import fish.payara.security.shaded.nimbusds.jose.JOSEException;
import fish.payara.security.shaded.nimbusds.jose.JWEAlgorithm;
import fish.payara.security.shaded.nimbusds.jose.JWECryptoParts;
import fish.payara.security.shaded.nimbusds.jose.JWEEncrypter;
import fish.payara.security.shaded.nimbusds.jose.JWEHeader;
import fish.payara.security.shaded.nimbusds.jose.KeyLengthException;
import fish.payara.security.shaded.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import fish.payara.security.shaded.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import fish.payara.security.shaded.nimbusds.jose.crypto.impl.DirectCryptoProvider;
import fish.payara.security.shaded.nimbusds.jose.jwk.OctetSequenceKey;
import fish.payara.security.shaded.nimbusds.jose.util.Base64URL;
import fish.payara.security.shaded.nimbusds.jose.util.ByteUtils;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

@ThreadSafe
public class DirectEncrypter
extends DirectCryptoProvider
implements JWEEncrypter {
    public DirectEncrypter(SecretKey key) throws KeyLengthException {
        super(key);
    }

    public DirectEncrypter(byte[] keyBytes) throws KeyLengthException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public DirectEncrypter(OctetSequenceKey octJWK) throws KeyLengthException {
        this(octJWK.toSecretKey("AES"));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        JWEAlgorithm alg = header.getAlgorithm();
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        EncryptionMethod enc = header.getEncryptionMethod();
        if (enc.cekBitLength() != ByteUtils.safeBitLength(this.getKey().getEncoded())) {
            throw new KeyLengthException(enc.cekBitLength(), enc);
        }
        Base64URL encryptedKey = null;
        return ContentCryptoProvider.encrypt(header, clearText, this.getKey(), encryptedKey, this.getJCAContext());
    }
}

