/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import fish.payara.internal.notification.TimeUtil;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.notification.healthcheck.HealthCheckResultEntry;
import fish.payara.notification.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckWithThresholdExecutionOptions;
import fish.payara.nucleus.healthcheck.configuration.CpuUsageChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseThresholdHealthCheck;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-cpu")
@RunLevel(value=10)
public class CpuUsageHealthCheck
extends BaseThresholdHealthCheck<HealthCheckWithThresholdExecutionOptions, CpuUsageChecker>
implements MonitoringDataSource,
MonitoringWatchSource {
    private final CpuUsage healthCheck = new CpuUsage();
    private final CpuUsage collect = new CpuUsage();

    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, CpuUsageChecker.class);
    }

    @Override
    public HealthCheckWithThresholdExecutionOptions constructOptions(CpuUsageChecker checker) {
        return super.constructThresholdOptions(checker);
    }

    @Override
    protected String getDescription() {
        return "healthcheck.description.cpu";
    }

    @Override
    protected HealthCheckResult doCheckInternal() {
        HealthCheckResult result = new HealthCheckResult();
        try {
            double percentage = this.healthCheck.percentage();
            result.add(new HealthCheckResultEntry(this.decideOnStatusWithRatio(percentage), "CPU%: " + new DecimalFormat("#.00").format(percentage) + ", Time CPU used: " + TimeUtil.prettyPrintDuration((long)TimeUnit.NANOSECONDS.toMillis(this.healthCheck.getLastTimeDelta()))));
        }
        catch (UnsupportedOperationException ex) {
            result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CHECK_ERROR, "JVM implementation or OS does not support getting CPU times"));
            return result;
        }
        return result;
    }

    @MonitoringData(ns="health", intervalSeconds=4)
    public void collect(MonitoringDataCollector collector) {
        if (this.options != null && ((HealthCheckWithThresholdExecutionOptions)this.options).isEnabled()) {
            collector.collect((CharSequence)"CpuUsage", (long)((int)this.collect.percentage()));
        }
    }

    public void collect(MonitoringWatchCollector collector) {
        this.collectUsage(collector, "ns:health CpuUsage", "CPU Usage", 15, true);
    }

    private static final class CpuUsage {
        private volatile long nanotimeBefore = System.nanoTime();
        private volatile long totalCpuNanosBefore = 0L;
        private volatile long timeDelta;

        CpuUsage() {
        }

        double percentage() {
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            if (!threadBean.isCurrentThreadCpuTimeSupported()) {
                throw new UnsupportedOperationException("CurrentThreadCpuTimeSupported not supported.");
            }
            long currentThreadId = Thread.currentThread().getId();
            long totalCpuNanos = 0L;
            for (long id : threadBean.getAllThreadIds()) {
                long threadCpuTime;
                if (id == currentThreadId || (threadCpuTime = threadBean.getThreadCpuTime(id)) < 0L) continue;
                totalCpuNanos += threadCpuTime;
            }
            long nanotime = System.nanoTime();
            this.timeDelta = nanotime - this.nanotimeBefore;
            long cpuTimeDelta = totalCpuNanos - this.totalCpuNanosBefore;
            double percentage = Math.max(0.0, Math.min(100.0, 100.0 * (double)cpuTimeDelta / (double)this.timeDelta));
            this.totalCpuNanosBefore = totalCpuNanos;
            this.nanotimeBefore = nanotime;
            return percentage;
        }

        long getLastTimeDelta() {
            return this.timeDelta;
        }
    }
}

