/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.aws;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fish.payara.microprofile.config.extensions.aws.AWSSecretsConfigSourceConfiguration;
import fish.payara.microprofile.config.extensions.aws.client.AwsRequestBuilder;
import fish.payara.nucleus.microprofile.config.source.extension.ConfiguredExtensionConfigSource;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.stream.JsonParser;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;
import org.glassfish.config.support.TranslatedConfigView;
import org.jvnet.hk2.annotations.Service;

@Service(name="aws-secrets-config-source")
public class AWSSecretsConfigSource
extends ConfiguredExtensionConfigSource<AWSSecretsConfigSourceConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(AWSSecretsConfigSource.class.getName());
    private final ObjectMapper mapper = new ObjectMapper();
    private AwsRequestBuilder builder;
    @Inject
    MicroprofileConfigConfiguration mpconfig;

    public void bootstrap() {
        try {
            String accessKeyId = TranslatedConfigView.getRealPasswordFromAlias((String)"${ALIAS=AWS_ACCESS_KEY_ID}");
            String secretAccessKey = TranslatedConfigView.getRealPasswordFromAlias((String)"${ALIAS=AWS_SECRET_ACCESS_KEY}");
            this.builder = AwsRequestBuilder.builder(accessKeyId, secretAccessKey).region(((AWSSecretsConfigSourceConfiguration)this.configuration).getRegionName()).serviceName("secretsmanager").version("2017-10-17").ContentType("application/x-amz-json-1.1").method("POST").data(Json.createObjectBuilder().add("SecretId", ((AWSSecretsConfigSourceConfiguration)this.configuration).getSecretName()).build());
        }
        catch (IllegalArgumentException ex) {
            AWSSecretsConfigSource.printMisconfigurationMessage();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            LOGGER.log(Level.WARNING, "Unable to get value from password aliases", ex);
        }
    }

    public void destroy() {
        this.builder = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> getProperties() {
        if (this.builder == null) {
            AWSSecretsConfigSource.printMisconfigurationMessage();
            return new HashMap<String, String>();
        }
        Response response = this.builder.action("GetSecretValue").build().invoke();
        if (response.getStatus() != 200) {
            LOGGER.log(Level.WARNING, "Failed to get AWS secret. {0}", response.readEntity(String.class));
            return new HashMap<String, String>();
        }
        try {
            String secretString = AWSSecretsConfigSource.readSecretString((InputStream)response.getEntity());
            try (StringReader reader = new StringReader(secretString);){
                Map<String, String> map = this.readMap(reader);
                return map;
            }
        }
        catch (IOException | JsonException | ProcessingException ex) {
            LOGGER.log(Level.WARNING, "Unable to read secret value", ex);
        }
        return new HashMap<String, String>();
    }

    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    public String getValue(String propertyName) {
        if (this.builder == null) {
            AWSSecretsConfigSource.printMisconfigurationMessage();
            return null;
        }
        return this.getProperties().get(propertyName);
    }

    public boolean deleteValue(String value) {
        return this.modifySecret("DELETE", value, null);
    }

    public boolean setValue(String key, String value) {
        return this.modifySecret("POST", key, value);
    }

    public String getSource() {
        return "cloud";
    }

    public String getName() {
        return "aws";
    }

    public int getOrdinal() {
        return Integer.parseInt(this.mpconfig.getCloudOrdinality());
    }

    private boolean modifySecret(String method, String key, String value) {
        if (this.builder == null) {
            AWSSecretsConfigSource.printMisconfigurationMessage();
            return false;
        }
        Map<String, String> properties = this.getProperties();
        switch (method) {
            case "POST": {
                properties.put(key, value);
                break;
            }
            case "DELETE": {
                if (properties.remove(key) != null) break;
                return false;
            }
            default: {
                throw new IllegalArgumentException("Unsupported HTTP method");
            }
        }
        Response response = this.builder.action("UpdateSecret").data(Json.createObjectBuilder().add("ClientRequestToken", UUID.randomUUID().toString()).add("SecretId", ((AWSSecretsConfigSourceConfiguration)this.configuration).getSecretName()).add("SecretString", Json.createObjectBuilder(properties).build().toString()).build()).build().invoke();
        if (response.getStatus() != 200) {
            LOGGER.log(Level.WARNING, "Failed to modify AWS secret. {0}", response.readEntity(String.class));
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readSecretString(InputStream input) {
        try (JsonParser parser = Json.createParser((InputStream)input);){
            block17: {
                while (parser.hasNext()) {
                    JsonParser.Event parseEvent = parser.next();
                    if (parseEvent != JsonParser.Event.KEY_NAME) continue;
                    String keyName = parser.getString();
                    parser.next();
                    if (!"SecretString".equals(keyName)) {
                        continue;
                    }
                    break block17;
                }
                return null;
            }
            String string = parser.getString();
            return string;
        }
    }

    private Map<String, String> readMap(Reader input) throws JsonParseException, JsonMappingException, IOException {
        return (Map)this.mapper.readValue(input, (TypeReference)new TypeReference<Map<String, String>>(){});
    }

    private static void printMisconfigurationMessage() {
        LOGGER.warning("AWS Secrets Config Source isn't configured correctly. Make sure that the password aliases AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY exist.");
    }
}

