/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.data;

import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.data.MonitoringAnnotationConsumer;
import fish.payara.monitoring.data.MonitoringDataConsumer;
import fish.payara.monitoring.model.Series;

public class ConsumingMonitoringDataCollector
implements MonitoringDataCollector {
    private final MonitoringDataConsumer dataConsumer;
    private final MonitoringAnnotationConsumer annotationConsumer;
    private final StringBuilder tags;

    public ConsumingMonitoringDataCollector(MonitoringDataConsumer dataConsumer, MonitoringAnnotationConsumer annotationConsumer) {
        this(dataConsumer, annotationConsumer, new StringBuilder());
    }

    private ConsumingMonitoringDataCollector(MonitoringDataConsumer consumer, MonitoringAnnotationConsumer annotationConsumer, StringBuilder tags) {
        this.dataConsumer = consumer;
        this.annotationConsumer = annotationConsumer;
        this.tags = tags;
    }

    public MonitoringDataCollector collect(CharSequence metric, long value) {
        int length = this.tags.length();
        ConsumingMonitoringDataCollector.appendMetricName(this.tags, metric);
        this.dataConsumer.accept(this.tags, value);
        this.tags.setLength(length);
        return this;
    }

    public MonitoringDataCollector annotate(CharSequence metric, long value, boolean keyed, String ... attrs) {
        int length = this.tags.length();
        ConsumingMonitoringDataCollector.appendMetricName(this.tags, metric);
        this.annotationConsumer.accept(this.tags, value, keyed, attrs);
        this.tags.setLength(length);
        return this;
    }

    public MonitoringDataCollector tag(CharSequence name, CharSequence value) {
        if (value == null || value.length() == 0) {
            return this;
        }
        StringBuilder tagged = new StringBuilder(this.tags);
        int nameIndex = this.indexOf(name);
        if (nameIndex >= 0) {
            tagged.setLength(nameIndex);
        } else if (tagged.length() > 0) {
            tagged.append(' ');
        }
        tagged.append(name).append(':');
        ConsumingMonitoringDataCollector.appendTagValue(value, tagged);
        return new ConsumingMonitoringDataCollector(this.dataConsumer, this.annotationConsumer, tagged);
    }

    private static void appendMetricName(StringBuilder tags, CharSequence key) {
        if (tags.length() > 0) {
            tags.append(' ');
        }
        tags.append(key);
    }

    private static void appendTagValue(CharSequence value, StringBuilder tagged) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!Series.isSpecialTagCharacter(c)) {
                tagged.append(c);
                continue;
            }
            tagged.append('_');
        }
    }

    private int indexOf(CharSequence name) {
        String tag = name.toString();
        if (this.tags.indexOf(tag + ':') == 0) {
            return 0;
        }
        int idx = this.tags.indexOf(' ' + tag + ':');
        return idx < 0 ? idx : idx + 1;
    }
}

