/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.model;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public abstract class AggregateDataset<T extends AggregateDataset<T>> {
    private final long[] mins;
    private final long[] maxs;
    private final double[] avgs;
    private final int[] points;
    private final long firstTime;
    protected final int offset;
    private int size;

    protected AggregateDataset() {
        this.mins = new long[0];
        this.maxs = new long[0];
        this.avgs = new double[0];
        this.points = new int[0];
        this.firstTime = -1L;
        this.offset = -1;
        this.size = 0;
    }

    protected AggregateDataset(int windowSize, AggregateDataset<T> predecessor, long time) {
        int requiredSize;
        boolean empty = predecessor.isEmpty();
        int n = requiredSize = empty ? 1 : super.indexOf(time) + 1;
        if (!empty && time < predecessor.lastTime()) {
            throw new IllegalArgumentException("Cannot set data in the past");
        }
        int availableSize = empty ? 0 : predecessor.capacity() - predecessor.offset;
        int requiredSizeInc = requiredSize - predecessor.size;
        this.size = Math.min(windowSize, requiredSize);
        if (requiredSize <= availableSize) {
            int lastIndex = predecessor.lastIndex() + requiredSizeInc;
            this.mins = predecessor.mins;
            this.maxs = predecessor.maxs;
            this.avgs = predecessor.avgs;
            this.points = predecessor.points;
            this.offset = Math.max(predecessor.offset, lastIndex + 1 - windowSize);
            this.firstTime = predecessor.getTime(this.offset);
        } else {
            int newCapacity = empty ? windowSize : windowSize * 2;
            this.mins = new long[newCapacity];
            this.maxs = new long[newCapacity];
            this.avgs = new double[newCapacity];
            this.points = new int[newCapacity];
            int copyLength = Math.min(predecessor.size, windowSize - 1);
            int from = predecessor.lastIndex() - copyLength + 1;
            AggregateDataset<T> src = predecessor;
            System.arraycopy(src.mins, from, this.mins, 0, copyLength);
            System.arraycopy(src.maxs, from, this.maxs, 0, copyLength);
            System.arraycopy(src.avgs, from, this.avgs, 0, copyLength);
            System.arraycopy(src.points, from, this.points, 0, copyLength);
            this.offset = 0;
            this.firstTime = predecessor.isEmpty() ? time : predecessor.getTime(from);
        }
    }

    private int indexOf(long time) {
        return (int)((time - this.getTime(this.firstIndex())) / this.getIntervalLength());
    }

    protected AggregateDataset(AggregateDataset<T> predecessor) {
        this.mins = predecessor.mins;
        this.maxs = predecessor.maxs;
        this.avgs = predecessor.avgs;
        this.points = predecessor.points;
        this.size = predecessor.size;
        this.offset = predecessor.offset + 1;
        this.firstTime = predecessor.getTime(predecessor.firstIndex() + 1);
    }

    protected final void setEntry(int points, long min, long max, double avg) {
        int index = this.lastIndex();
        this.points[index] = points;
        this.mins[index] = min;
        this.maxs[index] = max;
        this.avgs[index] = avg;
    }

    public final long getMinimum(int index) {
        return this.mins[index];
    }

    public final long getMaximum(int index) {
        return this.maxs[index];
    }

    public final double getAverage(int index) {
        return this.avgs[index];
    }

    public final int getNumberOfPoints(int index) {
        return this.points[index];
    }

    public final long firstTime() {
        return this.firstTime;
    }

    public final long lastTime() {
        return this.getTime(this.lastIndex());
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int size() {
        return this.size;
    }

    public final int capacity() {
        return this.points.length;
    }

    public final int firstIndex() {
        return this.offset;
    }

    public final int lastIndex() {
        return this.capacity() == 0 ? -1 : (this.offset + this.size - 1) % this.capacity();
    }

    public final boolean isWrapped() {
        return this.offset + this.size >= this.capacity();
    }

    public final long getTime(int index) {
        if (index < this.offset) {
            throw new IllegalArgumentException("No data availabel for absolute index");
        }
        return this.firstTime() + (long)(index - this.offset) * this.getIntervalLength();
    }

    public abstract long getIntervalLength();

    public long[] mins() {
        return this.copy(this.mins, new long[this.size]);
    }

    public long[] maxs() {
        return this.copy(this.maxs, new long[this.size]);
    }

    public double[] avgs() {
        return this.copy(this.avgs, new double[this.size]);
    }

    public int[] numberOfPoints() {
        return this.copy(this.points, new int[this.size]);
    }

    private <A> A copy(A src, A dest) {
        System.arraycopy(src, this.firstIndex(), dest, 0, this.size);
        return dest;
    }

    public int estimatedBytesMemory() {
        return this.size * 8 * 3 + this.size * 4 + 16;
    }

    public String toString() {
        String str = this.getClass().getSimpleName() + "[" + this.size() + "]";
        if (!this.isEmpty()) {
            DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
            str = str + "[" + formatter.format(Instant.ofEpochMilli(this.firstTime()).atOffset(ZoneOffset.UTC)) + "-" + formatter.format(Instant.ofEpochMilli(this.lastTime()).atOffset(ZoneOffset.UTC)) + "]";
        }
        return str;
    }
}

