/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.cdi;

import fish.payara.microprofile.faulttolerance.FaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.FaultToleranceService;
import fish.payara.microprofile.faulttolerance.policy.FaultTolerancePolicy;
import fish.payara.microprofile.faulttolerance.service.Stereotypes;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.control.RequestContextController;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;
import org.glassfish.internal.api.Globals;

@Dependent
public class FaultToleranceInterceptor
implements Stereotypes,
Serializable {
    private static final Logger logger = Logger.getLogger(FaultToleranceInterceptor.class.getName());
    @Inject
    private BeanManager beanManager;
    @Inject
    private Instance<RequestContextController> requestContextControllerInstance;
    private FaultToleranceService faultToleranceService;
    protected static final String PAYARA_FAULT_TOLERANCE_INTERCEPTOR_EXECUTED = "fish.payara.microprofile.faulttolerance.executed";

    public Object intercept(InvocationContext context) throws Exception {
        if (!this.shouldIntercept(context)) {
            return context.proceed();
        }
        context.getContextData().put(PAYARA_FAULT_TOLERANCE_INTERCEPTOR_EXECUTED, Boolean.TRUE);
        try {
            this.initialize();
            AtomicReference lazyConfig = new AtomicReference();
            Supplier<FaultToleranceConfig> configSupplier = () -> (FaultToleranceConfig)lazyConfig.updateAndGet(value -> value != null ? value : this.faultToleranceService.getConfig(context, this));
            FaultTolerancePolicy policy = FaultTolerancePolicy.get(context, configSupplier);
            if (policy.isPresent) {
                return policy.proceed(context, () -> this.faultToleranceService.getMethodContext(context, policy, this.getRequestContextController()));
            }
        }
        catch (FaultToleranceDefinitionException e) {
            logger.log(Level.SEVERE, "Effective FT policy contains illegal values, fault tolerance cannot be applied, falling back to plain method invocation.", e);
        }
        return context.proceed();
    }

    private void initialize() {
        if (this.faultToleranceService != null) {
            return;
        }
        this.faultToleranceService = (FaultToleranceService)Globals.getDefaultBaseServiceLocator().getService(FaultToleranceService.class, new Annotation[0]);
    }

    private RequestContextController getRequestContextController() {
        return this.requestContextControllerInstance.isResolvable() ? (RequestContextController)this.requestContextControllerInstance.get() : null;
    }

    @Override
    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        return this.beanManager.isStereotype(annotationType);
    }

    @Override
    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        return this.beanManager.getStereotypeDefinition(stereotype);
    }

    protected boolean shouldIntercept(InvocationContext invocationContext) throws Exception {
        Map contextData = invocationContext.getContextData();
        return contextData.get(PAYARA_FAULT_TOLERANCE_INTERCEPTOR_EXECUTED) == null || (Boolean)contextData.get(PAYARA_FAULT_TOLERANCE_INTERCEPTOR_EXECUTED) == false;
    }
}

