/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.service;

import fish.payara.microprofile.faulttolerance.service.Stereotypes;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Annotated;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class FaultToleranceUtils {
    private static final Logger logger = Logger.getLogger(FaultToleranceUtils.class.getName());

    public static <A extends Annotation> A getAnnotation(Stereotypes sterotypes, Class<A> annotationClass, InvocationContext context) {
        logger.log(Level.FINER, "Attempting to get annotation {0} from {1}", new String[]{annotationClass.getSimpleName(), context.getMethod().getName()});
        if (context.getMethod().isAnnotationPresent(annotationClass)) {
            logger.log(Level.FINER, "Annotation was directly present on the method");
            return context.getMethod().getAnnotation(annotationClass);
        }
        Class<?> annotatedClass = FaultToleranceUtils.getAnnotatedMethodClass(context, annotationClass);
        if (annotatedClass.isAnnotationPresent(annotationClass)) {
            logger.log(Level.FINER, "Annotation was directly present on the class");
            return annotatedClass.getAnnotation(annotationClass);
        }
        if (sterotypes == null) {
            return null;
        }
        logger.log(Level.FINER, "Annotation wasn't directly present on the method or class, checking stereotypes");
        for (Annotation annotation : annotatedClass.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType == annotationClass) {
                logger.log(Level.FINER, "Annotation was found in a stereotype");
                return (A)((Annotation)annotationClass.cast(annotation));
            }
            if (!sterotypes.isStereotype(annotationType)) continue;
            for (Annotation metaAnnotation : sterotypes.getStereotypeDefinition(annotationType)) {
                if (metaAnnotation.annotationType() != annotationClass) continue;
                logger.log(Level.FINER, "Annotation was found in a stereotype");
                return (A)((Annotation)annotationClass.cast(metaAnnotation));
            }
        }
        return null;
    }

    public static <A extends Annotation, T> T getOverrideValue(Config config, Class<A> annotationType, String parameterName, InvocationContext context, Class<T> parameterType, T defaultValue) {
        return FaultToleranceUtils.getOverrideValue(config, context, annotationType, parameterName, parameterType, defaultValue, true);
    }

    public static <A extends Annotation> boolean getEnabledOverrideValue(Config config, Class<A> annotationType, InvocationContext context, boolean defaultValue) {
        return FaultToleranceUtils.getOverrideValue(config, context, annotationType, "enabled", Boolean.class, defaultValue, false);
    }

    private static <T, A extends Annotation> T getOverrideValue(Config config, InvocationContext context, Class<A> annotationType, String propertyName, Class<T> resultType, T defaultValue, boolean requiresAnnotation) {
        Class<?> targetClass = FaultToleranceUtils.getAnnotatedMethodClass(context, annotationType);
        String annotationName = annotationType.getSimpleName();
        String methodName = context.getMethod().getName();
        String className = FaultToleranceUtils.getPlainCanonicalName(targetClass);
        String key = String.format("%s/%s/%s/%s", className, methodName, annotationName, propertyName);
        Optional overrideValue = config.getOptionalValue(key, resultType);
        boolean methodAnnotated = context.getMethod().isAnnotationPresent(annotationType);
        if (overrideValue.isPresent() && (!requiresAnnotation || methodAnnotated)) {
            return overrideValue.get();
        }
        if (!(requiresAnnotation && methodAnnotated || !(overrideValue = config.getOptionalValue(key = String.format("%s/%s/%s", className, annotationName, propertyName), resultType)).isPresent() || requiresAnnotation && !targetClass.isAnnotationPresent(annotationType))) {
            return overrideValue.get();
        }
        key = String.format("%s/%s", annotationName, propertyName);
        overrideValue = config.getOptionalValue(key, resultType);
        return overrideValue.orElse(defaultValue);
    }

    public static <A extends Annotation> Class<?> getAnnotatedMethodClass(InvocationContext context, Class<A> annotationClass) {
        Class<?> targetClass = context.getTarget().getClass();
        if (targetClass.isAnnotationPresent(annotationClass)) {
            return targetClass;
        }
        return context.getMethod().getDeclaringClass();
    }

    public static <A extends Annotation> String getPlainCanonicalName(Class<?> type) {
        String canonicalName = type.getCanonicalName();
        if (canonicalName.contains("$Proxy$_$$_WeldSubclass")) {
            return canonicalName.split("\\$Proxy\\$_\\$\\$_WeldSubclass")[0];
        }
        return canonicalName;
    }

    public static String getCanonicalMethodName(InvocationContext context) {
        return FaultToleranceUtils.getPlainCanonicalName(context.getMethod().getDeclaringClass()) + "." + context.getMethod().getName();
    }

    public static boolean isAnnotatedWithFaultToleranceAnnotations(Annotated element) {
        return element.isAnnotationPresent(Asynchronous.class) || element.isAnnotationPresent(Bulkhead.class) || element.isAnnotationPresent(CircuitBreaker.class) || element.isAnnotationPresent(Fallback.class) || element.isAnnotationPresent(Retry.class) || element.isAnnotationPresent(Timeout.class);
    }

    public static <T> Class<? extends T>[] toClassArray(String classNames, String attributeName, Class<? extends T>[] defaultValue) {
        if (classNames == null) {
            return defaultValue;
        }
        try {
            ArrayList classList = new ArrayList();
            for (String className : classNames.replaceAll("[\\{\\[ \\]\\}]", "").replaceAll("\\.class", "").split(",")) {
                classList.add(Class.forName(className, false, Thread.currentThread().getContextClassLoader()));
            }
            return classList.toArray(defaultValue);
        }
        catch (ClassNotFoundException cnfe) {
            logger.log(Level.INFO, "Could not find class from " + attributeName + " config, defaulting to annotation. Make sure you give the full canonical class name.", cnfe);
            return defaultValue;
        }
    }
}

