/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.DefaultAnnotationScanner;
import com.sun.enterprise.deployment.util.DOLUtils;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import javax.inject.Inject;
import org.glassfish.apf.Scanner;
import org.glassfish.apf.impl.JavaEEScanner;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.logging.annotation.LogMessageInfo;

public abstract class ModuleScanner<T>
extends JavaEEScanner
implements Scanner<T> {
    private static final int DEFAULT_ENTRY_BUFFER_SIZE = 8192;
    @Inject
    DefaultAnnotationScanner defaultScanner;
    protected File archiveFile = null;
    protected ClassLoader classLoader = null;
    protected Parser classParser = null;
    private Set<URI> scannedURI = new HashSet<URI>();
    private boolean needScanAnnotation = false;
    @Inject
    PayaraExecutorService executorService;
    private Set<String> entries = new HashSet<String>();
    public static final Logger deplLogger = DOLUtils.deplLogger;
    @LogMessageInfo(message="Exception caught during annotation scanning.", cause="An exception was caught that indicates that the annotation is incorrect.", action="Correct the annotation.", level="SEVERE")
    private static final String ANNOTATION_SCANNING_EXCEPTION = "AS-DEPLOYMENT-00005";
    @LogMessageInfo(message="Adding {0} since {1} is annotated with {2}.", level="INFO")
    private static final String ANNOTATION_ADDED = "AS-DEPLOYMENT-00006";
    @LogMessageInfo(message="Adding {0} since it is implementing {1}.", level="INFO")
    private static final String INTERFACE_ADDED = "AS-DEPLOYMENT-00007";
    @LogMessageInfo(message="Inconsistent type definition.  {0} is neither an annotation nor an interface.", cause="The annotation is incorrect.", action="Correct the annotation.", level="SEVERE")
    private static final String INCORRECT_ANNOTATION = "AS-DEPLOYMENT-00008";
    @LogMessageInfo(message="The exception {0} occurred while examining the jar at file path:  {1}.", level="WARNING")
    private static final String JAR_EXCEPTION = "AS-DEPLOYMENT-00009";
    @LogMessageInfo(message="No classloader can be found to use", cause="The archive being processed is not correct.", action="Examine the archive to determine what is incorrect.", level="SEVERE")
    private static final String NO_CLASSLOADER = "AS-DEPLOYMENT-00010";
    @LogMessageInfo(message="Error in annotation processing: {0}.", level="WARNING")
    private static final String ANNOTATION_ERROR = "AS-DEPLOYMENT-00011";
    @LogMessageInfo(message="Cannot load {0}  reason : {1}.", level="WARNING")
    private static final String CLASSLOADING_ERROR = "AS-DEPLOYMENT-00012";
    @LogMessageInfo(message="An exception was caught during library jar processing:  {0}.", level="WARNING")
    private static final String LIBRARY_JAR_ERROR = "AS-DEPLOYMENT-00013";

    public void process(ReadableArchive archiveFile, T bundleDesc, ClassLoader classLoader, Parser parser) throws IOException {
        File file = new File(archiveFile.getURI());
        this.setParser(parser);
        this.process(file, bundleDesc, classLoader);
        this.completeProcess(bundleDesc, archiveFile);
        this.calculateResults(bundleDesc);
    }

    protected void completeProcess(T bundleDescr, ReadableArchive archive) throws IOException {
        this.addLibraryJars(bundleDescr, archive);
    }

    protected void calculateResults(T bundleDesc) {
        try {
            this.classParser.awaitTermination();
        }
        catch (InterruptedException e) {
            deplLogger.log(Level.SEVERE, ANNOTATION_SCANNING_EXCEPTION, e);
            return;
        }
        Level logLevel = System.getProperty("glassfish.deployment.dump.scanning") != null ? Level.INFO : Level.FINE;
        boolean shouldLog = deplLogger.isLoggable(logLevel);
        ParsingContext context = this.classParser.getContext();
        boolean isFullAttribute = false;
        if (bundleDesc instanceof BundleDescriptor) {
            isFullAttribute = ((BundleDescriptor)bundleDesc).isFullAttribute();
        }
        Set<String> annotationsToProcess = this.defaultScanner.getAnnotations(isFullAttribute);
        for (String annotation : annotationsToProcess) {
            Type type = context.getTypes().getBy(annotation);
            if (type == null) continue;
            if (type instanceof AnnotationType) {
                AnnotationType at = (AnnotationType)type;
                for (AnnotatedElement ae : at.allAnnotatedTypes()) {
                    Object t = ae instanceof Member ? ((Member)ae).getDeclaringType() : (Type)ae;
                    if (!t.wasDefinedIn(this.scannedURI)) continue;
                    if (shouldLog) {
                        if (Level.INFO.equals(logLevel)) {
                            deplLogger.log(Level.INFO, ANNOTATION_ADDED, new Object[]{t.getName(), ae.getName(), at.getName()});
                        } else {
                            deplLogger.log(Level.FINE, "Adding {0} since {1} is annotated with {2}", new Object[]{t.getName(), ae.getName(), at.getName()});
                        }
                    }
                    this.entries.add(t.getName());
                }
                continue;
            }
            if (type instanceof InterfaceModel) {
                InterfaceModel im = (InterfaceModel)type;
                for (ClassModel cm : im.allImplementations()) {
                    if (shouldLog) {
                        if (Level.INFO.equals(logLevel)) {
                            deplLogger.log(Level.INFO, INTERFACE_ADDED, new Object[]{cm.getName(), im.getName()});
                        } else {
                            deplLogger.log(Level.FINE, "Adding {0} since it is implementing {1}", new Object[]{cm.getName(), im.getName()});
                        }
                    }
                    this.entries.add(cm.getName());
                }
                continue;
            }
            deplLogger.log(Level.SEVERE, INCORRECT_ANNOTATION, annotation);
        }
        if (deplLogger.isLoggable(Level.FINE)) {
            deplLogger.log(Level.FINE, "Done with results");
        }
    }

    protected void addScanClassName(String className) {
        if (className != null && className.length() != 0) {
            this.entries.add(className);
        }
    }

    protected void addScanJar(File jarFile) throws IOException {
        try {
            if (!jarFile.exists()) {
                return;
            }
            this.scannedURI.add(jarFile.toURI());
            if (this.needScanAnnotation) {
                this.classParser.parse(jarFile, null);
            }
        }
        catch (ZipException ze) {
            deplLogger.log(Level.WARNING, JAR_EXCEPTION, new Object[]{ze.getMessage(), jarFile.getPath()});
        }
    }

    protected void addScanURI(URI jarURI) throws IOException {
        this.addScanJar(new File(jarURI));
    }

    protected void addScanDirectory(File directory) throws IOException {
        this.scannedURI.add(directory.toURI());
        if (this.needScanAnnotation) {
            this.classParser.parse(directory, null);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Set<Class> getElements() {
        return this.getElements(this.entries);
    }

    public Set<Class> getElements(Set<String> classNames) {
        HashSet<Class> elements = new HashSet<Class>();
        if (this.getClassLoader() == null) {
            deplLogger.log(Level.SEVERE, NO_CLASSLOADER);
            return elements;
        }
        for (String className : classNames) {
            if (deplLogger.isLoggable(Level.FINE)) {
                deplLogger.log(Level.FINE, "Getting {0}", className);
            }
            try {
                elements.add(this.classLoader.loadClass(className));
            }
            catch (NoClassDefFoundError err) {
                deplLogger.log(Level.WARNING, ANNOTATION_ERROR, err);
            }
            catch (ClassNotFoundException cnfe) {
                LogRecord lr = new LogRecord(Level.WARNING, CLASSLOADING_ERROR);
                Object[] args = new Object[]{className, cnfe.getMessage()};
                lr.setParameters(args);
                lr.setThrown(cnfe);
                deplLogger.log(lr);
            }
        }
        return elements;
    }

    protected void addLibraryJars(T bundleDesc, ReadableArchive moduleArchive) {
        List<Object> libraryURIs = new ArrayList();
        try {
            if (bundleDesc instanceof BundleDescriptor) {
                libraryURIs = DOLUtils.getLibraryJarURIs((BundleDescriptor)bundleDesc, moduleArchive);
            }
            for (URI uri : libraryURIs) {
                File libFile = new File(uri);
                if (libFile.isFile()) {
                    this.addScanJar(libFile);
                    continue;
                }
                if (!libFile.isDirectory()) continue;
                this.addScanDirectory(libFile);
            }
        }
        catch (Exception ex) {
            deplLogger.log(Level.WARNING, LIBRARY_JAR_ERROR, ex.getMessage());
        }
    }

    public Types getTypes() {
        return this.classParser.getContext().getTypes();
    }

    protected void setParser(Parser parser) {
        if (parser == null) {
            ParsingContext pc = new ParsingContext.Builder().logger(deplLogger).executorService(this.executorService.getUnderlyingExecutorService()).build();
            parser = new Parser(pc);
            this.needScanAnnotation = true;
        }
        this.classParser = parser;
    }
}

