/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.boot.runtime;

import fish.payara.boot.runtime.BootCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.embeddable.CommandRunner;

public class BootCommands {
    private static final Pattern COMMAND_FLAG_PATTERN = Pattern.compile("([^\"']\\S+=[\"'](?:(?!(?<!\\\\)[\"']).)*[\"']|[^\"']\\S*|[\"'](?:(?!(?<!\\\\)\").)*[\"'])\\s*");
    private final List<BootCommand> commands = new LinkedList<BootCommand>();
    private static final Logger LOGGER = Logger.getLogger(BootCommands.class.getName());

    public void add(BootCommand command) {
        this.commands.add(command);
    }

    public List<BootCommand> getCommands() {
        return this.commands;
    }

    public void parseCommandScript(File file) throws IOException {
        this.parseCommandScript(file.toURI().toURL());
    }

    public void parseCommandScript(URL scriptURL) throws IOException {
        try (InputStream scriptStream = scriptURL.openStream();){
            InputStreamReader reader = new InputStreamReader(scriptStream);
            this.parseCommandScript(reader);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    void parseCommandScript(Reader reader) throws IOException {
        BufferedReader bufferReader = new BufferedReader(reader);
        String commandStr = bufferReader.readLine();
        while (commandStr != null) {
            if ((commandStr = commandStr.trim()).length() > 0 && !commandStr.startsWith("#")) {
                commandStr = TranslatedConfigView.expandValue(commandStr);
                ArrayList<String> elements = new ArrayList<String>();
                Matcher flagMatcher = COMMAND_FLAG_PATTERN.matcher(commandStr);
                while (flagMatcher.find()) {
                    elements.add(flagMatcher.group(1));
                }
                String[] command = elements.toArray(new String[elements.size()]);
                if (command.length > 1) {
                    this.commands.add(new BootCommand(command[0], Arrays.copyOfRange(command, 1, command.length)));
                } else if (command.length == 1) {
                    this.commands.add(new BootCommand(command[0], new String[0]));
                }
            }
            commandStr = bufferReader.readLine();
        }
    }

    public boolean executeCommands(CommandRunner runner) {
        return this.executeCommands(runner, false);
    }

    public boolean executeCommands(CommandRunner runner, boolean stopOnFailure) {
        boolean result = true;
        for (BootCommand command : this.commands) {
            boolean commandResult = command.execute(runner);
            if (stopOnFailure && !commandResult) {
                return commandResult;
            }
            result = commandResult && result;
        }
        return result;
    }
}

