/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.customvalidators.NotDuplicateTargetName;
import com.sun.enterprise.config.serverbeans.customvalidators.NotTargetKeyword;
import fish.payara.enterprise.config.serverbeans.DGServerRef;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Payload;
import javax.validation.constraints.Pattern;
import org.glassfish.api.Param;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
@NotDuplicateTargetName(message="{dg.duplicate.name}", payload={DeploymentGroup.class})
public interface DeploymentGroup
extends Named,
Payload,
RefContainer,
PropertyBag {
    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @NotTargetKeyword(message="{dg.reserved.name}", payload={DeploymentGroup.class})
    @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="{dg.invalid.name}", payload={DeploymentGroup.class})
    public @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="{dg.invalid.name}", payload={DeploymentGroup.class}) String getName();

    @Element
    public List<DGServerRef> getDGServerRef();

    @DuckTyped
    public List<Server> getInstances();

    @DuckTyped
    public DGServerRef getDGServerRefByRef(String var1);

    @DuckTyped
    public ApplicationRef getApplicationRef(String var1);

    @DuckTyped
    public ResourceRef getResourceRef(String var1);

    @DuckTyped
    public boolean isResourceRefExists(String var1);

    @DuckTyped
    public void createResourceRef(String var1, String var2) throws TransactionFailure;

    @DuckTyped
    public void deleteResourceRef(String var1) throws TransactionFailure;

    @Element
    @PropertiesDesc(props={})
    public List<Property> getProperty();

    public static class Duck {
        public static List<Server> getInstances(DeploymentGroup me) {
            Dom clusterDom = Dom.unwrap((ConfigBeanProxy)me);
            Domain domain = (Domain)clusterDom.getHabitat().getService(Domain.class, new Annotation[0]);
            ArrayList<Server> instances = new ArrayList<Server>();
            for (DGServerRef sRef : me.getDGServerRef()) {
                Server svr = domain.getServerNamed(sRef.getRef());
                if (svr == null) continue;
                instances.add(domain.getServerNamed(sRef.getRef()));
            }
            return instances;
        }

        public static DGServerRef getDGServerRefByRef(DeploymentGroup me, String name) {
            for (DGServerRef ref : me.getDGServerRef()) {
                if (!ref.getRef().equals(name)) continue;
                return ref;
            }
            return null;
        }

        public static ApplicationRef getApplicationRef(DeploymentGroup me, String appName) {
            for (ApplicationRef appRef : me.getApplicationRef()) {
                if (!appRef.getRef().equals(appName)) continue;
                return appRef;
            }
            return null;
        }

        public static ResourceRef getResourceRef(DeploymentGroup me, String refName) {
            for (ResourceRef ref : me.getResourceRef()) {
                if (!ref.getRef().equals(refName)) continue;
                return ref;
            }
            return null;
        }

        public static boolean isResourceRefExists(DeploymentGroup me, String refName) {
            return Duck.getResourceRef(me, refName) != null;
        }

        public static void deleteResourceRef(DeploymentGroup me, String refName) throws TransactionFailure {
            ResourceRef ref = Duck.getResourceRef(me, refName);
            if (ref != null) {
                ConfigSupport.apply(param -> param.getResourceRef().remove(ref), (ConfigBeanProxy)me);
            }
        }

        public static void createResourceRef(DeploymentGroup me, String enabled, String refName) throws TransactionFailure {
            ConfigSupport.apply(param -> {
                ResourceRef newResourceRef = (ResourceRef)param.createChild(ResourceRef.class);
                newResourceRef.setEnabled(enabled);
                newResourceRef.setRef(refName);
                param.getResourceRef().add(newResourceRef);
                return newResourceRef;
            }, (ConfigBeanProxy)me);
        }
    }
}

