/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cdi.jsr107;

import fish.payara.cdi.jsr107.AbstractJSR107Interceptor;
import fish.payara.cdi.jsr107.implementation.PayaraCacheKeyInvocationContext;
import javax.annotation.Priority;
import javax.cache.Cache;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@CacheRemoveAll
@Interceptor
@Priority(value=4000)
public class CacheRemoveAllInterceptor
extends AbstractJSR107Interceptor {
    @AroundInvoke
    public Object cacheRemoveAll(InvocationContext ctx) throws Throwable {
        if (!this.isEnabled()) {
            return ctx.proceed();
        }
        CacheRemoveAll annotation = ctx.getMethod().getAnnotation(CacheRemoveAll.class);
        PayaraCacheKeyInvocationContext<CacheRemoveAll> pctx = new PayaraCacheKeyInvocationContext<CacheRemoveAll>(ctx, annotation);
        if (!annotation.afterInvocation()) {
            this.doRemoveAll(pctx);
        }
        Object result = null;
        try {
            result = ctx.proceed();
        }
        catch (Throwable e) {
            if (annotation.afterInvocation() && this.shouldIEvict(annotation.evictFor(), annotation.noEvictFor(), e)) {
                this.doRemoveAll(pctx);
            }
            throw e;
        }
        if (annotation.afterInvocation()) {
            this.doRemoveAll(pctx);
        }
        return result;
    }

    private void doRemoveAll(PayaraCacheKeyInvocationContext<CacheRemoveAll> pctx) {
        CacheResolverFactory resolverF = pctx.getFactory();
        CacheResolver cacheResolver = resolverF.getCacheResolver(pctx);
        Cache cache = cacheResolver.resolveCache(pctx);
        cache.removeAll();
    }
}

